# Repaso discos

# LVM (Logical Volume Manager)

Un LVM se descompone en tres partes:
- Volúmenes físicos (PV): Son las particiones del disco duro con sistema de archivos LVM. (raid's)
- Grupos de volúmenes (VG): es la parte superior de la LVM. Es la "caja" en la que tenemos nuestros volúmenes lógicos (LV) y nuestros volúmenes físicos (PV). Se puede ver como una unidad administrativa en la que se engloban nuestros recursos. Hay que hacer notar que mientras un PV no se añada al VG, no podemos comenzar a usarlo.
- Volúmenes lógicos (LV): es el equivalente a una partición en un sistema tradicional. El LV es visible como un dispositivo estándar de bloques, por lo que puede contener un sistema de archivos (por ejemplo /home)

```Dibujo
               sda1        sdb    (PV:s, particiones o discos completos)
                     /
                    /
               linuxvg            (VG)
             /    |    
           /      |      
       ubuntu   arch     home     (LV:s)
         |        |       |
       ext4      ext4    xfs      (sistemas de archivos)
```
* https://glatelier.org/2010/01/19/lvm-en-gnulinux-parte-i-que-es-y-a-quien-le-sirve/
* https://glatelier.org/2010/07/12/lvm-en-gnulinux-parte-ii/

# Windows

## Operaciones sobre discos:
- Crear particiones
- Borrar particiones
- Recuperar particiones eliminadas
- Cifrar
- Comprimir
- Convertir entre sistemas de archivos

## Discos dinámicos
http://windows.microsoft.com/es-es/windows-vista/what-are-basic-and-dynamic-disks

## Crear un script que detecta unidades compartidas y mueve los ficheros que contienen a otra unidad
### Detectar unidades
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”)
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”).DeviceID
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk where DriveType = ‘3’”
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "q:"
```
```PowerShell
Get-ChildItem (GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad -Recurse
```
```PowerShell
Get-ChildItem c:\ -Recurse *.txt
Get-ChildItem c:\ -Recurse *.txt | %{copy-Item $_ $dondequierase}
```

### Create a drive mapped to a network share
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/new-psdrive?view=powershell-6
```PowerShell
New-PSDrive -Name "P" -PSProvider "FileSystem" -Root "\\Server01\Public"
```

## PowerShell: Partition verkleinern und neu partitionieren (reducir tamaño de partición y crear una nueva)
https://sid-500.com/2017/09/03/powershell-festplatte-verkleinern-und-neu-partitionieren/

## Recuperar particiones eliminadas
http://www.redeszone.net/windows/como-recuperar-particiones-eliminadas-o-borradas-con-testdisk/

## Hiren's BootCD
http://www.hiren.info/pages/bootcd

# Linux

## Differences between /dev/sda and /dev/sda1
http://serverfault.com/questions/338937/differences-between-dev-sda-and-dev-sda1

## Obtener tipo de partición, UUID y el identificador del nodo. BLKID
```Bash
blkid
```
### Tip: Using UUID for mounting disks, the convenient way
https://access.redhat.com/discussions/1573543

## Muestra información referente a los dispositivos conectados a los puertos USB
```Bash
lsusb
```

## Montar un sistema SMB
```Bash
sudo mount -t cifs //10.0.1.101/copias /mnt/backup
```

## Sincronizar carpetas montadas
```Bash
rsync -rutv --progress --bwlimit=40000 /srv/carpeta/ /mnt/backup/carpeta/
rsync -rutvl --progress --bwlimit=40000 /var/www/web/ /mnt/backup/www
```

## Crear un RAID
https://www.computernetworkingnotes.com/rhce-study-guide/how-to-configure-raid-in-linux-step-by-step-guide.html

## Conectarse desde GNU/Linux a una carpeta Windows compartida (Samba)
http://fraterneo.blogspot.com.es/2011/06/conectarse-desde-gnulinux-una-carpeta.html

## Clonar con Clonezilla
http://clonezilla.org/
