# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```
