# Proyecto: crear usuarios mediante un fichero XML

## Fichero XML de usuarios
```XML
<?xml version="1.0"?>
<alumnos>
	<alumno id="1">
		<usuario>juanito</usuario>
		<grupo>ventas</grupo>
		<programa>notepad</programa>
		<directorio>carpetatrabajo</directorio>
		<permisos>leer</permisos>
	</alumno>
	<alumno id="2">
		<usuario>luis</usuario>
		<grupo>ventas</grupo>
		<programa>p7zip</programa>
		<directorio>carpetatrabajo</directorio>
		<permisos>444</permisos>
	</alumno>
</alumnos>
```

## Fichero JSON de usuarios
```JSON
{
  "alumnos": {
    "alumno": [
      {
        "id": "1",
        "usuario": "juanito",
        "grupo": "ventas",
        "programa": "notepad",
        "directorio": "carpetatrabajo",
        "permisos": "leer"
      },
      {
        "id": "2",
        "usuario": "luis",
        "grupo": "ventas",
        "programa": "p7zip",
        "directorio": "carpetatrabajo",
        "permisos": "444"
      }
    ]
  }
}
```

# Ayuda para realizar el proyecto

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/
