# Proyecto: monitorizar el sistema mediante un fichero XML

## Tareas para monitorizar
- Realizar una función de hash sobre varios ficheros
https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/
- Si se ha actualizado
	- Finding Computers that haven’t installed a special Hotfix
	https://sid-500.com/2018/02/04/powershell-gathering-information-of-all-installed-updates-hotfixes-on-all-domain-computers/
	- Buscar actualizaciones instaladas con PowerShell
	https://www.jesusninoc.com/2017/09/12/buscar-actualizaciones-instaladas-con-powershell/
- Si programa instalado
- Si fichero permisos
- Si usuario ejecuta proceso
- Crear usuario
- Crear grupo
- Obtener información sobre el hardware
https://www.jesusninoc.com/2017/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/

## Fichero XML de monitorización
```XML
<?xml version="1.0"?>
<monitorizar>
	<tarea id="1">
		<nombretarea>Si se ha actualizado</nombretarea>
		<tarea>Get-Hotfix | Where-Object HotfixID -eq "KB3186568"</tarea>
	</tarea>
	<tarea id="2">
		<nombretarea>Si programa instalado</nombretarea>
		<tarea>msiexec</tarea>
		<programa>notepad</programa>
	</tarea>
	<tarea id="3">
		<nombretarea>Si fichero permisos</nombretarea>
		<tarea>icacls</tarea>
		<fichero>directorio</fichero>
	</tarea>
	<tarea id="4">
		<nombretarea>Si usuario ejecuta proceso</nombretarea>
		<tarea>Get-WmiObject win32_process |% {Write-Host $_.processname $_.getowner().user}</tarea>
		<proceso>notepad</proceso>
		<usuario>javier</usuario>
	</tarea>
	<tarea id="5">
		<nombretarea>Crear usuario</nombretarea>
		<tarea>New-LocalUser</tarea>
		<usuario>javier</usuario>
	</tarea>
	<tarea id="6">
		<nombretarea>Realizar una funcion de hash sobre varios ficheros</nombretarea>
		<tarea>Get-FileHash ficheromaestro.txt</tarea>
		<usuario>javier</usuario>
	</tarea>
</monitorizar>
```

## Fichero JSON de monitorización
```JSON
{
  "monitorizar": {
    "tarea": [
      {
        "id": "1",
        "nombretarea": "Si se ha actualizado",
        "tarea": "Get-Hotfix"
      },
      {
        "id": "2",
        "nombretarea": "Si programa instalado",
        "tarea": "msiexec",
        "programa": "notepad"
      },
      {
        "id": "3",
        "nombretarea": "Si fichero permisos",
        "tarea": "icacls",
        "fichero": "directorio"
      },
      {
        "id": "4",
        "nombretarea": "Si usuario ejecuta proceso",
        "tarea": "Get-WmiObject win32_process |% {Write-Host $_.processname $_.getowner().user}",
        "proceso": "notepad",
        "usuario": "javier"
      },
      {
        "id": "5",
        "nombretarea": "Crear usuario",
        "tarea": "New-LocalUser",
        "usuario": "javier"
      },
      {
        "id": "6",
        "nombretarea": "Realizar una funcion de hash sobre varios ficheros",
        "tarea": "Get-FileHash ficheromaestro.txt",
        "usuario": "javier"
      }
    ]
  }
}
```

# Solución en PowerShell
```PowerShell
$monitorizar = '{
  "monitorizar": {
    "tarea": [
      {
        "id": "1",
        "nombretarea": "Si se ha actualizado",
        "tarea": "Get-Hotfix"
      },
      {
        "id": "2",
        "nombretarea": "Si programa instalado",
        "tarea": "msiexec",
        "programa": "notepad"
      },
      {
        "id": "3",
        "nombretarea": "Si fichero permisos",
        "tarea": "icacls",
        "fichero": "directorio"
      },
      {
        "id": "4",
        "nombretarea": "Si usuario ejecuta proceso",
        "tarea": "Get-WmiObject win32_process |% {Write-Host $_.processname}",
      }
    ]
  }
}' | ConvertFrom-Json

$monitorizar.monitorizar.tarea | %{
    $_.nombretarea
    $_.tarea | iex
}
```



# Ayuda para realizar el proyecto

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/
