# Proyecto: crear un fichero XML con información sobre el sistema de archivos

- Buscar el contenido de un fichero de una lista de ficheros:
    - Buscar la palabra "password"
    - Buscar un enlace a un fichero mp3
    - Buscar todos los enlaces que haya con imágenes jpg
- Si se encuentra el contenido enviar los ficheros junto con un fichero XML o JSON

- Si un fichero contiene una cadena, crear un XML y un JSON con los datos del fichero
```PowerShell
Get-ChildItem | %{
    if(Get-Content $_ | Select-String 'password')
    {
        "Existe"
        Get-ChildItem $_ | Select-Object -Property Name | Export-Clixml (((Get-Date).Ticks).ToString()+"fichero.xml")
        Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
    }
}
```

# Solución en PowerShell
```PowerShell
$hash = @{}
$img = 0

Get-Content .\correo.html | %{
    if($_ | Select-String "jpg")
    {
        $img += 1
        $hash.Add("JPG "+$img,$_)
    }
    elseif($_ | Select-String "mp3")
    {
        $hash.Add("MP3",$_)
    }
    elseif($_ | Select-String "textarea")
    {
        $hash.Add("Text",$_ -replace "<.*?>")
    }
}

$object = [PSCustomObject]$hash
$json = $object | Sort-Object Name | ConvertTo-Json
$json
```



# Ayuda para realizar el proyecto

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/
