# Tareas programadas PowerShell

https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/

# Acceso remoto

Utilities like Telnet and remote control programs like Symantec's PC Anywhere let you execute programs on remote systems, but they can be a pain to set up and require that you install client software on the remote systems that you wish to access. PsExec is a light-weight telnet-replacement that lets you execute processes on other systems, complete with full interactivity for console applications, without having to manually install client software. PsExec's most powerful uses include launching interactive command-prompts on remote systems and remote-enabling tools like IpConfig that otherwise do not have the ability to show information about remote systems.

https://docs.microsoft.com/en-us/sysinternals/downloads/psexec

## Ejemplo psexec
```PowerShell
psexec -u jesusninoc\administrador \\2017lti1-19 -i -d cmd /c notepad
psexec -u jesusninoc\administrador \\192.168.104.122 -i -d cmd /c powershell -encodedcommand RwBlAHQALQBEAGEAdABlAA=="
psExec.exe -i \\192.168.1.56 powershell f:\script.ps1 #script.ps1 tiene que existir en el equipo remoto
```
## Starts an interactive session with a remote computer (PowerShell)
```PowerShell
Enter-PSSession -ComputerName 2017lti1-19
```
## Crear una tarea programada en un equipo remoto
```PowerShell
1..254 | %{Invoke-Command -ComputerName ('192.168.1.'+$_) {Register-ScheduledTask Task01 -Action (New-ScheduledTaskAction -Execute "Cmd") -Principal (New-ScheduledTaskPrincipal -GroupId "BUILTIN\administradores" -RunLevel Highest) -Settings (New-ScheduledTaskSettingsSet -RestartCount 5 -RestartInterval 60)}}
```
## Copssh - OpenSSH for Windows
https://itefix.net/copssh

## Introducción a la automatización en PowerShell
https://www.jesusninoc.com/2017/03/06/introduccion-a-la-automatizacion-en-powershell/

## Automation
https://www.jesusninoc.com/automation/

## Mover el ratón a varias posiciones
https://www.jesusninoc.com/2015/01/18/mover-el-raton-a-varias-posiciones/

## Mover Notepad de una posición de la pantalla a otra y escribir un texto dentro del proceso
https://www.jesusninoc.com/2016/03/23/mover-notepad-de-una-posicion-de-la-pantalla-a-otra-y-escribir-un-texto-dentro-del-proceso/

## Mover un proceso en diagonal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/04/11/mover-un-proceso-en-diagonal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Mover un proceso en horizontal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/02/28/mover-un-proceso-en-horizontal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Activar y mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/20/activar-y-mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

## Mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/03/mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

# Servidor de correo

## SMTP
https://www.jesusninoc.com/2015/01/12/instalar-hmailserver-imap-smtp-y-pop3/
