# Ejercicios sobre señales de radio

[![Enviar señales de radio desde Raspberry Pi mediante una conexión SSH desde PowerShell
](https://img.youtube.com/vi/8kglbrLWHrY/0.jpg)](https://www.youtube.com/watch?v=8kglbrLWHrY)

# Enlaces importantes:
* Software-Defined Radio for Engineers https://news.ycombinator.com/item?id=17399554
* https://www.youtube.com/watch?v=8kglbrLWHrY
* https://github.com/markondej/fm_transmitter
* https://www.jesusninoc.com/2016/12/07/ejercicios-de-powershell-dividir-el-contenido-de-una-frase-en-palabras-y-guardar-cada-palabra-en-un-fichero/
* https://www.jesusninoc.com/2016/12/24/leer-palabras-de-un-fichero-y-almacenar-cada-palabra-en-un-fichero-de-audio-mediante-la-voz-del-sistema-operativo/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/10/14/ejecutar-airodump-ng-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjemplosDescomprimir.sh

# Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

# Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

# Enviar mediante señales de radio el fichero que hemos subido
```PowerShell
#Ejecutar fm_transmitter (use Raspberry Pi as FM transmitter)

#Iniciar una sesión SSH
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$sUser = "pi"
$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList $sUser, $Pass
$oSessionSSH = New-SSHSession -ComputerName 192.168.1.161 -Force -Credential $Credential

#Crear canal de comunicación entre PowerShell y Linux (Raspberry Pi)
#Convertirse en sudo para ejecutar fm_transmitter

$stream = $oSessionSSH.Session.CreateShellStream("PS-SSH", 0, 0, 0, 0, 1000)
Invoke-SSHStreamExpectSecureAction -ShellStream $stream -Command "sudo su -" -ExpectString "[sudo] password for $($sUser):" -SecureAction $Pass

#Transmitir por radio en la frecuencia 90 MHz el saludo creado anteriormente
$stream.WriteLine("/home/pi/fmm/fm_transmitter-master/fm_transmitter -f 90 /home/pi/fmm/fm_transmitter-master/saludo.wav")

#Verificar que llega bien la señal desde SDR o desde una radio FM en la frecuencia 90 MHz
```
