# Ejemplos de ficheros

```PowerShell
ls '*.txt'
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')
}
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')[1]
}
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')[1].Replace('.txt','')
}
```

# VER EN POWERSHELL EL SWITCH
https://www.jesusninoc.com/2016/08/09/sentencia-condicional-switch/

# EJERCICIO DE LEER Y REALIZAR OPERACIONES

## Leer del fichero que tiene los usuarios
```PowerShell
$fichero=get-content asignaturas.txt
Get-Content $fichero | % {
$_
}
```

## Leer del fichero que tiene los usuarios y obtener solo la operación que hay que realizar
```PowerShell
$fichero=get-content asignaturas.txt
Get-Content $fichero | % {
$_.split(',')[1]
}
```

## Leer el fichero y detectar la operación a realizar utilizando el if
```PowerShell
$fichero=get-content asignaturas.txt
Get-Content $fichero | % {
if($_.split(',')[1] -eq 0)
{
Write-Host "CREAR"
}
if($_.split(',')[1] -eq 1)
{
Write-Host "ELIMINAR"
}
}
```

# RESULTADO FINAL CON SWITCH DEL EJERCICIO SOBRE LEER Y REALIZAR OPERACIONES
https://github.com/jesnino/PowerShell/blob/master/Ficheros/EjemplosLeerOperacionesTareasBasicasII.ps1

# Ejemplos sobre operaciones
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
echo Suma
break
}
}
```
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
suma
break
}
}

function suma()
{
2+3
}
```

# If en Linux
https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/

# Ejercicio con if UN NÚMERO ES PAR O IMPAR POWERSHELL

## Un número es par?, si el resto es 0. La operación del resto es %
```PowerShell
$numero=5
$numero%2
```

## Comprobar si un número es par
```PowerShell
$numero=5
if($numero%2 -eq 0)
{
"Número par"
}
else
{
"Número impar"
}
```

# Ejercicio con if UN NÚMERO ES PAR O IMPAR LINUX
```Bash
let resto=numero%2
if [ $resto -eq 0 ]; then
echo “El numero $numero es par”
else
echo “El numero $numero es impar”
fi
```
