# PowerShell

## Bucle

### Bucle foreach PowerShell
https://www.jesusninoc.com/2015/09/29/bucles/

### Ejemplos bucle
```PowerShell
for($i=1;$i -lt 10;$i=$i+1){$i}
for($i=10;$i -gt 0;$i=$i-1){$i}
```

## Operadores de comparación
If you are used to operators such as > or < or =, you have to do some rethinking. As with batch scripts, PowerShell uses abbreviations of the corresponding English words.

|Op|Description
|---|---
|eq|Equal
|ne|Not equal
|lt|Less than
|le|Less than or equal
|gt|Greater than
|ge|Greater than or equal

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

# Importante

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```
