# Ejercicios PowerShell sobre variables

## Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
## Mostrar un int desde un char
```PowerShell
[Char]65
```
## Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
## Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
## Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)+1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
## Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)-1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
``` 
## Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```
# Parte especial de la clase (conexión con Linux)

## Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```
## Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
