<!--- DO NOT EDIT - Generated by ToolsLister at 2023-10-16T16:39:39.702387-->
# Supported Report Formats

Jenkins' Warnings Next Generation Plugin supports the following report formats. 
If your tool is supported, but has no custom icon yet, please file a pull request for the
[Warnings Next Generation Plugin](https://github.com/jenkinsci/warnings-ng-plugin/pulls).

If your tool is not yet supported you can
1. define a new Groovy based parser in the user interface
2. export the issues of your tool to the native XML format (or any other format)
3. provide a parser within a new small plugin. 

If the parser is useful for 
other teams as well please share it and provide pull requests for the 
[Warnings Next Generation Plug-in](https://github.com/jenkinsci/warnings-ng-plugin/pulls) and 
the [Analysis Parsers Library](https://github.com/jenkinsci/analysis-model/). 

<table>
    <thead>
        <tr>
            <th>
                ID
            </th>
            <th>
                Pipeline Symbol
            </th>
            <th>
                Icon
            </th>
            <th>
                Name
            </th>
            <th>
                Default Pattern
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>
                acu-cobol
            </td>
            <td>
                acuCobol()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="AcuCobol" height="48" width="48">
            </td>
            <td>
                AcuCobol
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                gnat
            </td>
            <td>
                gnat()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Ada Compiler (gnat)" height="48" width="48">
            </td>
            <td>
                Ada Compiler (gnat)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                android-lint
            </td>
            <td>
                androidLintParser()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/android-lint-48x48.png" alt="Android Lint" height="48" width="48">
            </td>
            <td>
                Android Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use the flag -p.
            </td>
        </tr>
        <tr>
            <td>
                ansiblelint
            </td>
            <td>
                ansibleLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/jenkinsci/warnings-ng-plugin/master/plugin/src/main/resources/images/symbols/cib-ansible.svg" alt="Ansible Lint" height="48" width="48">
            </td>
            <td>
                Ansible Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use the flag -p.
            </td>
        </tr>
        <tr>
            <td>
                scannercli
            </td>
            <td>
                aquaScanner()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Aqua Scanner" height="48" width="48">
            </td>
            <td>
                <a href="https://support.aquasec.com/support/solutions/articles/16000120206">
                    Aqua Scanner
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>scannercli scan &#x27;image&#x27; --jsonfile results.json</code>, see <a href="https://support.aquasec.com/support/solutions/articles/16000120206">Aqua Scanner CLI</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                trivy
            </td>
            <td>
                trivy()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Aquasec Trivy" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/aquasecurity/trivy">
                    Aquasec Trivy
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>trivy image -f json -o results.json &#x27;image&#x27;</code>, see <a href="https://github.com/aquasecurity/trivy">tivy on Github</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                armcc
            </td>
            <td>
                armCc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Armcc Compiler" height="48" width="48">
            </td>
            <td>
                Armcc Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                aspectj
            </td>
            <td>
                ajc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="AspectJ" height="48" width="48">
            </td>
            <td>
                AspectJ
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                axivion-suite
            </td>
            <td>
                axivionSuite()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/axivion-48x48.png" alt="Axivion Suite" height="48" width="48">
            </td>
            <td>
                Axivion Suite
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: For using Axivion Suite, set up your analysis project and the web service. Provide the URL and credentials.
            </td>
        </tr>
        <tr>
            <td>
                bluepearl
            </td>
            <td>
                bluepearl()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Blue Pearl Visual Verification Suite" height="48" width="48">
            </td>
            <td>
                Blue Pearl Visual Verification Suite
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                brakeman
            </td>
            <td>
                brakeman()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/brakeman-48x48.png" alt="Brakeman" height="48" width="48">
            </td>
            <td>
                <a href="https://brakemanscanner.org">
                    Brakeman
                </a>
            </td>
            <td>
                **/brakeman-output.json
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Reads Brakeman JSON reports. Use commandline <code>brakeman -o brakeman-output.json</code> output.<br/>See <a href='https://brakemanscanner.org/docs/jenkins/'>Brakeman documentation</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                buckminster
            </td>
            <td>
                buckminster()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Buckminster" height="48" width="48">
            </td>
            <td>
                Buckminster
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                cadence
            </td>
            <td>
                cadence()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Cadence Incisive" height="48" width="48">
            </td>
            <td>
                Cadence Incisive
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                cargo
            </td>
            <td>
                cargo()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Cargo Check" height="48" width="48">
            </td>
            <td>
                Cargo Check
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>cargo check --message-format json</code>
            </td>
        </tr>
        <tr>
            <td>
                ccm
            </td>
            <td>
                ccm()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CCM" height="48" width="48">
            </td>
            <td>
                CCM
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                checkstyle
            </td>
            <td>
                checkStyle()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/checkstyle.svg" alt="CheckStyle" height="48" width="48">
            </td>
            <td>
                <a href="https://checkstyle.org">
                    CheckStyle
                </a>
            </td>
            <td>
                **/checkstyle-result.xml
            </td>
        </tr>
        <tr>
            <td>
                clair
            </td>
            <td>
                clair()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Clair Scanner" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/arminc/clair-scanner">
                    Clair Scanner
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Reads Clair json data. Use commandline <code>clair-scanner --report="/target/clair.json"</code> output.<br/>See <a href='https://github.com/arminc/clair-scanner'>clair-scanner on Github</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                clang
            </td>
            <td>
                clang()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Clang" height="48" width="48">
            </td>
            <td>
                Clang
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                clang-analyzer
            </td>
            <td>
                clangAnalyzer()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Clang Analyzer" height="48" width="48">
            </td>
            <td>
                <a href="https://clang-analyzer.llvm.org">
                    Clang Analyzer
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use options --analyze --analyzer-output plist-multi-file
            </td>
        </tr>
        <tr>
            <td>
                clang-tidy
            </td>
            <td>
                clangTidy()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Clang-Tidy" height="48" width="48">
            </td>
            <td>
                Clang-Tidy
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                cmake
            </td>
            <td>
                cmake()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CMake" height="48" width="48">
            </td>
            <td>
                CMake
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                code-analysis
            </td>
            <td>
                codeAnalysis()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Code Analysis" height="48" width="48">
            </td>
            <td>
                Code Analysis
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                code-generator
            </td>
            <td>
                codeGeneratorParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Code Generator Tool" height="48" width="48">
            </td>
            <td>
                <a href="https://www.mathworks.com/help/stats/code-generation.html">
                    Code Generator Tool
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                code-checker
            </td>
            <td>
                codeChecker()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CodeChecker" height="48" width="48">
            </td>
            <td>
                CodeChecker
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                codenarc
            </td>
            <td>
                codeNarc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CodeNarc" height="48" width="48">
            </td>
            <td>
                CodeNarc
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                coolflux
            </td>
            <td>
                coolflux()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Coolflux DSP Compiler" height="48" width="48">
            </td>
            <td>
                Coolflux DSP Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                cpd
            </td>
            <td>
                cpd()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/regular/clone.svg" alt="CPD" height="48" width="48">
            </td>
            <td>
                <a href="https://pmd.github.io/latest/pmd_userdocs_cpd.html">
                    CPD
                </a>
            </td>
            <td>
                **/cpd.xml
            </td>
        </tr>
        <tr>
            <td>
                cppcheck
            </td>
            <td>
                cppCheck()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CPPCheck" height="48" width="48">
            </td>
            <td>
                CPPCheck
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use options --xml --xml-version=2
            </td>
        </tr>
        <tr>
            <td>
                cpplint
            </td>
            <td>
                cppLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Cpplint" height="48" width="48">
            </td>
            <td>
                Cpplint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: You need to use the Eclipse format with the option <code>--output=eclipse</code>
            </td>
        </tr>
        <tr>
            <td>
                crosscore-embedded-studio
            </td>
            <td>
                CrossCoreEmbeddedStudioParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CrossCore Embedded Studio (CCES)" height="48" width="48">
            </td>
            <td>
                <a href="https://www.analog.com/en/design-center/evaluation-hardware-and-software/software/adswt-cces.html">
                    CrossCore Embedded Studio (CCES)
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                csslint
            </td>
            <td>
                cssLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="CSS-Lint" height="48" width="48">
            </td>
            <td>
                CSS-Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                dart
            </td>
            <td>
                dart()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Dart Analyze" height="48" width="48">
            </td>
            <td>
                <a href="https://dart.dev/">
                    Dart Analyze
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                detekt
            </td>
            <td>
                detekt()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Detekt" height="48" width="48">
            </td>
            <td>
                <a href="https://detekt.github.io/detekt">
                    Detekt
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --output-format xml.
            </td>
        </tr>
        <tr>
            <td>
                docfx
            </td>
            <td>
                docFx()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="DocFX" height="48" width="48">
            </td>
            <td>
                DocFX
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                dockerlint
            </td>
            <td>
                dockerLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Dockerfile Lint" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/projectatomic/dockerfile_lint">
                    Dockerfile Lint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>dockerfile_lint -j</code> output.<br/>See <a href='https://github.com/projectatomic/dockerfile_lint'>dockerfile_lint on Github</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                doxygen
            </td>
            <td>
                doxygen()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Doxygen" height="48" width="48">
            </td>
            <td>
                Doxygen
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Execute doxygen:As <b>shell</b> command <code>( cat Doxyfile; echo WARN_FORMAT='$file:$line: $text' ) | doxygen -</code>As <b>batch</b> command <code>( type Doxyfile & echo WARN_FORMAT='$file:$line: $text' ) | doxygen -</code>
            </td>
        </tr>
        <tr>
            <td>
                dr-memory
            </td>
            <td>
                drMemory()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Dr. Memory" height="48" width="48">
            </td>
            <td>
                Dr. Memory
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                dscanner
            </td>
            <td>
                dscanner()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="DScanner" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/dlang-community/D-Scanner">
                    DScanner
                </a>
            </td>
            <td>
                **/dscanner-report.json
            </td>
        </tr>
        <tr>
            <td>
                eclipse
            </td>
            <td>
                eclipse()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Eclipse ECJ" height="48" width="48">
            </td>
            <td>
                Eclipse ECJ
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p><p>Create an output file that contains Eclipse ECJ output, in either XML or text format.</p><p>To log in XML format, specify &quot;.xml&quot; as the file extension to the -log argument:</p><p><code>java -jar ecj.jar -log &lt;logfile&gt;.xml &lt;other arguments&gt;</code></p><p>To log in text format, specify any file extension except &quot;.xml&quot; to the -log argument:</p><p><code>java -jar ecj.jar -log &lt;logfile&gt;.log &lt;other arguments&gt;</code></p></p>
            </td>
        </tr>
        <tr>
            <td>
                embedded-engineer
            </td>
            <td>
                embeddedEngineerParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Embedded Engineer Tool" height="48" width="48">
            </td>
            <td>
                <a href="https://www.lieberlieber.com/embedded-engineer/">
                    Embedded Engineer Tool
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                erlc
            </td>
            <td>
                erlc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Erlang Compiler (erlc)" height="48" width="48">
            </td>
            <td>
                Erlang Compiler (erlc)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                error-prone
            </td>
            <td>
                errorProne()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/bug.svg" alt="Error Prone" height="48" width="48">
            </td>
            <td>
                <a href="https://errorprone.info">
                    Error Prone
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                eslint
            </td>
            <td>
                esLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/eslint.svg" alt="ESLint" height="48" width="48">
            </td>
            <td>
                <a href="https://eslint.org">
                    ESLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --format checkstyle.
            </td>
        </tr>
        <tr>
            <td>
                findbugs
            </td>
            <td>
                findBugs()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/findbugs-48x48.png" alt="FindBugs" height="48" width="48">
            </td>
            <td>
                FindBugs
            </td>
            <td>
                **/findbugsXml.xml
            </td>
        </tr>
        <tr>
            <td>
                flake8
            </td>
            <td>
                flake8()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Flake8" height="48" width="48">
            </td>
            <td>
                <a href="https://flake8.pycqa.org/">
                    Flake8
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p>Run flake8 as <code>flake8 --format=pylint</code></p>
            </td>
        </tr>
        <tr>
            <td>
                flawfinder
            </td>
            <td>
                flawfinder()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="FlawFinder" height="48" width="48">
            </td>
            <td>
                <a href="https://dwheeler.com/flawfinder/">
                    FlawFinder
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>flawfinder -S</code>.
            </td>
        </tr>
        <tr>
            <td>
                flex
            </td>
            <td>
                flexSdk()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Flex SDK Compiler" height="48" width="48">
            </td>
            <td>
                Flex SDK Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                fxcop
            </td>
            <td>
                fxcop()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="FxCop" height="48" width="48">
            </td>
            <td>
                FxCop
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                gendarme
            </td>
            <td>
                gendarme()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Gendarme" height="48" width="48">
            </td>
            <td>
                Gendarme
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                ghs-multi
            </td>
            <td>
                ghsMulti()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="GHS Multi Compiler" height="48" width="48">
            </td>
            <td>
                GHS Multi Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                gcc
            </td>
            <td>
                gcc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="GNU C Compiler (gcc)" height="48" width="48">
            </td>
            <td>
                GNU C Compiler (gcc)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                gcc3
            </td>
            <td>
                gcc3()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="GNU C Compiler 3 (gcc)" height="48" width="48">
            </td>
            <td>
                GNU C Compiler 3 (gcc)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                fortran
            </td>
            <td>
                gnuFortran()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="GNU Fortran Compiler" height="48" width="48">
            </td>
            <td>
                GNU Fortran Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                golint
            </td>
            <td>
                goLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/golint-48x48.png" alt="Go Lint" height="48" width="48">
            </td>
            <td>
                Go Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                go-vet
            </td>
            <td>
                goVet()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Go Vet" height="48" width="48">
            </td>
            <td>
                Go Vet
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                groovy
            </td>
            <td>
                groovyScript()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Groovy Parser" height="48" width="48">
            </td>
            <td>
                Groovy Parser
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                grype
            </td>
            <td>
                grype()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Grype" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/anchore/grype">
                    Grype
                </a>
            </td>
            <td>
                **/grype-report.json
            </td>
        </tr>
        <tr>
            <td>
                hadolint
            </td>
            <td>
                hadoLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/hadolint-48x48.png" alt="HadoLint" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/hadolint/hadolint">
                    HadoLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>hadolint --format json Dockerfile</code> output.<br/>See <a href='https://github.com/hadolint/hadolint'>hadolint on Github</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                iar-cstat
            </td>
            <td>
                iarCstat()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="IAR C-STAT" height="48" width="48">
            </td>
            <td>
                IAR C-STAT
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p>The IAR C-STAT static analysis tool finds potential issues in code by doing an analysis on the source code level. Use the following icstat command to generate the output on stdout in the correct format: <pre><code>icstat --db a.db --checks checks.ch commands commands.txt</code></pre> where the commands.txt contains: <pre><code>analyze - iccxxxxcompiler_opts cstat1.c
analyze - iccxxxxcompiler_opts cstat2.c</pre></code>For details check the IAR C-STAT guide.</p>
            </td>
        </tr>
        <tr>
            <td>
                iar
            </td>
            <td>
                iar()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="IAR Compiler (C/C++)" height="48" width="48">
            </td>
            <td>
                IAR Compiler (C/C++)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: The IAR compilers need to be started with option <strong>--no_wrap_diagnostics</strong>. Then the IAR compilers will create single-line warnings.
            </td>
        </tr>
        <tr>
            <td>
                iblinter
            </td>
            <td>
                ibLinter()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="IbLinter" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/IBDecodable/IBLinter">
                    IbLinter
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use configuration reporter: \”checkstyle\”.
            </td>
        </tr>
        <tr>
            <td>
                xlc
            </td>
            <td>
                xlc()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="IBM XLC Compiler" height="48" width="48">
            </td>
            <td>
                IBM XLC Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                infer
            </td>
            <td>
                infer()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Infer" height="48" width="48">
            </td>
            <td>
                <a href="https://fbinfer.com">
                    Infer
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --pmd-xml.
            </td>
        </tr>
        <tr>
            <td>
                intel
            </td>
            <td>
                intel()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Intel Compiler (C, Fortran)" height="48" width="48">
            </td>
            <td>
                Intel Compiler (C, Fortran)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                idea
            </td>
            <td>
                ideaInspection()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/idea-48x48.png" alt="IntelliJ IDEA Inspections" height="48" width="48">
            </td>
            <td>
                <a href="https://www.jetbrains.com/help/idea/code-inspection.html">
                    IntelliJ IDEA Inspections
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                java
            </td>
            <td>
                java()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/java.svg" alt="Java Compiler" height="48" width="48">
            </td>
            <td>
                Java Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                javadoc-warnings
            </td>
            <td>
                javaDoc()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/java.svg" alt="JavaDoc" height="48" width="48">
            </td>
            <td>
                JavaDoc
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                jc-report
            </td>
            <td>
                jcReport()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="JCReport" height="48" width="48">
            </td>
            <td>
                JCReport
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                js-hint
            </td>
            <td>
                jsHint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="JsHint" height="48" width="48">
            </td>
            <td>
                JsHint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                jslint
            </td>
            <td>
                jsLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="JSLint" height="48" width="48">
            </td>
            <td>
                <a href="https://www.jslint.com">
                    JSLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                junit
            </td>
            <td>
                junitParser()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/junit-48x48.png" alt="JUnit" height="48" width="48">
            </td>
            <td>
                <a href="https://junit.org">
                    JUnit
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                klocwork
            </td>
            <td>
                klocWork()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Klocwork" height="48" width="48">
            </td>
            <td>
                Klocwork
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                kotlin
            </td>
            <td>
                kotlin()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/kotlin-48x48.png" alt="Kotlin" height="48" width="48">
            </td>
            <td>
                Kotlin
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                ktlint
            </td>
            <td>
                ktLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/ktlint-48x48.png" alt="KtLint" height="48" width="48">
            </td>
            <td>
                <a href="https://ktlint.github.io">
                    KtLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --reporter=checkstyle.
            </td>
        </tr>
        <tr>
            <td>
                maven-warnings
            </td>
            <td>
                mavenConsole()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Maven" height="48" width="48">
            </td>
            <td>
                Maven
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                taglist
            </td>
            <td>
                tagList()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Maven Taglist Plugin" height="48" width="48">
            </td>
            <td>
                <a href="https://www.mojohaus.org/taglist-maven-plugin">
                    Maven Taglist Plugin
                </a>
            </td>
            <td>
                **/taglist.xml
            </td>
        </tr>
        <tr>
            <td>
                modelsim
            </td>
            <td>
                modelsim()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Mentor Graphics Modelsim/Questa Simulators" height="48" width="48">
            </td>
            <td>
                Mentor Graphics Modelsim/Questa Simulators
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                metrowerks
            </td>
            <td>
                metrowerksCodeWarrior()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Metrowerks CodeWarrior Compiler" height="48" width="48">
            </td>
            <td>
                Metrowerks CodeWarrior Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p><p>Ensure that the output from the CodeWarrior build tools is in the expected format. If there are warnings present, but they are not found, then it is likely that the format is incorrect. The mwccarm compiler and mwldarm linker tools may support a configurable message style. This can be used to enforce the expected output format, which may be different from Metrowerks CodeWarrior (and thus require a different tool). For example the following could be appended to the build flags:</p><p><code>-msgstyle gcc -nowraplines</code></p></p>
            </td>
        </tr>
        <tr>
            <td>
                msbuild
            </td>
            <td>
                msBuild()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="MSBuild" height="48" width="48">
            </td>
            <td>
                MSBuild
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                mypy
            </td>
            <td>
                myPy()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="MyPy" height="48" width="48">
            </td>
            <td>
                MyPy
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                nag-fortran
            </td>
            <td>
                nagFortran()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="NAG Fortran Compiler" height="48" width="48">
            </td>
            <td>
                NAG Fortran Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                issues
            </td>
            <td>
                issues()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Native Analysis Model Format" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/jenkinsci/warnings-ng-plugin/blob/master/doc/Documentation.md#export-your-issues-into-a-supported-format">
                    Native Analysis Model Format
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p>Create an output file that contains issues in the native Warnings Plugin format, in either XML or JSON. The supported format is identical to the format of the remote API calls. The parser is even capable of reading individual lines of a log file that contains issues in JSON format.</p>
            </td>
        </tr>
        <tr>
            <td>
                oelint-adv
            </td>
            <td>
                oelintAdv()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="oelint-adv" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/priv-kweihmann/oelint-adv">
                    oelint-adv
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                open-tasks
            </td>
            <td>
                taskScanner()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/clipboard-check.svg" alt="Open Tasks Scanner" height="48" width="48">
            </td>
            <td>
                Open Tasks Scanner
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                invalids
            </td>
            <td>
                invalids()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Oracle Invalids" height="48" width="48">
            </td>
            <td>
                Oracle Invalids
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                ot-docker-linter
            </td>
            <td>
                otDockerLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/ot-docker-linter-48x48.png" alt="OT Docker Linter" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/opstree/OT-Dockerlinter">
                    OT Docker Linter
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>ot-docker-linter audit --docker.file Dockerfile -o json</code> output.<br/>See <a href='https://github.com/opstree/OT-Dockerlinter'>ot-docker-linter on Github</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                owasp-dependency-check
            </td>
            <td>
                owaspDependencyCheck()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="OWASP Dependency Check" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/jeremylong/DependencyCheck">
                    OWASP Dependency Check
                </a>
            </td>
            <td>
                **/dependency-check-report.json
            </td>
        </tr>
        <tr>
            <td>
                pclint
            </td>
            <td>
                pcLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PC-Lint Tool" height="48" width="48">
            </td>
            <td>
                PC-Lint Tool
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p>Use the following PC-Lint properties to create an output file in the correct format: <pre><code>-v // turn off verbosity
-width(0) // don't insert line breaks (unlimited output width)
-"format=%f(%l): %t %n: %m"
-hs1 // The height of a message should be 1
</code></pre></p>
            </td>
        </tr>
        <tr>
            <td>
                pep8
            </td>
            <td>
                pep8()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PEP8" height="48" width="48">
            </td>
            <td>
                PEP8
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                perforce
            </td>
            <td>
                perforce()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Perforce Compiler" height="48" width="48">
            </td>
            <td>
                Perforce Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                perl-critic
            </td>
            <td>
                perlCritic()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Perl::Critic" height="48" width="48">
            </td>
            <td>
                Perl::Critic
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                php
            </td>
            <td>
                php()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PHP Runtime" height="48" width="48">
            </td>
            <td>
                PHP Runtime
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                php-code-sniffer
            </td>
            <td>
                phpCodeSniffer()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PHP_CodeSniffer" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/squizlabs/PHP_CodeSniffer">
                    PHP_CodeSniffer
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --report=checkstyle.
            </td>
        </tr>
        <tr>
            <td>
                phpstan
            </td>
            <td>
                phpStan()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/phpstan-48x48.png" alt="PHPStan" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/phpstan/phpstan">
                    PHPStan
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use the options: --no-progress --error-format=checkstyle
            </td>
        </tr>
        <tr>
            <td>
                pit
            </td>
            <td>
                pit()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/pit-48x48.png" alt="PIT" height="48" width="48">
            </td>
            <td>
                <a href="https://pitest.org">
                    PIT
                </a>
            </td>
            <td>
                **/mutations.xml
            </td>
        </tr>
        <tr>
            <td>
                pmd
            </td>
            <td>
                pmdParser()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/pmd-48x48.png" alt="PMD" height="48" width="48">
            </td>
            <td>
                <a href="https://pmd.github.io">
                    PMD
                </a>
            </td>
            <td>
                **/pmd.xml
            </td>
        </tr>
        <tr>
            <td>
                polyspace-parser
            </td>
            <td>
                polyspaceParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Polyspace Tool" height="48" width="48">
            </td>
            <td>
                <a href="https://www.mathworks.com/products/polyspace.html">
                    Polyspace Tool
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Reads reports of Polyspace Static Analysis Tool by MathWorks. Used for <a href='https://www.mathworks.com/help/bugfinder/ref/polyspaceresultsexport.html?s_tid=srchtitle_polyspace-results-export_1'>BugFinder</a> and  <a href='https://www.mathworks.com/help/codeprover/ref/polyspaceresultsexport.html?s_tid=srchtitle_polyspace-results-export_2'>CodeProver</a> result files.<br/>Report can be generated with command: polyspace-results-export -format csv -results-dir <RESULTS> -output-name <CSVFILE> -key <KEY>
            </td>
        </tr>
        <tr>
            <td>
                prefast
            </td>
            <td>
                prefast()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PREfast" height="48" width="48">
            </td>
            <td>
                PREfast
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                protolint
            </td>
            <td>
                protoLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="ProtoLint" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/yoheimuta/protolint">
                    ProtoLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                puppetlint
            </td>
            <td>
                puppetLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Puppet Lint" height="48" width="48">
            </td>
            <td>
                Puppet Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: You will need a recent enough version that supports <code>--log-format flag</code>. When running puppet-lint, make sure you use the log format <code>%{path}:%{line}:%{check}:%{KIND}:%{message}</code>. <br> Complete example: <br> <code>find. -iname *.pp -exec puppet-lint --log-format &quot;%{path}:%{line}:%{check}:%{KIND}:%{message}&quot; {} \;</code>
            </td>
        </tr>
        <tr>
            <td>
                pvs-studio
            </td>
            <td>
                PVSStudio()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/pvs-48x48.png" alt="PVS-Studio" height="48" width="48">
            </td>
            <td>
                <a href="https://pvs-studio.com/en/pvs-studio/">
                    PVS-Studio
                </a>
            </td>
            <td>
                **/*.plog
            </td>
        </tr>
        <tr>
            <td>
                pydocstyle
            </td>
            <td>
                pyDocStyle()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="PyDocStyle" height="48" width="48">
            </td>
            <td>
                PyDocStyle
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                pylint
            </td>
            <td>
                pyLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/pylint-48x48.png" alt="Pylint" height="48" width="48">
            </td>
            <td>
                Pylint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: <p>Start Pylint using this custom message template (can also be configured via a pylintrc configuration file):<p><code>pylint --msg-template='{path}:{line}: [{msg_id}, {obj}] {msg} ({symbol})' modules_or_packages > pylint.log</code></p></p>
            </td>
        </tr>
        <tr>
            <td>
                qac
            </td>
            <td>
                qacSourceCodeAnalyser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="QA-C Sourcecode Analyser" height="48" width="48">
            </td>
            <td>
                QA-C Sourcecode Analyser
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                qt-translation
            </td>
            <td>
                qtTranslation()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/qt-48x48.png" alt="Qt translations" height="48" width="48">
            </td>
            <td>
                <a href="https://www.qt.io">
                    Qt translations
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Reads translation files of Qt, which are created by "lupdate" or "Linguist".
            </td>
        </tr>
        <tr>
            <td>
                analysis-model
            </td>
            <td>
                analysisParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Registered Parser" height="48" width="48">
            </td>
            <td>
                Registered Parser
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                dupfinder
            </td>
            <td>
                dupFinder()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/regular/clone.svg" alt="Resharper DupFinder" height="48" width="48">
            </td>
            <td>
                Resharper DupFinder
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                resharper
            </td>
            <td>
                resharperInspectCode()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/resharper-48x48.png" alt="Resharper Inspections" height="48" width="48">
            </td>
            <td>
                Resharper Inspections
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                revapi
            </td>
            <td>
                revApi()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Revapi" height="48" width="48">
            </td>
            <td>
                <a href="https://revapi.org/revapi-site/main/index.html">
                    Revapi
                </a>
            </td>
            <td>
                **/target/revapi-result.json
            </td>
        </tr>
        <tr>
            <td>
                robocopy
            </td>
            <td>
                robocopy()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Robocopy" height="48" width="48">
            </td>
            <td>
                Robocopy
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                rflint
            </td>
            <td>
                rfLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/robot-framework-48x48.png" alt="Robot Framework Lint" height="48" width="48">
            </td>
            <td>
                Robot Framework Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                rubocop
            </td>
            <td>
                ruboCop()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/rubocop-48x48.png" alt="Rubocop" height="48" width="48">
            </td>
            <td>
                Rubocop
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>rubocop --format progress</code>.
            </td>
        </tr>
        <tr>
            <td>
                sarif
            </td>
            <td>
                sarif()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="SARIF" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/oasis-tcs/sarif-spec">
                    SARIF
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                scala
            </td>
            <td>
                scala()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/scala-48x48.png" alt="Scala Compiler" height="48" width="48">
            </td>
            <td>
                Scala Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                simian
            </td>
            <td>
                simian()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/regular/clone.svg" alt="Simian" height="48" width="48">
            </td>
            <td>
                Simian
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                simulink-check-parser
            </td>
            <td>
                simulinkCheckParser()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Simulink Check Tool" height="48" width="48">
            </td>
            <td>
                <a href="https://www.mathworks.com/products/simulink-check.html">
                    Simulink Check Tool
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Reads and Parses HTML reports of Simulink Check Tool by MathWorks. Report can be generated with command: <code>ModelAdvisor.summaryReport(ModelAdvisor.run(<SYSTEMS>, <CONFIG>, <FILENAME>, <ARGS>))</code>
            </td>
        </tr>
        <tr>
            <td>
                sonar
            </td>
            <td>
                sonarQube()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/sonar-48x48.png" alt="SonarQube Issues" height="48" width="48">
            </td>
            <td>
                SonarQube Issues
            </td>
            <td>
                **/sonar-report.json
            </td>
        </tr>
        <tr>
            <td>
                sphinx
            </td>
            <td>
                sphinxBuild()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Sphinx Build" height="48" width="48">
            </td>
            <td>
                Sphinx Build
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                spotbugs
            </td>
            <td>
                spotBugs()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/spotbugs.svg" alt="SpotBugs" height="48" width="48">
            </td>
            <td>
                <a href="https://spotbugs.github.io">
                    SpotBugs
                </a>
            </td>
            <td>
                **/spotbugsXml.xml
            </td>
        </tr>
        <tr>
            <td>
                stylecop
            </td>
            <td>
                styleCop()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="StyleCop" height="48" width="48">
            </td>
            <td>
                StyleCop
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                stylelint
            </td>
            <td>
                styleLint()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/stylelint.svg" alt="Stylelint" height="48" width="48">
            </td>
            <td>
                <a href="https://stylelint.io/">
                    Stylelint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Requires <a href='https://www.npmjs.com/package/stylelint-checkstyle-reporter'>stylelint-checkstyle-reporter</a>.<br/>Use <code>--custom-formatter node_modules/stylelint-checkstyle-reporter/index.js -o stylelint-warnings.xml</code>
            </td>
        </tr>
        <tr>
            <td>
                sunc
            </td>
            <td>
                sunC()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="SUN C++ Compiler" height="48" width="48">
            </td>
            <td>
                SUN C++ Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                swiftlint
            </td>
            <td>
                swiftLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="SwiftLint" height="48" width="48">
            </td>
            <td>
                <a href="https://github.com/realm/SwiftLint">
                    SwiftLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use configuration reporter: \”checkstyle\”.
            </td>
        </tr>
        <tr>
            <td>
                tasking-vx
            </td>
            <td>
                taskingVx()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="TASKING VX Compiler" height="48" width="48">
            </td>
            <td>
                TASKING VX Compiler
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                code-composer
            </td>
            <td>
                tiCss()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Texas Instruments Code Composer Studio" height="48" width="48">
            </td>
            <td>
                Texas Instruments Code Composer Studio
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                tnsdl
            </td>
            <td>
                tnsdl()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="TNSDL Translator" height="48" width="48">
            </td>
            <td>
                TNSDL Translator
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                tslint
            </td>
            <td>
                tsLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="TSLint  " height="48" width="48">
            </td>
            <td>
                <a href="https://palantir.github.io/tslint/">
                    TSLint  
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option --format checkstyle.
            </td>
        </tr>
        <tr>
            <td>
                veracode-pipeline-scanner
            </td>
            <td>
                veracodePipelineScanner()
            </td>
            <td>
                <img src="plugin/src/main/webapp/icons/veracode-48x48.png" alt="Veracode Pipeline Scanner" height="48" width="48">
            </td>
            <td>
                <a href="https://docs.veracode.com/r/c_about_pipeline_scan">
                    Veracode Pipeline Scanner
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use commandline <code>java -jar pipeline-scan.jar --json_output=true --json_output_file=results.json</code>, see <a href="https://docs.veracode.com/r/c_about_pipeline_scan">Veracode Pipeline Scanner</a> for usage details.
            </td>
        </tr>
        <tr>
            <td>
                diabc
            </td>
            <td>
                diabC()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="Wind River Diab Compiler (C/C++)" height="48" width="48">
            </td>
            <td>
                Wind River Diab Compiler (C/C++)
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                xmllint
            </td>
            <td>
                xmlLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="XML-Lint" height="48" width="48">
            </td>
            <td>
                XML-Lint
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                yamllint
            </td>
            <td>
                yamlLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="YamlLint" height="48" width="48">
            </td>
            <td>
                <a href="https://yamllint.readthedocs.io/">
                    YamlLint
                </a>
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td colspan="5">
                :bulb: Use option -f parsable.
            </td>
        </tr>
        <tr>
            <td>
                yui
            </td>
            <td>
                yuiCompressor()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="YUI Compressor" height="48" width="48">
            </td>
            <td>
                YUI Compressor
            </td>
            <td>
                -
            </td>
        </tr>
        <tr>
            <td>
                zptlint
            </td>
            <td>
                zptLint()
            </td>
            <td>
                <img src="https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/triangle-exclamation.svg" alt="ZPT-Lint" height="48" width="48">
            </td>
            <td>
                ZPT-Lint
            </td>
            <td>
                -
            </td>
        </tr>
    </tbody>
</table>

