# CISSP Study Resources

Material and Resources pursing CISSP Certification

This is my collection of resources, study materials, notes, and advice I have gathered, working towards certification. Because there is so much material available, when you are starting out it can be a bit daunting to even know where to begin, and what really merits your time and effort.
No compilation is exhaustive, but my goal is to put together information that will be useful and encouraging to others undertaking this effort. At the least, it provides a list of resources, tests, and reference material to review.

My study notes/guides are based on the 2021 Official Study Guide, 9th edition ("OSG-9"). For an overview of what's been added and changed in 2024, take a look at Destination Certification's [CISSP 2024 Exam Changes](https://www.youtube.com/watch?v=TGWpwtTPexE).

Feel free to share this repo or any of the resources if you find them useful. Tell me about mistakes or improvements you think should be made!
Connect with me on [LinkedIn](https://www.linkedin.com/in/jefferywmoore/)

## Table of contents

- [Overview](#overview) of CISSP exam and content.
- [Reference Material](#reference-material) including books, articles, courses, videos, and test banks.
- My [Study Guides By Domain](#my-study-guides) built as I'm progressing through the reference material.

## Overview

There is a ton of information on the CISSP exam available, including from (ISC)², associated & third-party instructors and authors, as well as guides put together by those in preparation. If you're just starting out, I'd recommend the [Sybex Study Guide and Practice Test bundle](https://amzn.to/3WpNWKM) (note that I get a small commission for purchases made through Amazon links).

Many have noted that the most appropriate frame of reference is that of a manager, and not a technician. Try to understand the process, and why any technology would be used. As [Lance puts it](https://github.com/1337-Xtreme/awesome-CISSP-CCSP), try to answer these questions for basic topics:

- Why technology is needed?
- What is the process for making a pro or con decision?
- When would it be needed, and under what circumstances?
- Who makes the decision?
- Who will be operating it, and what access controls need to be implemented? How are they defined? What are the steps involved?
- Who will be auditing usage? Internal vs external and why?
- Who will create relevant policies for it?
- Who implements it, and what are the steps in doing so?
- What are the risks, and who evaluates,quantifies,and accepts (or rejects) them?
- What are the implications for architecture, for structure, for costs?
- What are the privacy ramifications?

Focus on understanding the topics, and the analysis process. Your goal is to reduce risk.

Test Process:

- Read the question and answers twice: skim the question and answers,then go back and read through the question carefully. Argue with each of the answers. Does an answer meet all requirements in the question? Are any other answers more efficient for time and cost?
- If you have no idea what the answer is, you can generally eliminate at least two answers by thinking about the language used in the question. For instance, the question could be asking for a technology, and two of the answers are about process.
- The first priority for any incident is saving human life.
- Think before you act: 
  - Understand business objectives
  - Review current security state
  - Interview stakeholders
  - Identify owners/assets/values
  - Assess current controls
  - Analyze impact/exposure/alternatives
  - Verify/confirm reports

- Take practice tests (see references below), and time yourself. You should get comfortable with the process, and the test's proclivities (e.g. you can't skip and go back to a question, so answer and move on).
- Candidates must have a minimum of five years cumulative paid work experience in two or more of the eight domains of the CISSP CBK. Earning a four-year college degree or regional equivalent or an additional credential from the (ISC)² approved list will satisfy one year of the required experience. Pursue associate if you have less than that.

- The number of questions have dropped from 125-175 (2021), to 100-150 (2024), and the amount of time given to take the test has dropped from 4 to 3 hours, which gives us a little less time per question (from 1.4-1.9 mins (2021), to 1.2-1.8 min (2024)). All domains comprise between [10-16% of the total score](https://www.isc2.org/Insights/2023/11/Changes-to-CISSP-Exam-Weighting).
 
- You can pass and complete or fail in first 100 questions. If you go beyond 100, you are somewhere in between.

## Reference Material

- Books:
  - As mentioned above, the Certified Information Systems Security Professional, [Official Study Guide (10th edition) and Practice Tests](https://amzn.to/3WpNWKM):is a great study base line, with 100 questions for each of the 8 domains & more than 1300 questions total.
  - [CISSP All-in-One Exam Guide](https://amzn.to/3AraOCd): (currently Ninth Edition is available, from May, 2023) - I've found the book valuable, as it reinforces core concepts, and provides additional clear explanations to supplement the OSG.
  - [11th Hour CISSP:Study Guide, 3rd Edition](https://amzn.to/3Bkz4Xf): this book is a bit older, but it's compact, and prep'd "for ease of last-minute studying."
- Courses:
  - This course has been highly recommended by several people: [CISSP Overview by Kelly Handerhan](https://app.cybrary.it/immersive/12270505/activity/61891)
  - Thor Teaches:
    - [Thor Teaches CISSP Study Bundles](https://thorteaches.com/cissp/)
    - [Daily CISSP Questions](https://thorteaches.com/free-daily-cissp-questions/)
- Videos:
  - [Destination Certification MindMap videos](https://www.youtube.com/playlist?list=PLZKdGEfEyJhLd-pJhAD7dNbJyUgpqI4pu): I have seen a lot of positive comments on these mind map videos being extremely helpful for intro, summary, and connecting key topics.
- Mobile Apps:
  - I've found the [LearnzApp](https://www.learnzapp.com/apps/cissp/): to be useful, with study questions, flashcards, and practice tests (note that you'll need a subscription to take advantage of most of these features).
- Practice Tests:
  - OSG and All-in-One Exam Guide practice tests: once you've traversed the OSG material, these tests are a good baseline.
  - [CISSP Exam Prep](https://cissprep.net/): users have commented on the "tricky questions" in this test bank; that might be a distraction or conversely force you to pay closer attention, depending on your POV; note that you'll need a subscription ($24.99 for 6 months).
  - [CertPreps](https://certpreps.com/cissp/): user comments range from "very realistic" to "will make you worry unnecessarily." Many questions focus on identifying the "most" significant/effecive strategy/benefit, or "highest" priority.
  - [CCCure](https://cccure.education/certification/certificate-detail/isc2-cissp-latest-cbk-2024): freepracticetests.org redirects to CCCure, which requires a subscription (from single-user 1 month @ $59.99 to 12 months @ $149.99). I took a practice test and found it underwhelming, but your mileage may vary.
- General & Communities:
  - [Understand Bloom's Taxonomy](https://www.bloomstaxonomy.net/): a framework used by educators and exam creators to guide learning or exam objectives. Cross-reference words used in the exam objectives with the framework to understand the specific meaning, and to guide the level of study required to master.
  - [CISSP Study Group](https://www.skool.com/cissp): this is a great place to share resources, get advice, and connect with peers studying cybersecurity.
  - Head over to the [Certstation](https://discord.gg/certstation) for support and communion with fellow travelers.

Note: these are the notes and resources I've found helpful in my study so far. You are advised to do your own analysis to determine what will be helpful to you in your study. There are no guarantees, implied or othewise that these notes are complete or will meet your needs to pass the CISSP certification. 

## Study Guides By Domain

- [Domain 1 - Security and Risk Management](CISSP-Domain-1-Objectives.md)
- [Domain 2 - Asset Security](CISSP-Domain-2-Objectives.md)
- [Domain 3 - Security Architecture and Engineering](CISSP-Domain-3-Objectives.md) 
- [Domain 4 - Communication and Network Security](CISSP-Domain-4-Objectives.md) 
- [Domain 5 - Identity and Access Management (IAM)](CISSP-Domain-5-Objectives.md) 
- [Domain 6 - Security Assessment and Testing](CISSP-Domain-6-Objectives.md)
- [Domain 7 - Security Operations](CISSP-Domain-7-Objectives.md)
- [Domain 8 - Software Development Security](CISSP-Domain-8-Objectives.md)

