[Domain 5](#domain5-top) **Identity and Access Management (IAM)**

The identity and Access Management (IAM) domain focuses on issues related to granting and revoking privileges to access data or perform actions on systems
- Assets include information, systems, devices, facilities, and applications
- Organizations use both physical and logical access controls to protect them
- Identification is the process of a subject claiming, or professing, an identity
- Authentication verifies the subject’s identity by comparing one or more authentication factors against a database holding authentication info for users
- The three primary authentication factors are something you know, something you have, and something you are
    - Something you know: Type 1 authentication (passwords, pass phrase, PIN etc)
    - Something you have: Type 2 authentication (ID, Passport, Smart Card, Token, cookie on PC etc)
    - Something you are: Type 3 authentication, includes Biometrics (Fingerprint, Iris Scan, Facial geometry etc.)
    - Somewhere you are: Type 4 authentication (IP/MAC Address)
    - Something you do: Type 5 authentication (Signature, Pattern unlock)
- Single sign-on (SSO) technologies allow users to authenticate once and access any resources in a network or the cloud, without authenticating again
- Federated Identity Management (FIM) systems link user identities in one system with other systems to implement SSO
- **Access Control System**: ensuring access to assets is authorized and restricted based on business and security requirements
- **Access Control Token**: based on the parameters like time, date, day etc a token defines access validity to a system
- **ADFS**: identity access solution that provides client computers (internal or external to your network) with seamless SSO access to protected Internet-facing applications or services, even when the user accounts and applications are located in completely different networks or orgs
- **Capability tables**: list privileges assigned to subjects and identify the objects that subjects can access
- **CAS**: Central Authentication Service (an SSO implementation)
- **Content-dependent control**: Content-dependent access control adds additional criteria beyond identification and authentication: the actual content the subject is attempting to access; all employees of an org may have access to the HR database to view their accrued sick time and vacation time, but should an employee attempt to access the content of the CIO's HR record, access is denied
- **Context-dependent access control**: applies additional context before granting access, with time as a commonly used context
- **Crossover Error Rate** (CER): point at which false acceptance (Type 2) error rate equals the false rejection (Type 1) error rate for a given sensor, in a given system and context; it is the optimal point of operation if the potential impacts of both types of errors are equivalent
- **Cross-Site Request Forgery (CSRF)**: (AKA XSRF) an attack that forces authenticated users to submit a request to a Web application against which they are currently authenticated
- **FRR**: False Rejection Rate (Type 1) incorrectly denying authentication to a legit identity and therefore denying access
- **FAR**: False Acceptance Rate (Type 2) incorrectly authenticating a claimed identity as legit, recognizing and granting access on that basis
- **Ethical Wall**: the use of administrative, physical/logical controls to establish/enforce separation of information, assets or job functions for need-to-know boundaries or prevent conflict of interest situations; AKA compartmentalization
- **Granularity of controls**: level of abstraction or detail which in a security function can be configured or tuned for performance and sensitivity
- **IDaaS**: cloud-based service that broker IAM functions to target systems on customers' premise and/or in the cloud
- **Identity proofing**: process of collecting/verifying info about someone who has requested access/credential/special privilege to establish a relationship with that person
- **Self-service identity management**: elements of the identity management lifecycle which the end-user (identity in question) can initiate or perform on their own (e.g. password reset, changes to challenge questions etc)
- **Whaling attack**: phishing attack targeting highly-placed officials/private individuals with sizeable assets authorizing large-fund wire transfers
- **XSS**: Cross-Site Scripting (XSS) essentially uses reflected input to trick a user's browser into executing untrusted code from a trusted site; these attacks are a type of injection, in which malicious scripts are injected into otherwise benign and trusted websites; XSS attacks occur when an attacker uses a web app to send malicious code, generally in the form of a browser side script, to a different end user; flaws that allow these attacks to succeed are quite widespread and occur anywhere a web application uses input from a user within the output it generates without validating or encoding it
- **XST**: Cross-Site Tracing (XST) attack involves the use of Cross-site Scripting (XSS) and the TRACE or TRACK HTTP methods; this could potentially allow the attacker to steal a user's cookies

[5.1](#5.1) Control physical and logical access to assets (OSG-9 Chpt 13)
- Controlling access to assets (tangible: things you can touch, or nontangible: info and data) is a central theme of security
- Understand that there is no security without physical security: admin, technical and logical access controls aren't effective without control over the physical env
- In addition to personnel, assets can be information, systems, devices, facilities, or applications:
    - 5.1.1 Information: an org’s information includes all of its data, stored in simple files (on servers, computers, and small devices), or in databases
    - 5.1.2 Systems: an org’s systems include anything that provide one or more services; a web server with a database is a system; permissions assigned to user and system accounts control system access
    - 5.1.3 Devices: refers to any computing system (e.g. routers & switches, smartphones, laptops, and printers); BYOD has been increasingly adopted, and the data stored on the devices is still an asset to the org
    - 5.1.4 Facilities: any physical location, building, rooms, complexes etc; physical security controls are important to help protect facilities
    - 5.1.5 Applications: apps provide access to data; permissions are an easy way to restrict logical access to apps
- Understand what assets you have, and how to protect them
    - **physical security controls**: such as perimeter security and environmental controls
        - control access and the environment
    - **logical access controls**: automated systems that auth or deny access based on verification that identify presented matches that which was previously approved; technical controls used to protect access to information, systems, devices, and applications
        - includes authentication, authorization, and permissions
        - permissions help ensure only authorized entities can access data
        - logical controls restrict access to config settings on systems/networks to only authed individuals
        - applies to on-prem and cloud

[5.2](#5.2) Manage identification and authentication of people, devices, and services (OSG-9 Chpt 13)
- **Identification**: the process of a subject claiming, or professing an identity
- **Authentication**: verifies the subject’s identity by comparing one or more factors against a database of valid identities, such as user accounts
    - a core principle with authentication is that all subjects must have unique identities
    - identification and authentication occur together as a single two-step process
    - users identify themselves with usernames and authenticate (or prove their identity) with passwords
- 5.2.1 Identiy management (IdM) implementation
    - Identity and access management is a collection of processes and techologies that are used to control access to critical assets; it's purpose is the management of access to information, systems, devices, and facilities
    - Identity Management (IdM) implementation techniques generally fall into two categories:
        - **centralized access control**: implies a single entity within a system performs all authorization verification
            - potentially creates a single point of failure
            - small team can manage initially, and can scale to more users
        - **decentralized access control**: (AKA distributed access control) implies several entities located throughout a system perform auth verification
            - requires more individuals or teams to manage, and admin may be spred across numerous locations
            - difficult to maintain consistency
            - changes made to any individual access control point needs to be repeated at others
    - With ubiquitious mobile computing and anywhere, anytime access (to apps & data), identity is the "new perimeter"
- 5.2.2 Single/Multi-Factor Authentication (MFA)
    - **Single-factor authentication**: any authentication using only one proof of identity
    - **Two-factor authentication (2FA)**: requires two different proofs of identity
    - **Multifactor authentication (MFA)**: any authentication using two or more factors
        - multifactor auth must use multiple types or factors, such as something you know and something you have
        - note: requiring users to enter a password and a PIN is NOT multifactor (both are something you know)
    - Two-factor methods:
        - **Hash Message Authentication Code (HMAC)**: includes a hash function used by the HMAC-based One-Time Password (HOTP) standard to create onetime passwords
        - **Time-based One-Time Password (TOTP)**: similar to HOTP, but uses a timestamp and remains valid for a certain time frame (e.g. 30 or 60 seconds)
            - e.g. phone-based authenticator app, where your phone is mimicking a hardware TOTP token (combined with userid/password is considered two-factor or two-step authentication)
        - **Email challenge**: popular method, used by websites, sending the user an email with a PIN
        - Short Message Service (SMS): to send users a text with a PIN is another 2-factor method; note that NIST SP 800-63B points out vulnerabilities, and deprecates use of SMS as a two-factor method for federal agencies
- 5.2.3 Accountability
    - Two important security elements in an access control system are authorization and accountability
        - **Authorization**: subjects are granted access to objects based on proven identities
        - **Accountability**: users and other subjects can be held accountable for their actions when auditing is implemented
    - **Auditing**: tracks subjects and records when they access objects, creating an audit trail in one or more audit logs
    - Auditing provides accountability
- 5.2.4 Session management
    - Session management is important to use with any type of authentication system to prevent unauthorized access
    - Desktop/laptops: recommendation to use screensavers, although modern OSs have timeout/lock features
    - Secure online sessions should terminate after a timeout period
    - The Open Web Application Security Project (OWASP) publishes “cheat sheets” that provide app developer’s specific recommendations
- 5.2.5 Registration, proofing, and establishment of identity
    - Within an organization, new employees prove their identity with appropriate documentation during the hiring process
        - in-person identity proofing includes things like passport, DL, birth cert etc
    - Online orgs often use knowledge-based authentication (KBA) for identity-proofing of someone new (e.g. a new customer creating a new bank/savings account)
        - example questions include past vehicle purchases, amount of mortgage payment, previous addresses, DL numbers
        - they then query authoritative information (e.g. credit bureaus or gov agencies) for matches
    - Cognitive Passwords: security questions that are gathered during account creation, which are later used as questions for authentication (e.g. name of pet, color of first car etc)
        - one of the flaws associated with cognitive passwords is that the information is often available on social media sites or general internet searches
- 5.2.6 Federated Identity Management (FIM)
    - Federated Identity Management (FIM) systems (a form of SSO) are often used by cloud-based apps
    - A federated identity links a user’s identity in one system with multiple identity management systems
    - FIM allows multiple orgs to join a federation or group, agreeing to share identity information
        - users in each org can log in once in their own org, and their credentials are matched with a federated identity
        - users can then use this federated identity to access resources in any other org within the group
        - where each organization decides what resources to share
    - Methods used to implement federated identity management systems include:
        - Security Assertion Markup Language (SAML)
        - OAuth
        - OpenID Connect (OIDC)
    - Cloud-based federation typically uses a third-party service to share federated identities
    - Federated identity management systems can be hosted on-premises, in the cloud, or in a combination of the two as a hybrid system
- 5.2.7 Credential management systems
    - **Credential management systems**: provide storage space for usernames and password
        - e.g. web browsers that remember usernames and passwords for visited sites
    - The World Wide Web Consortium (W3C) published the Credential Management Level 1 API as a working draft in January 2019, which many browsers have adopted
    - Some federated identity management solutions use the Credential Management API, allowing web apps to implement SSO using a federated identity provider
        - e.g. using your Google or Facebook account to sign into Zoom
- 5.2.8 Singe Sign On (SSO)
    - **Single Sign-On (SSO)**: a centralized access control technique allowing a subject to be authenticated once on a system and access multiple resources without authenticating again
    - Advantages of using SSO include:
        - reduces the number of passwords that users need to remember, and they are less likely to write them down
        - eases administration by reducing the number of accounts
    - Disadvantages:
        - once an account is compromised, an attacker gains unrestricted access to all of the authorized resources
    - Within an organization, a central access control system, such as a directory service, is often used for SSO
        - **directory service**: a centralized database that includes information about subjects and objects, including authentication data
        - many directory services are based on the Lightweight Directory Access Protocol (LDAP)
- 5.2.9 Just-In_time (JIT)
    - Federated identity solutions that support just-in-time (JIT) provisioning automatically create the relationship between two entities so that new users can access resources
    - A JIT solution creates the connection without any administrative intervention
    - JIT systems commonly use SAML to exchange required data

[5.3](#5.3) Federated Identity with a third-party service (OSG-9 Chpt 13)
- 5.3.1 On-premise
    - Federated identity management can be hosted on-premise, and typically provides an organization with the most control
- 5.3.2 Cloud
    - Cloud-based apps used federated identify management (FIM) systems, which are a form of SSO
    - Cloud-based federation typically uses a third-party service to hsare federated identities (e.g. training sites use federated SSO systems)
        - commonly matching the user's internal login ID with a federated identify
- 5.3.3 Hybrid
    - A hybrid federation is a combination of a cloud-based solution and an on-premise solution

[5.4](#5.4) Implement and manage authorization mechanisms (OSG-9 Chpt 14)
- 5.4.1 Role Based Access Control (RBAC)
    - A key characteristic of the Role-Based Access Control (RBAC) model is the use of roles or groups
    - Instead of assigning permissions directly to users, user accounts are placed in roles and administrators assign privileges to the roles (typically defined by job function)
        - if the user account is in a role, the user has all privileges assigned to the role
    - MS Windows OS uses this model with groups
    - RBAC models can group users into roles based on the org's hierarchy, and it is a non-descretionary access control model; central authority access decisions can use the RBAC model
- 5.4.2 Rule Based access control
    - A key characteristic of the Rule-Based access control model is that it applies global rules to all subjects
        - e.g. firewalls uses rules that allow or block traffic to all users equally
    - Rules within the rule-based access control model are sometimes referred to as restrictions or filters
- 5.4.3 Mandatory Access Control (MAC)
    - **Mandatory Access Control (MAC)**: access control that requires the system itself to manage access controls in accordance with the org's security policies
    - A key characteristic of the MAC model is the use of labels applied to both subjects and objects
        - e.g. a label of top secret grants access to top-secret documents
    - When documented in a table, the MAC model sometimes resembles a lattice (i.e. climbing rosebush framework), so it is referred to as a lattice-based model
- 5.4.4 Discretionary Access Control (DAC)
    - **Discretionary Access Control (DAC)**: access control model in which the system owner decides who gets access
    - A key characteristic of the DAC model is that every object has an owner, and the owner can grant or deny access to any other subjects
        - e.g. you create a file and are the owner, and can grant permissions to that file
    - New Technology File System (NTFS) used in Windows, uses the DAC model
- 5.4.5 Attribute Based Access Control (ABAC)
    - **Attribute-Based Access Control (ABAC)**: an access control paradigm where access rights are granted to users with policies that combine attributes together
    - A key characteristic of the ABAC model is its use of rules that can include multiple attributes
        - this allows it to be much more flexible than a rule-based access control model that applies the rules to all subjects equally
        - many software-defined networks (SDNs) use the ABAC model
    - ABAC allows administrators to create rules within a policy using plain language statements such as "Allow Managers to access the WAN using a mobile device"
- 5.4.6 Risk based access control
    - Risk-based access control model grants access after evaluating risk; evaluating the environment and the situation and making risk-based decisions using policies embeded within software
        - Using machine learning, making predictive conclusions about current activity based on past activity

[5.5](#5.5) Manage the identity and access provisioning lifecycle (OSG-9 Chpts 13,14)
- 5.5.1 Account accesss review
    - Administrators need to periodically review user, system and service accounts to ensure they meet security policies and that they don’t have excessive privileges
    - Be careful in using the local system account as an application service account; although it allows the app to run without creating a special service account, it usually grants the app more access than it needs
    - You can use scripts to run periodically and check for unused accounts, and check priveleged group membership, removing unauthorized accounts
    - Guard against two access control issues:
        - excessive privilege: occurs when users have more privileges than assigned work tasks dictate; these privileges should be revoked
        - creeping privileges (AKA privilege creep): user accounts accumulating additional privileges over time as job roles and assigned tasks change
- 5.5.2 Provisioning and deprovisioning
    - Identity and access provisioning lifecycle refers to the creation, management, and deletion of accounts
        - this lifecycle is important because without properly defined and maintained user accounts, a system is unable to establish accurate identity, perform authentication, provide authorization, and track accountability
    - Provisioning/Onboarding
        - proper user account creation, or provisioning, ensures that personnel follow specific procedures when creating accounts
            - new-user account creation is AKA enrollment or registration
        - **automated provisioning**: information is provided to an app, that then creates the accounts via pre-defined rules (assigning to appropriate groups based on roles)
            - automated provisioning systems create accounts consistently
        - provisioning also includes issuing hardware, tokens, smartcards etc to employees
        - it’s important to keep accurate records when issuing hardware to employees
        - after provisioning, an org can follow up with onboarding processes, including:
            - the employee reads and signs the acceptable use policy (AUP)
            - explaining security best practices (like infected emails)
            - reviewing the mobile device policy
            - ensuring the employee’s computer is operational, and they can log in
            - configure a password manager
            - explaining how to access help desk
            - show to access, share and save resources
    - Deprovisioning/Offboarding
        - deprovisioning/offboarding occurs when an employee leaves the organization or is transferred to a different department
        - **account revocation**: deleting an account is the easiest way to deprovision
            - an employee's account is usually first disabled
            - supervisors can then review the user’s data and determine if anything is needed
            - note: if terminated employee retains access to a user account after the exit interview, the risk for sabatage is very high
        - deprovisioning includes collecting any hardware issued to an employee such as laptops, mobile devices and auth tokens
- 5.5.3 Role definition
    - Employee responsibilities can change in the form of transfers to a different role, or into a newly created role
        - for new roles, it’s important to define the role and the privileges needed by the employees in that role
    - Roles and associated groups need to be defined in terms of privileges
- 5.5.4 Privilege escalation (e.g. managed service accounts, use of usdo, minimizing its use)
    - Privilege escalation refers to any situation that gives users more privileges than they should have
    - Attackers use privilege escalation techniques to gain elevated privileges
    - **Horizontal privilege escalation**: gives an attacker similar privileges as the first compromised user, but from other accounts
    - **Vertical privilege escalation**: provides an attacker with significantly greater privileges
        - e.g. after compromising a regular user’s account an attacker can use vertical privilege escalation techniques to gain administrator privileges on the user’s computer
        - the attacker can then use horizontal privilege escalation techniques to access other computers in the network
        - this horizontal privilege escalation throughout the network is AKA **lateral movement**

[5.6](#5.6) Implement authentication systems (OSG-9 Chpt 14)
- 5.6.1 OpenID Connect (OIDC) / Open Authorization (Oauth)
    - OAuth 2.0 authorization framework enables third-party apps to obtain limited access to an HTTP service, either on behalf of a resource owner (by orchestrating an approval interaction), or by allowing third-party applications to obtain access on its own behalf; OAuth provides the ability to access resources from another service
    - OAuth is an open framework used for authentication and authorization protocols
    - OAuth is the most widely used open standard for authorization and delgation of rights for cloud services
    - The most common protocol built on OAuth is OpenID Connect (OIDC); OpenID is used for authentication
    - OAuth 2.0 is often used for delegated access to applications, e.g. a mobile game that automatically finds all of your new friends from a social media app is likely using OAuth 2.0;
    - Conversely, if you sign into a new mobile game using a social media account (instead of creating a user account just for the game), that process might use OIDC
    - **OpenID Connect (OIDC)**: an authentication layer using the OAuth 2.0 authorization framework, maintained by the OpenID Foundation, providing both authentication and authorization
        - OIDC is a RESTful, JSON (JavaScript Object Notation)-based auth protocol that, when pared with OAuth can provide identity verification and basic profile info; uses JSON  Web Tokens (JWT) -- AKA ID token
    - OAuth and OIDC are used with many web-based applications to share information without sharing credentials
        - OAuth provides authorization
        - OIDC uses the OAuth framework for authorization and builds on the OpenID technologies for authentication

- 5.6.2 Security Assertion Markup Language (SAML)
    - Security Assertion Markup Language (SAML): an open XML-based standard commonly used to exchange authentication and authorization (AA) information between federated orgs
    - Frequently used to integrate cloud services and provides the ability to make authentication and authorization assertions
    - SAML provides SSO capabilities for browser access
    - SAML is a popular SSO standard on the internet - used to exchange authentication and authorization (AA) information
    - Organization for the Advancement of Structure Information Standards (OASIS) maintains it
    - SAML 2 spec utilizes three entities:
        - Principal or User Agent
        - Service Provider (SP): providing the service a user is interested in using
        - Identity Provider (IdP): a third-party that holds the user authentication and authorization info
    - IdP can send three types of XML messages known as assertions:
        - Authentication Assertion: provides proof that the user agent provided the proper credentials, identifies the identification method, and identifies the time the user agent logged on
        - Authorization Assertion: indicates whether the user agent is authorized to access the requested service; if denied, includes why
        - Attribute Assertion: attributes can be any information about the user agent
- 5.6.3 Kerberos
    - Kerberos is a network authentication protocol widely used in corporate and private networks and found in many LDAP and directory services solutions such as Microsoft Active Directory
    - It provides single sign-on and uses cryptography to strengthen the authentication process and protect logon credentials
    - Ticket authentication is a mechanism that employs a third-party entity to prove identification and provide authentication - Kerberos is a well-known ticket system
    - After users authenticate and prove their identity, Kerberos uses their proven identity to issue tickets, and user accounts present these tickets when accessing resources
    - Kerberos version 5 relies on symmetric-key cryptography (AKA secret-key cryptography) using the Advanced Encryption Standard (AES) symmetric encryption protocol
    - Kerberos provides confidentiality and integrity for authentication traffic using end-to-end security and helps protect against eavesdropping and replay attacks
    - Kerberos uses UDP port 88 by default
    - Kerberos elements:
        - **Key Distribution Center (KDC)**: the trusted third party that provides authentication services
        - **Kerberos Authentication Server**: hosts the functions of the KDC:
            - **ticket-granting service (TGS)**: provides proof that a subject has authenticated through a KDC and is authorized to request tickets to access other objects
                - the ticket for the full ticket-granting service is called a ticket-granting ticket ([TGT](https://learn.microsoft.com/en-us/windows/win32/secauthn/ticket-granting-tickets)); when the client asks the KDC for a ticket to a server, it presents credentials in the form of an authenticator message and a ticket (a TGT) and the ticket-granting service opens the TGT with its master key, extracts the logon session key for this client, and uses the logon session key to encrypt the client's copy of a session key for the server
                - a TGT is encrypted and includes a symmetric key, an expiration time, and user’s IP address
                - subjects present the TGT when requesting tickets to access objects
            - **authentication service (AS)**: verifies or rejects the authenticity and timeliness of tickets; often referred to as the KDC
        - **Ticket (AKA service ticket (ST))**: an encrypted message that provides proof that a subject is authorized to access an object
        - **Kerberos Principal**: typically a user but can be any entity that can request a ticket
        - **Kerberos realm**: a logical area (such as a domain or network) ruled by Kerberos
    - Kerberos login process:
        1) user provides authentication credentials (types a username/password into the client)
        2) client/TGS key generated
            - client encrypts the username with AES for transmission to the KDC
            - the KDC verifies the username against a db of known credentials
            - the KDC generates a symmetric key that will be used by the client and the Kerberos server
            - it encrypts this with a hash of the user’s password
        3) TGT generated - the KDC generates an encrypted timestamped TGT
        4) client/server ticket generated
            - the KDC then transmits the encrypted symmetric key and the encrypted timestamped TGT to the client
            - the client installs the TGT for use until it expires
            - the client also decrypts the symmetric key using a hash of the user’s password
            - NOTE: the client’s password is never transmitted over the network, but it is verified
                - the server encrypts a symmetric key using a hash of the user’s password, and it can only be decrypted with a hash of the user’s password
        5) user accesses requested service
    - When a client wants to access an object (like a hosted resource), it must request a ticket through the Kerberos server, in the following steps:
        - the client sends its TGT back to the KDC with a request for access to the resource
        - the KDC verifies that the TGT is valid, and checks its access control matrix to verify user privileges for the requested resource
        - the KDC generates a service ticket and sends it to the client
        - the client sends the ticket to the server or service hosting the resource
        - the server or service hosting the resource verifies the validity of the ticket with the KDC
        - once identity and authorization are verified, Kerberos activity is complete
            - the server or service host then opens a session with the client and begins communication or data transmission
- 5.6.4 Remote Authentication Dial-in User Service (RADIUS) / Terminal Access Controller Access Control System Plus (TACACS+)
    - Remote Authentication Dial-in User Service (RADIUS): centralizes authentication for remote access connections, such as VPNs or dial-up access
        - a user can connect to any network access server, which then passes on the user’s credentials to the RADIUS server to verify authentication and authorization and to track accounting
        - in this context, the network access server is the RADIUS client, and a RADIUS server acts as an authentication server
        - the RADIUS server also provides AAA services for multiple remote access servers
        - RADIUS uses the User Datagram Protocol (UDP) by default and encrypts only the password’s exchange
        - RADIUS using Transport Layer Security (TLS) over TCP (port 2083) is defined by RFC 6614 
        - RADIUS uses UDP port 1812 for RADIUS messages and UDP port 1813 for RADIUS Accounting messages
        - RADIUS encrypts only the password’s exchange by default
        - it is possible to use RADIUS/TLS to encrypt the entire session
    - Cisco developed Terminal Access Control Access Control System Plus (TACACS+) and released it as an open standard
        - provides improvements over the earlier version and over RADIUS, it separates authentication, authorization, and accounting into separate processes, which can be hosted on three different servers
        - additionally, TACACS+ encrypts all of the authentication information, not just the password, as RADIUS does
        - TACACS+ uses TCP port 49, providing a higher level of reliability for the packet transmissions