unit Test.PureMVC.Patterns.Observer;

{
  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  TestFramework,
  PureMVC.Patterns.Observer,
  PureMVC.Interfaces.INotification,
  PureMVC.Interfaces.IObserver;

type

  TestTObserver = class(TTestCase)
  private
    FObserverTestVar: Integer;
  public
    // PureMVC handle
    procedure ObserverTestMethod(Note: INotification);
  published
    procedure TestCompareNotifyContext;
    procedure TestObserverAccessors;
    procedure TestObserverConstructor;
  end;

implementation

uses
  PureMVC.Patterns.Notification;

procedure TestTObserver.TestObserverAccessors;
var
  Observer: IObserver;
  Note: INotification;
begin
  Observer := TObserver.Create;
  Observer.NotifyContext := Self;
  Observer.NotifyMethod := 'ObserverTestMethod';

  // create a test event, setting a payload value and notify
  // the observer with it. since the observer is this class
  // and the notification method is observerTestMethod,
  // successful notification will result in our local
  // observerTestVar being set to the value we pass in
  // on the note body.
  Note := TNotification.Create('ObserverTestNote', Self, 10);
  Observer.NotifyObserver(Note);

  CheckEquals(10, FObserverTestVar);
end;

procedure TestTObserver.TestObserverConstructor;
var
  Observer: IObserver;
  Note: INotification;
begin
  Observer := TObserver.Create('ObserverTestMethod', Self);

  // create a test note, setting a body value and notify
  // the observer with it. since the observer is this class
  // and the notification method is observerTestMethod,
  // successful notification will result in our local
  // observerTestVar being set to the value we pass in
  // on the note body.
  Note := TNotification.Create('ObserverTestNote', Self, 5);
  Observer.NotifyObserver(Note);

  CheckEquals(5, FObserverTestVar);
end;

procedure TestTObserver.TestCompareNotifyContext;
var
  Observer: IObserver;
  NegTestObj: TObject;
begin
  Observer := TObserver.Create('ObserverTestMethod', Self);
  NegTestObj := TObject.Create;
  try
    CheckFalse(Observer.CompareNotifyContext(NegTestObj));
    CheckTrue(Observer.CompareNotifyContext(Self));
  finally
    NegTestObj.Free;
  end;
end;

procedure TestTObserver.ObserverTestMethod(Note: INotification);
begin
  FObserverTestVar := Note.Body.AsInteger;
end;

initialization

// Register any test cases with the test runner
RegisterTest(TestTObserver.Suite);

end.
