unit Test.PureMVC.Patterns.Mediator;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  TestFramework,
  PureMVC.Patterns.Mediator,
  PureMVC.Interfaces.IMediator;

type

  TestTMediator = class(TTestCase)
  private
  public
  published
    procedure TestNameAccessor;
    procedure TestViewAccessor;
  end;

implementation

procedure TestTMediator.TestNameAccessor;
var
  Mediator: IMediator;
begin
  Mediator := TMediator.Create('TestMediator');
  CheckEquals('TestMediator', Mediator.MediatorName);
end;

procedure TestTMediator.TestViewAccessor;
var
  View: TObject;
  Mediator: IMediator;
begin
  View := TObject.Create;
  Mediator := TMediator.Create('TestMediator', View);
  CheckSame(View, Mediator.ViewComponent);
  View.Free;
end;

initialization

// Register any test cases with the test runner
RegisterTest(TestTMediator.Suite);

end.
