unit Test.PureMVC.Patterns.SimpleCommand;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  TestFramework,
  PureMVC.Patterns.Notifier,
  PureMVC.Patterns.Notification,
  PureMVC.Patterns.Command,
  PureMVC.Interfaces.ICommand,
  PureMVC.Interfaces.Collections,
  PureMVC.Interfaces.INotifier,
  PureMVC.Interfaces.INotification;

type
  // Test methods for class TSimpleCommand

  TestTSimpleCommand = class(TTestCase)
  strict private
    Command: TSimpleCommand;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestExecute;
  end;

implementation

type
  TSimpleCommandTestVO = class
  private
    FInput: Integer;
    FResult: Integer;
  public
    constructor Create(Input: Integer);
    property Input: Integer read FInput;
    property Result: Integer read FResult write FResult;
  end;

  TSimpleCommandTestCommand = class(TSimpleCommand)
  public
    procedure Execute(Note: INotification); override;
  end;

{ TSimpleCommandTestVO }

constructor TSimpleCommandTestVO.Create(Input: Integer);
begin
  inherited Create;
  FInput := Input;
end;

{ TSimpleCommandTestCommand }

procedure TSimpleCommandTestCommand.Execute(Note: INotification);
var
  VO: TSimpleCommandTestVO;
begin
  inherited;
  VO := Note.Sender as TSimpleCommandTestVO;

  // Fabricate a result
  VO.Result := 2 * VO.Input;
end;

{ TestTSimpleCommand }

procedure TestTSimpleCommand.SetUp;
begin
  Command := TSimpleCommandTestCommand.Create;
end;

procedure TestTSimpleCommand.TearDown;
begin
  Command.Free;
end;

procedure TestTSimpleCommand.TestExecute;
var
  VO: TSimpleCommandTestVO;
  Note: INotification;
begin
  VO := TSimpleCommandTestVO.Create(5);
  try
    Note := TNotification.Create('SimpleCommandTestNote', VO);
    Command.Execute(Note);
    CheckEquals(10, VO.Result);
  finally
    VO.Free;
  end;
end;

initialization

// Register any test cases with the test runner
RegisterTest(TestTSimpleCommand.Suite);

end.
