unit Test.PureMVC.Patterns.MacroCommand;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  TestFramework,
  PureMVC.Patterns.Notifier,
  PureMVC.Patterns.Notification,
  PureMVC.Patterns.Command,
  PureMVC.Interfaces.ICommand,
  PureMVC.Interfaces.Collections,
  PureMVC.Interfaces.INotifier,
  PureMVC.Interfaces.INotification;

type
  // Test methods for class TMacroCommand

  TestTMacroCommand = class(TTestCase)
  strict private
    Command: TMacroCommand;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestExecute;
  end;

implementation

type
  TMacroCommandTestVO = class
  private
    FInput: Integer;
    FResult1: Integer;
    FResult2: Integer;
  public
    constructor Create(Input: Integer);
    property Input: Integer read FInput;
    property Result1: Integer read FResult1 write FResult1;
    property Result2: Integer read FResult2 write FResult2;
  end;


  TMacroCommandTestSub1Command = class(TSimpleCommand)
  public
    procedure Execute(Note: INotification);override;
  end;

  TMacroCommandTestSub2Command = class(TSimpleCommand)
  public
    procedure Execute(Note: INotification);override;
  end;

  TMacroCommandTestCommand = class(TMacroCommand)
  protected
    procedure InitializeMacroCommand;override;
  end;

{ TMacroCommandTestVO }

constructor TMacroCommandTestVO.Create(Input: Integer);
begin
  inherited Create;
  FInput := Input;
end;

{ TMacroCommandTestSub1Command }

procedure TMacroCommandTestSub1Command.Execute(Note: INotification);
var
	VO: TMacroCommandTestVO;
begin
  VO := Note.Sender as TMacroCommandTestVO;
  VO.Result1 := 2 * VO.Input;
end;

{ TMacroCommandTestSub2Command }

procedure TMacroCommandTestSub2Command.Execute(Note: INotification);
var
	VO: TMacroCommandTestVO;
begin
  VO := Note.Sender as TMacroCommandTestVO;
  VO.Result2 := VO.Input * VO.Input;
end;

{ TMacroCommandTestCommand }

procedure TMacroCommandTestCommand.InitializeMacroCommand;
begin
  inherited;
  AddSubCommand(TMacroCommandTestSub1Command);
  AddSubCommand(TMacroCommandTestSub2Command);
end;

{ TestTMacroCommand }

procedure TestTMacroCommand.SetUp;
begin
  Command := TMacroCommandTestCommand.Create;
end;

procedure TestTMacroCommand.TearDown;
begin
  Command.Free;
end;

procedure TestTMacroCommand.TestExecute;
var
  VO: TMacroCommandTestVO;
  Note: INotification;
begin
  VO := TMacroCommandTestVO.Create(5);
  try
    Note := TNotification.Create('MacroCommandTestNote', VO);
    Command.Execute(Note);

    CheckEquals(10, VO.Result1);
    CheckEquals(25, VO.Result2);
  finally
    VO.Free;
  end;
end;

initialization

// Register any test cases with the test runner
RegisterTest(TestTMacroCommand.Suite);

end.
