
## [PureMVC](http://puremvc.org/) Delphi Standard Framework

[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/jcangas/puremvc-delphi-standard-framework?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

PureMVC is a lightweight framework for creating applications based upon the classic  
Model-View-Controller design meta-pattern.

This is a Delphi port of the [AS3 reference implementation of the Standard Version](https://github.com/PureMVC/puremvc-as3-standard-framework/wiki).

Unit tests are included using DUnit

* [API Docs](http://darkstar.puremvc.org/content_header.html?url=http://puremvc.org/pages/docs/CSharp/standard/&desc=PureMVC%20API%20Docs:%20PureMVC%20Standard%20for%20C Sharp)
* [Discussion](http://forums.puremvc.org/index.php?board=72.0)
* [Overview Presentation](http://puremvc.tv/#P100)

This is a Delphi port for the Delphi language, based in a
previous [C# port](http://trac.puremvc.org/PureMVC_CSharp) by Andy Adamczak

## Demos

* Employee Admin

## Status

Production - 1.0

## Screenshots

![The Employee Demo running 1](/site/EmployeeAdmin Running.jpg)
![The Employee Demo running 2](/site/EmployeeAdmin Validation.jpg)
![DUnit Test Runner](/site/Test Running.jpg)

## Build

* Load the project group located in src folder.
* Alternatively, you can use BUILD.bat in your command line, located at th root of th project folder. Write BUILD /? to get help on how use it.

* At this moment, supported IDE's are XE5, XE6 & XE7: I don't have acces to all IDE versións.
  Anyway the code is highly portable accross the XE series, so you can open the dpk and dpr files and try yourself.
  If you do it, please, tell me in order we can add more supported IDE's. Feel free to contact me also, If you have any issue.

## Setup and Use

* Nothing special is required: as always put the .bpl, .dcu and .dcp files in your IDE's library paths.

## Platforms / Technologies

* Delphi XE5
* Delphi XE6
* Delphi XE7

## License

 PureMVC Delphi Port by Jorge L. Cangas <jorge.cangas@puremvc.org>
 PureMVC - Copyright(c) 2006-11 Futurescale, Inc., Some rights reserved.
 Your reuse is governed by the Creative Commons Attribution 3.0 License
