/*
 * Decompiled with CFR 0.152.
 */
package component.view;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import navigation.Navigation;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class DiagramView
extends Panel {
    private JSObject appletWindow;
    private Hashtable images = new Hashtable();
    private Applet applet;
    private Image myImage = null;
    private int myWidth = 0;
    private int myHeight = 0;
    private int maxWidth = 1;
    private int maxHeight = 1;
    private int imgW = 0;
    private int imgH = 0;
    private double rate = 1.0;
    private int xs = 0;
    private int ys = 0;
    private Rectangle spotRect = new Rectangle();
    private Point dragPoint = new Point();
    private boolean onSpot = false;
    private boolean isDragged = false;
    private static final Color BORDER_COLOR = new Color(0, 0, 128);
    private BufferedImage myBufImage;

    public DiagramView(Applet applet) {
        this.applet = applet;
        try {
            this.appletWindow = JSObject.getWindow((Applet)applet);
        }
        catch (JSException jSException) {
            jSException.printStackTrace();
        }
        this.setBackground(new Color(192, 192, 192));
        this.setSize(applet.getSize());
        this.maxWidth = this.getSize().width - 2;
        this.maxHeight = this.getSize().height - 2;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DiagramView.this.onSpot) {
                    DiagramView.this.dragPoint = mouseEvent.getPoint();
                    DiagramView.this.xs = ((DiagramView)DiagramView.this).dragPoint.x - ((DiagramView)DiagramView.this).spotRect.x;
                    DiagramView.this.ys = ((DiagramView)DiagramView.this).dragPoint.y - ((DiagramView)DiagramView.this).spotRect.y;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DiagramView.this.isDragged = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (DiagramView.this.spotRect.contains(mouseEvent.getPoint())) {
                    DiagramView.this.setCursor(new Cursor(13));
                    DiagramView.this.onSpot = true;
                } else {
                    DiagramView.this.setCursor(new Cursor(0));
                    DiagramView.this.onSpot = false;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (DiagramView.this.onSpot) {
                    DiagramView.this.isDragged = true;
                    Graphics graphics = DiagramView.this.getGraphics();
                    DiagramView.this.dragPoint = mouseEvent.getPoint();
                    DiagramView.this.setSpotLocation(mouseEvent.getX() - DiagramView.this.xs, mouseEvent.getY() - DiagramView.this.ys);
                    DiagramView.this.drawSpot(graphics);
                    graphics.dispose();
                    try {
                        if (DiagramView.this.appletWindow != null) {
                            DiagramView.this.appletWindow.eval("parent.imageFrame.scroll(" + String.valueOf((double)Math.round((double)((DiagramView)DiagramView.this).spotRect.x - 1.0) * DiagramView.this.rate) + ", " + String.valueOf((double)Math.round((double)((DiagramView)DiagramView.this).spotRect.y - 1.0) * DiagramView.this.rate) + ")");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        if (this.myImage != null) {
            this.drawSpot(graphics);
            graphics.setColor(Color.white);
            graphics.drawLine(this.myWidth + 1, 0, this.myWidth + 1, this.myHeight + 1);
            graphics.drawLine(0, this.myHeight + 1, this.myWidth + 1, this.myHeight + 1);
            graphics.setColor(BORDER_COLOR);
            graphics.drawRect(0, 0, this.myWidth + 2, this.myHeight + 2);
        }
    }

    private void drawSpot(Graphics graphics) {
        this.myBufImage = new BufferedImage(this.myWidth, this.myHeight, 1);
        if (this.myImage != null) {
            this.myBufImage.getGraphics().drawImage(this.myImage, 0, 0, this);
        }
        int n = 0;
        while (n < this.spotRect.width - 2) {
            int n2 = 0;
            while (n2 < this.spotRect.height - 2) {
                int n3 = this.myBufImage.getRGB(this.spotRect.x + n, this.spotRect.y + n2) & 0xCCCCFF;
                this.myBufImage.setRGB(this.spotRect.x + n, this.spotRect.y + n2, n3);
                ++n2;
            }
            ++n;
        }
        graphics.setPaintMode();
        graphics.drawImage(this.myBufImage, 1, 1, this);
    }

    public void loadView(String string, int n, int n2) {
        if (this.images.containsKey(string)) {
            ImageInfo imageInfo = (ImageInfo)this.images.get(string);
            this.myImage = imageInfo.getImage();
            this.myWidth = imageInfo.getWidth();
            this.myHeight = imageInfo.getHeight();
            this.rate = imageInfo.getRate();
            this.imgW = imageInfo.getImageWidth();
            this.imgH = imageInfo.getImageHeight();
        } else {
            Image image = this.applet.getImage(Navigation.fixUrlForOpera(this.applet.getDocumentBase()), string);
            if (image == null) {
                return;
            }
            try {
                double d;
                double d2;
                this.imgW = n;
                this.imgH = n2;
                if (this.imgW < 0 || this.imgH < 0) {
                    try {
                        String string2 = this.applet.getCodeBase().getPath();
                        int n3 = string2.lastIndexOf("/file:///");
                        int n4 = string2.lastIndexOf("/localhost/");
                        if (n3 >= 0) {
                            string2 = string2.substring(n3 + 9);
                        }
                        FileInputStream fileInputStream = new FileInputStream(new File(string2 + "/" + string));
                        ((InputStream)fileInputStream).skip(6L);
                        short s = (short)DiagramView.readBytesIntoInt(fileInputStream, 2);
                        short s2 = (short)DiagramView.readBytesIntoInt(fileInputStream, 2);
                        if (this.imgW < 0) {
                            this.imgW = s + 25;
                        }
                        if (this.imgH < 0) {
                            this.imgH = s2 + 25;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((d2 = (double)this.imgW / (double)this.maxWidth) < 1.0) {
                    d2 = 1.0;
                }
                if ((d = (double)this.imgH / (double)this.maxHeight) < 1.0) {
                    d = 1.0;
                }
                this.rate = Math.max(d2, d);
                this.myHeight = (int)Math.round((double)this.imgH / this.rate) - 1;
                this.myWidth = (int)Math.round((double)this.imgW / this.rate) - 1;
                this.myImage = image.getScaledInstance(this.myWidth, this.myHeight, 4);
                image.flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
            }
            if (this.myHeight > 1 && this.myWidth > 1) {
                ImageInfo imageInfo = new ImageInfo(this.myImage, this.myWidth, this.myHeight, this.rate, this.imgW, this.imgH);
                this.images.put(string, imageInfo);
            }
        }
    }

    public static int readBytesIntoInt(InputStream inputStream, int n) throws Exception {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (--n >= 0 && (n2 = inputStream.read()) >= 0) {
            n4 |= n2 << n3;
            n3 += 8;
            if (n >= 0 && n2 >= 0) continue;
        }
        if (n >= 0) {
            throw new Exception();
        }
        return n4;
    }

    public void setSpotSize(int n, int n2) {
        double d = (double)this.imgW / (double)n;
        double d2 = (double)this.imgH / (double)n2;
        int n3 = (int)Math.round((double)this.myWidth / d);
        int n4 = (int)Math.round((double)this.myHeight / d2);
        n3 = Math.min(n3, this.myWidth);
        n4 = Math.min(n4, this.myHeight);
        if (n3 <= 1) {
            n3 = 1;
        }
        if (n4 <= 1) {
            n4 = 1;
        }
        this.spotRect.setSize(n3, n4);
        int n5 = this.myWidth + 2 - this.spotRect.x - this.spotRect.width;
        int n6 = this.myHeight + 2 - this.spotRect.y - this.spotRect.height;
        if (n5 >= 0) {
            n5 = 0;
        }
        if (n6 >= 0) {
            n6 = 0;
        }
        if (n5 < 0 || n6 < 0) {
            this.moveSpotRelative(n5, n6);
        }
    }

    public void moveSpot(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            int n3 = (int)Math.round((double)n / this.rate) + 1;
            int n4 = (int)Math.round((double)n2 / this.rate) + 1;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void moveSpotRelative(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            int n3 = this.spotRect.x + n;
            int n4 = this.spotRect.y + n2;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void setSpotLocation(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < 1) {
            n3 = 1;
        } else if (n + this.spotRect.width > this.myWidth + 2) {
            n3 = this.myWidth + 2 - this.spotRect.width;
        }
        if (n2 < 1) {
            n4 = 1;
        } else if (n2 + this.spotRect.height > this.myHeight + 2) {
            n4 = this.myHeight + 2 - this.spotRect.height;
        }
        this.spotRect.setLocation(n3, n4);
    }

    private class ImageInfo {
        private int width = 0;
        private int height = 0;
        private int imgW = 0;
        private int imgH = 0;
        private Image image = null;
        private double rate = 1.0;

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        double getRate() {
            return this.rate;
        }

        Image getImage() {
            return this.image;
        }

        int getImageWidth() {
            return this.imgW;
        }

        int getImageHeight() {
            return this.imgH;
        }

        ImageInfo(Image image, int n, int n2, double d, int n3, int n4) {
            this.image = image;
            this.width = n;
            this.height = n2;
            this.rate = d;
            this.imgW = n3;
            this.imgH = n4;
        }
    }
}

