/*
 * Decompiled with CFR 0.152.
 */
package component.tree;

import component.search.NodeFilter;
import component.tree.TreeNode;
import component.util.StringUnpacker;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeModel {
    private TreeNode rootNode = null;
    private URL baseUrl;
    private Hashtable nodeDescrs = new Hashtable();
    private Hashtable images = new Hashtable();
    private static final String ROOT_ID = "ROOT";
    private static final String BID = "BID";
    private static final String IMG = "IMG";
    private static final String NAME = "NAME";
    private static final String REF = "REF";
    private static final String CHILDS = "CHILDS";

    public TreeModel(String string, URL uRL) {
        this.baseUrl = uRL;
        Vector vector = this.getStringListSimple(string, '/', 'a', ';');
        int n = 0;
        while (n < vector.size()) {
            String string2 = ((String)vector.elementAt(n)).trim();
            int n2 = string2.indexOf(">");
            if (n2 >= 1) {
                String string3 = string2.substring(0, n2).trim();
                String string4 = n2 >= string2.length() - 1 ? "" : string2.substring(n2 + 1).trim();
                this.nodeDescrs.put(string3, string4);
            }
            ++n;
        }
        this.rootNode = this.createNode(ROOT_ID);
        this.fillNode(this.rootNode);
        this.rootNode.setCollapsed(false);
    }

    public Vector findNodes(NodeFilter nodeFilter) {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        Enumeration enumeration = this.nodeDescrs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TreeNode treeNode = this.createNode(string);
            if (!nodeFilter.accept(treeNode) || this.isNodePresent(vector, treeNode)) continue;
            vector.addElement(treeNode);
        }
        return vector;
    }

    private boolean isNodePresent(Vector vector, TreeNode treeNode) {
        int n = 0;
        while (n < vector.size()) {
            boolean bl;
            boolean bl2;
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n);
            boolean bl3 = treeNode2.getBid() != null ? treeNode2.getBid().equals(treeNode.getBid()) : (bl2 = treeNode.getBid() == null);
            boolean bl4 = treeNode2.getLabel() != null ? treeNode2.getLabel().equals(treeNode.getLabel()) : (bl = treeNode.getLabel() == null);
            if (bl && bl2 && this.isArrayEquals(treeNode2.getReferences(), treeNode.getReferences())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isArrayEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!objectArray[n].equals(objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void fillNode(TreeNode treeNode) {
        String string = treeNode.getChildIds();
        if (treeNode.isFilled()) {
            return;
        }
        treeNode.setFilled(true);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TreeNode treeNode2 = this.createNode(string2);
            treeNode.addChild(treeNode2);
        }
    }

    private TreeNode createNode(String string) {
        Object object;
        Object object2;
        Object object3;
        String string2 = (String)this.nodeDescrs.get(string);
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.getStringListEx(string2, '/', 'n', ',');
        int n = 0;
        while (n < vector2.size()) {
            object3 = ((String)vector2.elementAt(n)).trim();
            object2 = ((String)object3).toUpperCase();
            if (((String)object2).startsWith(IMG)) {
                string3 = this.getNodePropertyValue((String)object3);
            } else if (((String)object2).startsWith(NAME)) {
                string4 = this.getNodePropertyValue((String)object3);
            } else if (((String)object2).startsWith(BID)) {
                string5 = this.getNodePropertyValue((String)object3);
            } else if (((String)object2).startsWith(REF)) {
                object = this.getNodePropertyValue((String)object3);
                if (object != null) {
                    vector.addElement(object);
                }
            } else if (((String)object2).startsWith(CHILDS)) {
                string6 = this.getNodePropertyValue((String)object3);
            }
            ++n;
        }
        object3 = new String[vector.size()];
        vector.copyInto((Object[])object3);
        object2 = null;
        if (string3 != null) {
            if (this.images.contains(string3)) {
                object2 = (Image)this.images.get(string3);
            } else {
                try {
                    object2 = Toolkit.getDefaultToolkit().getImage(new URL(this.baseUrl, string3));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (object2 != null) {
                    this.images.put(string3, object2);
                }
            }
        }
        object = new TreeNode(string, string4, (Image)object2, (String[])object3, string6, string5);
        ((TreeNode)object).setCollapsed(true);
        return object;
    }

    private String getNodePropertyValue(String string) {
        int n = string.indexOf("=");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1).trim();
        }
        return null;
    }

    private Vector getStringList(String string, char c, char c2, char c3) {
        Vector vector;
        Vector vector2 = StringUnpacker.getStringList(string, c, c2);
        if ((vector2 == null || vector2.size() <= 1) && (vector = StringUnpacker.getStringList(string, c3)) != null && vector.size() > 1) {
            vector2 = vector;
        }
        return vector2;
    }

    private Vector getStringListEx(String string, char c, char c2, char c3) {
        Vector vector;
        Vector vector2 = StringUnpacker.getStringList(string, c, c2);
        if ((vector2 == null || vector2.size() <= 1) && (vector = StringUnpacker.getStringListEx(string, c3)) != null && vector.size() > 1) {
            vector2 = vector;
        }
        return vector2;
    }

    private Vector getStringListSimple(String string, char c, char c2, char c3) {
        Vector vector = StringUnpacker.getStringList(string, c3);
        return vector;
    }
}

