/*
 * Decompiled with CFR 0.152.
 */
package component.tree;

import component.tree.TreeModel;
import component.tree.TreeNode;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import navigation.Navigation;

public class Tree
extends Panel
implements MouseListener,
MouseMotionListener,
KeyListener,
AdjustmentListener,
FocusListener {
    protected TreeModel model;
    private Image expandedImage;
    private Image collapsedImage;
    protected int labelOffset;
    protected int imageOffset;
    protected Dimension insets;
    protected Dimension rootHandleDim;
    protected int indent;
    protected Dimension iconDim;
    protected int cellHeight;
    protected int fontBaseOffset;
    private int horizPosPixels;
    private int vertPosPixels;
    private Dimension imageDim;
    protected boolean isLayoutComplete;
    protected boolean showRootHandles;
    protected Applet applet;
    protected TreeNode selectedNode;
    protected Image imgDoubleBuffer;
    protected Rectangle displayedRect;
    protected Scrollbar sb_Horizontal;
    protected Scrollbar sb_Vertical;
    protected Button scrollCorner;
    private boolean isRootVisible;
    private boolean isNSScrollers;
    private boolean hasFocus;
    protected static final int HORIZONTAL_SB_HEIGHT = 16;
    protected static final int VERTICAL_SB_WIDTH = 16;
    private boolean isMac;

    public Tree(String string, URL uRL) {
        uRL = Navigation.fixUrlForOpera(uRL);
        this.imageDim = new Dimension();
        this.showRootHandles = true;
        this.imgDoubleBuffer = null;
        this.displayedRect = new Rectangle();
        this.hasFocus = false;
        this.isMac = false;
        this.setLayout(null);
        this.setBackground(new Color(255, 255, 255));
        this.model = new TreeModel(string, uRL);
        this.isRootVisible = this.model.getRootNode().isVisible();
        try {
            this.expandedImage = Toolkit.getDefaultToolkit().getImage(new URL(uRL, "model-tree/true.gif"));
            this.collapsedImage = Toolkit.getDefaultToolkit().getImage(new URL(uRL, "model-tree/false.gif"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.labelOffset = 6;
        this.imageOffset = 3;
        this.sb_Horizontal = new Scrollbar(0);
        this.sb_Vertical = new Scrollbar(1);
        this.scrollCorner = new Button();
        this.insets = new Dimension(5, 5);
        this.rootHandleDim = new Dimension(9, 9);
        this.indent = 7 + this.rootHandleDim.width;
        this.iconDim = new Dimension(16, 16);
        this.fontBaseOffset = this.iconDim.height;
        this.isMac = System.getProperty("os.name").startsWith("Mac");
        this.setFont(new Font(this.getFontName(), 0, Tree.getFontSize()));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getLeading() + fontMetrics.getAscent() + fontMetrics.getDescent();
        this.setCellHeight(n);
        this.fontBaseOffset = n < this.cellHeight ? (this.cellHeight + n) / 2 - fontMetrics.getDescent() : this.cellHeight - fontMetrics.getDescent();
        this.setSelectionToTop();
        Scrollbar scrollbar = new Scrollbar();
        scrollbar.setValues(0, 3, 0, 10);
        scrollbar.setValue(10);
        this.isNSScrollers = scrollbar.getValue() == 10;
        this.sb_Horizontal.setUnitIncrement(16);
        if (this.sb_Horizontal.getBlockIncrement() < 128) {
            this.sb_Horizontal.setBlockIncrement(128);
        }
        this.sb_Horizontal.setBackground(new Color(192, 192, 192));
        this.add(this.sb_Horizontal);
        this.sb_Vertical.setBackground(new Color(192, 192, 192));
        this.add(this.sb_Vertical);
        this.scrollCorner.setEnabled(false);
        this.add(this.scrollCorner);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.sb_Horizontal.addAdjustmentListener(this);
        this.sb_Vertical.addAdjustmentListener(this);
    }

    public TreeModel getModel() {
        return this.model;
    }

    protected TreeNode nodeAtLocation(int n, int n2) {
        if (!this.displayedRect.contains(n, n2)) {
            return null;
        }
        int n3 = n2 + this.vertPosPixels;
        TreeNode treeNode = this.model.getRootNode();
        while (treeNode != null) {
            Rectangle rectangle = treeNode.getBounds();
            if (n3 > rectangle.y && n3 <= rectangle.y + rectangle.height && treeNode.isVisible()) {
                return treeNode;
            }
            treeNode = treeNode.nextNode();
        }
        return null;
    }

    protected int getMaxWidth(TreeNode treeNode, int n, boolean bl) {
        int n2 = 0;
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            int n3;
            if (treeNode2.getBounds().width + n > n2) {
                n2 = treeNode2.getBounds().width + n;
            }
            if (!(bl && treeNode2.isCollapsed() || (n3 = this.getMaxWidth(treeNode2.getChild(), n + this.indent, bl)) <= n2)) {
                n2 = n3;
            }
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    protected int getMaxHeight(TreeNode treeNode, int n, boolean bl) {
        int n2 = n;
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            n2 += this.cellHeight;
            if (!bl || !treeNode2.isCollapsed()) {
                n2 = this.getMaxHeight(treeNode2.getChild(), n2, bl);
            }
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    public int getIconWidth() {
        return this.iconDim.width;
    }

    public void setIconWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.iconDim.width = n;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(int n) {
        this.labelOffset = n;
    }

    public void paint(Graphics graphics) {
        if (!this.isLayoutComplete) {
            this.doLayout();
        }
        if (this.imgDoubleBuffer == null) {
            return;
        }
        Graphics graphics2 = this.imgDoubleBuffer.getGraphics();
        graphics2.setFont(this.getFont());
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics2.setColor(this.getForeground());
        graphics2.translate(-this.horizPosPixels, -this.vertPosPixels);
        try {
            this.drawNodeWithChilds(graphics2, this.model.getRootNode(), this.insets.width, this.insets.height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        graphics2.dispose();
        graphics2 = this.imgDoubleBuffer.getGraphics();
        this.paintBorder(graphics2);
        graphics.drawImage(this.imgDoubleBuffer, 0, 0, this);
    }

    public void update(Graphics graphics) {
        if (!this.isLayoutComplete) {
            this.doLayout();
        }
        this.paint(graphics);
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int n) {
        this.cellHeight = n < this.iconDim.height + 1 ? this.iconDim.height + 1 : n;
        if (this.cellHeight < this.rootHandleDim.height) {
            this.cellHeight = this.rootHandleDim.height;
        }
    }

    public int getXInset() {
        return this.insets.width;
    }

    public void setXInset(int n) {
        if (n < 0) {
            n = 0;
        }
    }

    public int getYInset() {
        return this.insets.height;
    }

    public void setYInset(int n) {
        if (n < 0) {
            n = 0;
        }
    }

    public boolean isShowRootHandles() {
        return this.showRootHandles;
    }

    public void setShowRootHandles(boolean bl) {
        this.showRootHandles = bl;
    }

    public int getIconHeight() {
        return this.iconDim.height;
    }

    public void setIconHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.iconDim.height = n;
        if (n > this.cellHeight - 1) {
            this.cellHeight = n + 1;
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public synchronized void doLayout() {
        this.isLayoutComplete = false;
        this.displayedRect.setBounds(0, 0, this.getBounds().width, this.getBounds().height);
        if (this.displayedRect.width < 1 || this.displayedRect.height < 1) {
            return;
        }
        this.sizeTree(this.model.getRootNode());
        int n = this.getMaxWidth(this.model.getRootNode(), 0, true);
        int n2 = this.getMaxHeight(this.model.getRootNode(), 0, true) / this.cellHeight - (this.isRootVisible ? 0 : 1);
        if (n2 < 1) {
            return;
        }
        try {
            int n3;
            if (n + 1 > this.displayedRect.width) {
                this.displayedRect.height -= 16;
            }
            if (n2 > (n3 = this.displayedRect.height / this.cellHeight)) {
                this.displayedRect.width -= 16;
            }
            this.reshapeScrollbars(this.sb_Horizontal, 0, this.displayedRect.height, this.displayedRect.width, 16);
            this.sb_Horizontal.setValues(this.horizPosPixels, this.displayedRect.width, 0, n - (this.isNSScrollers ? this.displayedRect.width : 0));
            this.reshapeScrollbars(this.sb_Vertical, this.displayedRect.width, 0, 16, this.displayedRect.height);
            this.sb_Vertical.setValues(this.vertPosPixels / this.cellHeight, n3, 0, n2 - (this.isNSScrollers ? n3 : 0));
            this.reshapeScrollbars(this.scrollCorner, this.displayedRect.width, this.displayedRect.height, 16, 16);
            if (this.displayedRect.height < 0) {
                this.displayedRect.height = 0;
            }
            if (this.displayedRect.width < 0) {
                this.displayedRect.width = 0;
            }
            if (this.imgDoubleBuffer != null && (this.imageDim.width != this.displayedRect.width || this.imageDim.height != this.displayedRect.height)) {
                this.imgDoubleBuffer.flush();
                this.imgDoubleBuffer = null;
            }
            if (this.imgDoubleBuffer == null) {
                this.imgDoubleBuffer = this.createImage(this.displayedRect.width, this.displayedRect.height);
                this.imageDim.width = this.displayedRect.width;
                this.imageDim.height = this.displayedRect.height;
            }
            this.isLayoutComplete = true;
            return;
        }
        catch (Exception exception) {
            this.imgDoubleBuffer = null;
            return;
        }
    }

    protected void reshapeScrollbars(Component component, int n, int n2, int n3, int n4) {
        component.setLocation(n, n2);
        component.setSize(n3, n4);
    }

    protected void setSelectionToTop() {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = this.model.getRootNode();
        while (this.selectedNode != null && !this.selectedNode.isVisible()) {
            this.selectedNode = this.selectedNode.nextNode();
        }
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(true);
        }
    }

    protected synchronized void setSelectedNode(TreeNode treeNode) {
        if (treeNode == null || treeNode == this.model.getRootNode() && !this.isRootVisible) {
            return;
        }
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = treeNode;
        this.selectedNode.setSelected(true);
        this.doAction(treeNode);
        this.repaint();
    }

    protected synchronized void expandNode(TreeNode treeNode) {
        this.requestFocus();
        treeNode.setCollapsed(!treeNode.isCollapsed());
        if (treeNode.isCollapsed()) {
            int n = this.vertPosPixels / this.cellHeight;
            int n2 = this.displayedRect.height / this.cellHeight;
            int n3 = this.getMaxHeight(this.model.getRootNode(), 0, true) / this.cellHeight - 1;
            if (n + n2 > n3) {
                n = Math.max(n3 - n2, 0);
            }
            this.vertPosPixels = n * this.cellHeight;
        }
        this.doLayout();
    }

    protected void sizeNode(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        if (this.showRootHandles) {
            n = this.iconDim.width;
        }
        if (treeNode.getImage() != null) {
            n += this.iconDim.width + this.labelOffset;
        }
        if (treeNode.isVisible()) {
            n += fontMetrics.stringWidth(treeNode.getLabel());
        } else if (treeNode.getImage() != null) {
            n -= this.labelOffset;
        }
        treeNode.setBounds(new Rectangle(0, 0, n, this.cellHeight));
    }

    protected void sizeTree(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            this.sizeNode(treeNode2);
            this.sizeTree(treeNode2.getChild());
            treeNode2 = treeNode2.getSibling();
        }
    }

    protected void drawNode(Graphics graphics, TreeNode treeNode, int n, int n2) {
        treeNode.moveBounds(n, n2);
        n = this.drawRootHandle(graphics, treeNode, n, n2);
        if (treeNode.getImage() != null) {
            graphics.drawImage(treeNode.getImage(), n += this.imageOffset, n2 + 1, this.iconDim.width, this.iconDim.height, this);
            n += this.iconDim.width;
        }
        if (treeNode.isVisible()) {
            n += this.labelOffset;
            n2 += this.fontBaseOffset;
            if (treeNode.isSelected()) {
                if (this.hasFocus) {
                    graphics.setColor(new Color(204, 204, 255));
                } else {
                    graphics.setColor(new Color(204, 204, 255));
                }
                Rectangle rectangle = treeNode.getBounds();
                int n3 = rectangle.width + rectangle.x - n;
                graphics.fillRect(n, rectangle.y + 1, n3, rectangle.height - 2);
                if (this.hasFocus) {
                    graphics.setColor(new Color(0, 0, 128));
                    graphics.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
                    graphics.drawLine(n - 1, rectangle.y, rectangle.width + rectangle.x, rectangle.y);
                    graphics.drawLine(rectangle.width + rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.drawLine(n - 1, rectangle.y + rectangle.height - 1, rectangle.width + rectangle.x, rectangle.y + rectangle.height - 1);
                }
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.setFont(this.getFont());
            graphics.drawString(treeNode.getLabel(), n, n2);
        }
    }

    protected int drawRootHandle(Graphics graphics, TreeNode treeNode, int n, int n2) {
        if (this.showRootHandles) {
            Image image = null;
            try {
                if (treeNode.getChildIds() != null) {
                    image = treeNode.isCollapsed() ? this.collapsedImage : this.expandedImage;
                }
            }
            catch (Exception exception) {
                image = null;
            }
            if (image != null) {
                int n3 = n2 + (this.cellHeight - this.rootHandleDim.height) / 2;
                graphics.drawImage(image, n, n3, this.rootHandleDim.width, this.rootHandleDim.height, this);
            }
            n += this.rootHandleDim.width;
        }
        return n;
    }

    protected void paintBorder(Graphics graphics) {
        Rectangle rectangle = this.displayedRect;
        Color color = this.getBackground();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color3);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color4);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    protected int drawNodeWithChilds(Graphics graphics, TreeNode treeNode, int n, int n2) {
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            int n3 = n;
            int n4 = n2;
            if (treeNode2.isVisible()) {
                this.drawNode(graphics, treeNode2, n, n2);
                n3 += this.indent;
                n4 += this.cellHeight;
            }
            n2 = !treeNode2.isCollapsed() ? this.drawNodeWithChilds(graphics, treeNode2.getChild(), n3, n4) : n4;
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    public static int getFontSize() {
        int n = 12;
        try {
            if (System.getProperty("os.name").startsWith("Windows") && !System.getProperty("java.version").equals("1.1.4")) {
                n = 10;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private String getFontName() {
        return "Dialog";
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.displayedRect.contains(mouseEvent.getPoint().x, mouseEvent.getPoint().y)) {
            return;
        }
        int n = mouseEvent.getClickCount();
        int n2 = mouseEvent.getPoint().x + this.horizPosPixels;
        int n3 = 11;
        TreeNode treeNode = this.nodeAtLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treeNode != null) {
            boolean bl;
            boolean bl2 = bl = !this.isMac && n % 2 == 0;
            if (this.isMac && !bl) {
                n = 1;
            }
            if (!treeNode.isFilled()) {
                this.model.fillNode(treeNode);
            }
            if (treeNode.getChild() != null && n2 > treeNode.getBounds().x && (n2 < treeNode.getBounds().x + n3 || bl)) {
                this.expandNode(treeNode);
                this.setSelectedNode(treeNode);
            } else if (n2 > treeNode.getBounds().x + n3 && n < 2) {
                this.setSelectedNode(treeNode);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.applet != null) {
            Point point = mouseEvent.getPoint();
            TreeNode treeNode = this.nodeAtLocation(point.x, point.y);
            if (treeNode != null) {
                this.applet.showStatus(treeNode.getLabel());
            } else {
                this.applet.showStatus("");
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sb_Horizontal) {
            this.horizPosPixels = this.sb_Horizontal.getValue();
        } else if (adjustmentEvent.getSource() == this.sb_Vertical) {
            this.vertPosPixels = this.sb_Vertical.getValue() * this.cellHeight;
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.selectedNode == null) {
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            if (!this.selectedNode.isFilled()) {
                this.model.fillNode(this.selectedNode);
            }
            this.expandNode(this.selectedNode);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 40) {
            this.setSelectedNode(this.selectedNode.nextNode());
            if (this.selectedNode.getBounds().y + this.cellHeight - this.vertPosPixels > this.displayedRect.height) {
                this.vertPosPixels += this.cellHeight;
                if (this.sb_Vertical.getVisibleAmount() + this.sb_Vertical.getValue() >= this.sb_Vertical.getMaximum()) {
                    this.sb_Vertical.setMaximum(this.sb_Vertical.getMaximum() + 1);
                }
                this.sb_Vertical.setValue(this.sb_Vertical.getValue() + 1);
                this.repaint();
            }
        } else if (keyEvent.getKeyCode() == 38) {
            this.setSelectedNode(this.selectedNode.prevNode());
            if (this.selectedNode.getBounds().y < this.vertPosPixels) {
                this.sb_Vertical.setValue(this.sb_Vertical.getValue() - 1);
                this.vertPosPixels -= this.cellHeight;
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaint();
    }

    public void doAction(TreeNode treeNode) {
        String[] stringArray = treeNode.getReferences();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf("->");
            if (n2 >= 1) {
                String string2 = string.substring(0, n2);
                if (n2 + 2 < string.length()) {
                    String string3 = string.substring(n2 + 2);
                    try {
                        URL uRL = new URL(Navigation.fixUrlForOpera(this.applet.getDocumentBase()), string2);
                        this.applet.getAppletContext().showDocument(uRL, string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return;
                    }
                }
            }
            ++n;
        }
    }
}

