/*
 * Decompiled with CFR 0.152.
 */
package component.search;

import component.search.BIDFilter;
import component.search.NameFilter;
import component.search.NodeFilter;
import component.tree.Tree;
import component.tree.TreeNode;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class SearchTab
extends Panel {
    private Tree myTree;
    private Checkbox myCaseSensitiveCheckbox;
    private TextField myStringField;
    private List myResultList;
    private Vector myLastSearchNodes;
    private Checkbox mySeacrhByBidCheckbox;
    private Checkbox mySeacrhByNameCheckbox;
    private Button mySearchButton;

    public SearchTab(Tree tree, String string, String string2, String string3, String string4) {
        this.myTree = tree;
        this.setLayout(new GridBagLayout());
        Panel panel = new Panel(new BorderLayout(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add((Component)panel, gridBagConstraints);
        this.mySearchButton = new Button(string);
        this.myStringField = new TextField();
        this.myStringField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchTab.this.search();
            }
        });
        Panel panel2 = new Panel(new BorderLayout(5, 5));
        panel2.add("Center", this.myStringField);
        panel2.add("East", this.mySearchButton);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.mySeacrhByNameCheckbox = new Checkbox(string3, checkboxGroup, true);
        this.mySeacrhByBidCheckbox = new Checkbox(string2, checkboxGroup, false);
        this.myCaseSensitiveCheckbox = new Checkbox(string4);
        Panel panel3 = new Panel(new GridLayout(2, 2, 6, 0));
        panel3.add(this.mySeacrhByNameCheckbox);
        panel3.add(this.myCaseSensitiveCheckbox);
        panel3.add(this.mySeacrhByBidCheckbox);
        Panel panel4 = new Panel(new BorderLayout());
        panel4.add("South", panel3);
        panel4.add("North", panel2);
        this.myResultList = new List();
        this.myResultList.setMultipleMode(false);
        this.myResultList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SearchTab.this.myResultList.getSelectedIndex();
                if (SearchTab.this.myLastSearchNodes != null && n >= 0 && n < SearchTab.this.myLastSearchNodes.size()) {
                    SearchTab.this.myTree.doAction((TreeNode)SearchTab.this.myLastSearchNodes.elementAt(n));
                }
            }
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.myResultList);
        panel.add("North", panel4);
        panel.add("Center", scrollPane);
        this.mySearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchTab.this.search();
            }
        });
    }

    private void enableComponents(boolean bl) {
        this.myCaseSensitiveCheckbox.setEnabled(bl);
        this.mySeacrhByBidCheckbox.setEnabled(bl);
        this.mySeacrhByNameCheckbox.setEnabled(bl);
        this.myStringField.setEnabled(bl);
        this.mySearchButton.setEnabled(bl);
    }

    private void search() {
        try {
            try {
                this.enableComponents(false);
                this.setCursor(new Cursor(3));
                this.searchProcess();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.setCursor(Cursor.getDefaultCursor());
                this.enableComponents(true);
            }
            Object var3_1 = null;
            this.setCursor(Cursor.getDefaultCursor());
            this.enableComponents(true);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setCursor(Cursor.getDefaultCursor());
            this.enableComponents(true);
            throw throwable;
        }
    }

    private void searchProcess() {
        this.myResultList.removeAll();
        this.myLastSearchNodes = null;
        String string = this.myStringField.getText();
        if (string != null && !"".equals(string)) {
            NodeFilter nodeFilter = null;
            nodeFilter = this.mySeacrhByBidCheckbox.getState() ? new BIDFilter(string, this.myCaseSensitiveCheckbox.getState()) : new NameFilter(string, this.myCaseSensitiveCheckbox.getState());
            this.myLastSearchNodes = this.myTree.getModel().findNodes(nodeFilter);
            Collections.sort(this.myLastSearchNodes, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((TreeNode)object).getLabel().compareTo(((TreeNode)object2).getLabel());
                }
            });
            int n = 0;
            while (n < this.myLastSearchNodes.size()) {
                this.myResultList.add(((TreeNode)this.myLastSearchNodes.elementAt(n)).getLabel());
                ++n;
            }
        }
    }
}

