/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.TabButton;
import component.TabEvent;
import component.TabEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class TabPane
extends Panel {
    private int offsetX = 1;
    protected Image buffer;
    private TabButton lastTab = null;
    private TabButton activeTab = null;
    private Vector listeners = new Vector();

    public TabPane() {
        this.setLayout(null);
        this.setBackground(new Color(192, 192, 192));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.buffer == null) {
            try {
                this.buffer = this.createImage(this.getBounds().width, this.getBounds().height);
            }
            catch (Throwable throwable) {
                this.buffer = null;
            }
        }
        Color color = this.getBackground();
        Color color2 = color.brighter();
        Color color3 = color2.darker();
        Graphics graphics2 = this.buffer.getGraphics();
        Rectangle rectangle = this.getBounds();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(color2);
        if (this.lastTab != null) {
            Rectangle rectangle2 = this.lastTab.getBounds();
            int n = 0;
            int n2 = rectangle2.y + rectangle2.height;
            graphics2.drawLine(n, n2 - 2, rectangle.width, n2 - 2);
            graphics2.setColor(color3);
            graphics2.drawLine(n, n2 - 1, rectangle.width, n2 - 1);
        }
        graphics.drawImage(this.buffer, this.getBounds().x, this.getBounds().y, this);
    }

    public TabButton addTab(String string) {
        TabButton tabButton = new TabButton(string);
        tabButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof TabButton) {
                    TabButton tabButton = (TabButton)mouseEvent.getSource();
                    tabButton.setPushState(true);
                    tabButton.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof TabButton) {
                    TabButton tabButton = (TabButton)mouseEvent.getSource();
                    tabButton.setPushState(false);
                    tabButton.repaint();
                    Rectangle rectangle = tabButton.getBounds();
                    if (rectangle.contains(mouseEvent.getX() + rectangle.x, mouseEvent.getY() + rectangle.y)) {
                        TabPane.this.activateTab(tabButton);
                    }
                }
            }
        });
        this.lastTab = tabButton;
        super.add(tabButton);
        tabButton.setSize(tabButton.getPreferredSize().width, 25);
        tabButton.setLocation(this.offsetX, 2);
        this.offsetX += tabButton.getSize().width + 1;
        tabButton.setEnabled(true);
        this.repaint();
        return tabButton;
    }

    public void setActiveTab(String string) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof TabButton && componentArray[n].getName().equals(string)) {
                this.activateTab((TabButton)componentArray[n]);
                return;
            }
            ++n;
        }
    }

    private void activateTab(TabButton tabButton) {
        if (this.activeTab != null) {
            this.activeTab.setEnabled(true);
        }
        this.activeTab = tabButton;
        this.activeTab.setEnabled(false);
        this.fireTabChanged(tabButton, tabButton.getName());
    }

    public synchronized void setSize(int n, int n2) {
        if (this.buffer != null && (this.getBounds().width != n || this.getBounds().height != n2)) {
            this.buffer.flush();
            this.buffer = null;
        }
        super.setSize(n, n2);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        if (this.buffer != null && (this.getBounds().width != n3 || this.getBounds().height != n4)) {
            this.buffer.flush();
            this.buffer = null;
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void fireTabChanged(Object object, String string) {
        TabEvent tabEvent = new TabEvent(object, string);
        int n = 0;
        while (n < this.listeners.size()) {
            TabEventListener tabEventListener = (TabEventListener)this.listeners.elementAt(n);
            tabEventListener.tabChanged(tabEvent);
            ++n;
        }
    }

    public void addTabEventListener(TabEventListener tabEventListener) {
        this.listeners.addElement(tabEventListener);
    }

    public void removeTabEventListener(TabEventListener tabEventListener) {
        this.listeners.removeElement(tabEventListener);
    }
}

