#include "colours.h"

SDL_Color colours_black = {0x00, 0x00, 0x00, 0xFF};
SDL_Color colours_offWhite = {0xF4, 0xF4, 0xF4, 0xFF};

ColourPalette colours_blue = {
  {0x00, 0x3D, 0xCD, 0xFF},
  {0x0B, 0x54, 0xFF, 0xFF},
  {0x00, 0x2B, 0x90, 0xFF}
};

ColourPalette colours_green = {
  {0x00, 0xCD, 0x37, 0xFF},
  {0x0B, 0xFF, 0x4D, 0xFF},
  {0x00, 0x90, 0x27, 0xFF},
};

ColourPalette colours_red = {
  {0xCD, 0x00, 0x30, 0xFF},
  {0xFF, 0x0B, 0x45, 0xFF},
  {0x90, 0x00, 0x22, 0xFF}
};

ColourPalette colours_orange = {
  {0xDF, 0x85, 0x00, 0xFF},
  {0xFF, 0xA6, 0x23, 0xFF},
  {0x9C, 0x5D, 0x00, 0xFF}
};

ColourPalette colours_purple = {
  {0x89, 0x00, 0xCD, 0xFF},
  {0xAE, 0x0B, 0xFF, 0xFF},
  {0x60, 0x00, 0x90, 0xFF}
};

ColourPalette colours_turqoise = {
  {0x00, 0xCD, 0xC3, 0xFF},
  {0x0B, 0xFF, 0xF3, 0xFF},
  {0x00, 0x90, 0x88, 0xFF}
};

ColourPalette colours_yellow = {
  {0xD8, 0xD2, 0x00, 0xFF},
  {0xFF, 0xF9, 0x1A, 0xFF},
  {0x97, 0x93, 0x00, 0xFF}
};

ColourPalette* colours_blockPalette (BlockNames blockKey) {
  switch (blockKey) {
    case BLOCK_I: return &colours_orange;
    case BLOCK_J: return &colours_green;
    case BLOCK_L: return &colours_purple;
    case BLOCK_O: return &colours_yellow;
    case BLOCK_S: return &colours_red;
    case BLOCK_T: return &colours_blue;
    case BLOCK_Z:
    default:
      return &colours_turqoise;
  }
}
