/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.util.Hashtable;

public class SQLError {
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_DEADLOCK = "41000";
    public static final String SQL_STATE_CONNECTION_FAIL_DURING_TX = "08007";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    public static final String SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION = "23000";
    private static Hashtable mysqlToSqlState;
    private static Hashtable mysqlToSql99State;
    private static Hashtable sqlStateMessages;

    static String get(String stateCode) {
        return (String)sqlStateMessages.get(stateCode);
    }

    static String mysqlToSqlState(int errno, boolean useSql92States) {
        if (useSql92States) {
            return SQLError.mysqlToSql99(errno);
        }
        return SQLError.mysqlToXOpen(errno);
    }

    private static String mysqlToXOpen(int errno) {
        Integer err = new Integer(errno);
        if (mysqlToSqlState.containsKey(err)) {
            return (String)mysqlToSqlState.get(err);
        }
        return SQL_STATE_GENERAL_ERROR;
    }

    private static String mysqlToSql99(int errno) {
        Integer err = new Integer(errno);
        if (mysqlToSql99State.containsKey(err)) {
            return (String)mysqlToSql99State.get(err);
        }
        return "HY000";
    }

    static {
        sqlStateMessages = new Hashtable();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, "Disconnect error");
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, "Data truncated");
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, "Privilege not revoked");
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, "Invalid connection string attribute");
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, "Error in row");
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, "No rows updated or deleted");
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, "More than one row updated or deleted");
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, "Wrong number of parameters");
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, "Unable to connect to data source");
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, "Connection in use");
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, "Connection not open");
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, "Data source rejected establishment of connection");
        sqlStateMessages.put(SQL_STATE_CONNECTION_FAIL_DURING_TX, "Connection failure during transaction");
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, "Communication link failure");
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, "Insert value list does not match column list");
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, "Numeric value out of range");
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, "Datetime field overflow");
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, "Division by zero");
        sqlStateMessages.put(SQL_STATE_DEADLOCK, "Deadlock found when trying to get lock; Try restarting transaction");
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, "Invalid authorization specification");
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, "Syntax error or access violation");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, "Base table or view not found");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, "Base table or view already exists");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, "Base table not found");
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, "Index already exists");
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, "Index not found");
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, "Column already exists");
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, "Column not found");
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, "No default for column");
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, "General error");
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, "Memory allocation failure");
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, "Invalid column number");
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, "Invalid argument value");
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, "Driver not capable");
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, "Timeout expired");
        sqlStateMessages.put(SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION, "Duplicate key or integrity constraint violation");
        mysqlToSqlState = new Hashtable();
        mysqlToSqlState.put(new Integer(1040), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1042), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1043), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1047), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(new Integer(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(new Integer(1129), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1130), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1045), SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSqlState.put(new Integer(1037), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(new Integer(1038), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(new Integer(1064), SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(new Integer(1065), SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(new Integer(1055), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1056), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1057), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1059), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1060), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1061), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1062), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSqlState.put(new Integer(1063), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1066), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1067), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1068), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1069), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1070), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1071), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1072), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1073), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1074), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1075), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1082), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1083), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1084), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSqlState.put(new Integer(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSqlState.put(new Integer(1054), SQL_STATE_COLUMN_NOT_FOUND);
        mysqlToSqlState.put(new Integer(1205), SQL_STATE_DEADLOCK);
        mysqlToSqlState.put(new Integer(1213), SQL_STATE_DEADLOCK);
        mysqlToSqlState.put(new Integer(1169), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSqlState.put(new Integer(1216), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSqlState.put(new Integer(1217), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State = new Hashtable();
        mysqlToSql99State.put(new Integer(1022), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1037), "HY001");
        mysqlToSql99State.put(new Integer(1038), "HY001");
        mysqlToSql99State.put(new Integer(1040), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(new Integer(1042), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1043), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1044), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1045), SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSql99State.put(new Integer(1050), "42S01");
        mysqlToSql99State.put(new Integer(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(new Integer(1052), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1053), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1054), "42S22");
        mysqlToSql99State.put(new Integer(1055), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1056), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1057), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(new Integer(1059), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1060), "42S21");
        mysqlToSql99State.put(new Integer(1061), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1062), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1063), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1064), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1065), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1066), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1067), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1068), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1069), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1070), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1071), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1072), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1073), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1074), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1075), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1080), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1082), "42S12");
        mysqlToSql99State.put(new Integer(1083), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1084), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1090), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1091), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1101), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1102), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1103), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1104), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1106), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1107), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1109), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(new Integer(1110), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1112), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1113), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1115), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1118), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1120), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1121), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1131), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1132), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1133), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1136), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(new Integer(1138), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1139), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1140), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1141), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1142), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1143), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1144), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1145), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1146), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(new Integer(1147), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1148), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1149), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1152), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1153), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1154), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1155), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1156), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1157), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1158), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1159), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1160), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1161), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1162), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1163), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1164), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1166), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1167), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1169), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1170), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1171), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1172), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1173), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1177), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1178), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1179), "25000");
        mysqlToSql99State.put(new Integer(1184), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1189), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1190), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1203), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1207), "25000");
        mysqlToSql99State.put(new Integer(1211), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1213), "40001");
        mysqlToSql99State.put(new Integer(1216), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1217), SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(new Integer(1218), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(new Integer(1222), "21000");
        mysqlToSql99State.put(new Integer(1226), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1230), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1231), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1232), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1234), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1235), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1239), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1241), "21000");
        mysqlToSql99State.put(new Integer(1242), "21000");
        mysqlToSql99State.put(new Integer(1247), "42S22");
        mysqlToSql99State.put(new Integer(1248), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1249), "01000");
        mysqlToSql99State.put(new Integer(1250), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1251), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(new Integer(1252), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1253), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1261), "01000");
        mysqlToSql99State.put(new Integer(1262), "01000");
        mysqlToSql99State.put(new Integer(1263), "01000");
        mysqlToSql99State.put(new Integer(1264), "01000");
        mysqlToSql99State.put(new Integer(1265), "01000");
        mysqlToSql99State.put(new Integer(1280), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1281), SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(new Integer(1286), SQL_STATE_SYNTAX_ERROR);
    }
}

