#ifndef _T_NUMERIC_H
#define _T_NUMERIC_H

#include <stdint.h>

#include "t_defs.h"

typedef int16_t numeric_t;

#define NUMERIC_GET(_toks) (*(numeric_t *)(_toks+1))
#define NUMERIC_SIZE 3

/* t_numeric_put
 *
 * Purpose:
 *     Write a numeric (int) to the given token stream.
 * 
 * Parameters:
 *     toks: Token stream to write to.
 *     num:  Numeric value to write.
 * 
 * Returns:
 *     Nothing.
 */
void t_numeric_put(tok_t * toks, numeric_t num);

/* t_numeric_parse
 *
 * Purpose:
 *     Parse a numeric in the given input into the token stream.
 *
 * Parameters:
 *     stmt:  Token stream to write to.
 *     input: Input from which to parse numeric.
 * 
 * Returns:
 *     true value if a numeric has been parsed, false otherwise.
 */
int t_numeric_parse(tok_t ** dst_ptr, const char ** input_ptr);

const tok_t * t_numeric_list(const tok_t * toks);

#endif
