<div align="center">
  
# Fixedsys (a CSS font family)
***Old Fashion CSS Framework for nostalgics***
  
[![npm version](https://badge.fury.io/js/fixedsys-css.svg)](https://badge.fury.io/js/fixedsys-css)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)
[![PR's welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://github.com/javanile/fixedsys-css/pulls)
  
</div>

## Fixedsys font

<img alt="Fixedsysfontpreview.svg" align="right" src="https://upload.wikimedia.org/wikipedia/commons/thumb/e/e6/Fixedsysfontpreview.svg/220px-Fixedsysfontpreview.svg.png" width="220" height="260">

Fixedsys is a family of raster monospaced fonts. The name means fixed system, because its glyphs are monospace or fixed-width (although bolded characters are wider than non-bolded, unlike other monospace fonts such as Courier). It is the oldest font in Windows, and was the system font in Windows 1.0 and 2.0, where it was simply named "System". For Windows 3.x, the system font was changed to a proportional sans-serif font named System, but Fixedsys remained the default font in Notepad.

Fixedsys fonts family contains fonts encoded in several Windows code pages, with multiple resolutions of the font for each code page. Fixedsys fonts of different code pages have different point sizes.

<details>
  <summary>Continue reading...</summary>
  <br>
  The glyphs for the upper areas of each one appear to be drawn separately, not taken from a single master set, as there are visible differences in the appearance of various visually similar characters that are shared between the code pages.

  Though Fixedsys is a sans-serif font, it is vaguely similar in appearance to the hardware text mode font of most IBM-compatible PCs, though not as similar as certain sizes of Terminal fonts seen in Windows.

  In Windows 95, 98, and Windows Me, Fixedsys remains as the default font for Notepad. This font was superseded by Lucida Console in Notepad for later versions of Windows. In Windows 95, this default font cannot be changed. Fixedsys of other code pages can be selected by specifying script settings in font selection dialogue, but not font of all code pages can be chosen.

  Due to its clean style and easy readability, it has enjoyed some popularity with the programming community, even giving rise to an imitation font — Fixedsys Excelsior — which, based on the original Fixedsys typeface, also includes a large number of Unicode script ranges.[1]

  There is a certain amount of similarity between Fixedsys and Chicago, the default system typeface on the Apple Macintosh between 1984 and 1997. The key difference is that Chicago is a proportional typeface while Fixedsys is monospaced.
</details>

## Quick start
   
Several quick start options are available:
   
* [Download the latest release](https://github.com/javanile/fixedsys-css/archive/refs/heads/main.zip)
* Clone the repo: `git clone https://github.com/javanile/fixedsys-css.git`
* Install with npm: `npm install fixedsys-css`
* Install with yarn: `yarn add fixedsys-css`
* Include from CDN: `<link rel="stylesheet" href="https://unpkg.com/fixedsys-css/css/fixedsys.css">`

## Support us

> No money, a tweet is what we need! Use the below button to share our work on Twitter, help us increase the visibility of this project. 
> It is a small effort that we ask of you, it helps our team to have credibility and to be able to acquire new customers for our services.
> Thanks!  

[![Share on Twitter](https://img.shields.io/badge/-share%20on%20twitter-blue?logo=twitter&style=for-the-badge)](https://twitter.com/intent/tweet?text=Fixedsys%20is%20a%20family%20of%20raster%20monospaced%20fonts.%20The%20name%20means%20fixed%20system%2C%20because%20its%20glyphs%20are%20monospace%20or%20fixed-width%20%23Bulma%20%23CSS%20%23BEM%20%23DEVCommunity%20%23GirlsWhoCode%20%23Retrocomputing%20%23Retrogaming%20%23Bootstrap%20%23foundation%0A%40francescobianco%20%40javanile%0Ahttps%3A%2F%2Fgithub.com%2Fjavanile%2Ffixedsys-css)


## Usage

You can use the following code to get old fashion style on your project.

```html
<div class="font-fixedsys">
    Hello World!
</div>
```

```css
.old-fashion-message {
    font-family: fixedsys;
    font-size: 16px;
}
```

## Themes

You can use our general-purpose themes

* [Default theme](https://fixedsys.javanile.org/test/default)
* [Dark theme](https://fixedsys.javanile.org/test/dark)

## Credits

Special Thanks to [Adam Moore (LÆMEUR)](https://laemeur.sdf.org)

## See Also

- <https://en.wikipedia.org/wiki/Fixedsys>
- <http://laemeur.sdf.org/fonts/>

## License

The MIT License (MIT). Please see [License File](LICENSE) for more information.
