/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.lazy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class LazyLoader {
    private final Map<String, Link> mapClassLinks = new HashMap<String, Link>();
    private final IBytecodeProvider provider;

    public LazyLoader(IBytecodeProvider provider) {
        this.provider = provider;
    }

    public void addClassLink(String className, Link link) {
        this.mapClassLinks.put(className, link);
    }

    public void removeClassLink(String className) {
        this.mapClassLinks.remove(className);
    }

    public Link getClassLink(String className) {
        return this.mapClassLinks.get(className);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConstantPool loadPool(String className) {
        try (DataInputFullStream in = this.getClassStream(className);){
            if (in != null) {
                in.discard(8);
                ConstantPool constantPool = new ConstantPool(in);
                return constantPool;
            }
            ConstantPool constantPool = null;
            return constantPool;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] getClassBytes(String externalPath, String internalPath) throws IOException {
        return this.provider.getBytecode(externalPath, internalPath);
    }

    public DataInputFullStream getClassStream(String externalPath, String internalPath) throws IOException {
        return new DataInputFullStream(this.getClassBytes(externalPath, internalPath));
    }

    public DataInputFullStream getClassStream(String qualifiedClassName) throws IOException {
        Link link = this.mapClassLinks.get(qualifiedClassName);
        return link == null ? null : (link.data != null ? new DataInputFullStream(link.data) : this.getClassStream(link.externalPath, link.internalPath));
    }

    public static class Link {
        public final String externalPath;
        public final String internalPath;
        public final byte[] data;

        public Link(String externalPath, String internalPath) {
            this(externalPath, internalPath, null);
        }

        public Link(String externalPath, String internalPath, byte[] data) {
            this.externalPath = externalPath;
            this.internalPath = internalPath;
            this.data = data;
        }
    }
}

