/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.NewClassNameBuilder;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class ConstantPool
implements NewClassNameBuilder {
    public static final int FIELD = 1;
    public static final int METHOD = 2;
    private final List<PooledConstant> pool;
    private final PoolInterceptor interceptor;

    public ConstantPool(DataInputStream in) throws IOException {
        int size = in.readUnsignedShort();
        this.pool = new ArrayList<PooledConstant>(size);
        BitSet[] nextPass = new BitSet[]{new BitSet(size), new BitSet(size), new BitSet(size)};
        this.pool.add(null);
        block11: for (int i = 1; i < size; ++i) {
            byte tag = (byte)in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    this.pool.add(new PrimitiveConstant(1, in.readUTF()));
                    continue block11;
                }
                case 3: {
                    this.pool.add(new PrimitiveConstant(3, (Object)in.readInt()));
                    continue block11;
                }
                case 4: {
                    this.pool.add(new PrimitiveConstant(4, Float.valueOf(in.readFloat())));
                    continue block11;
                }
                case 5: {
                    this.pool.add(new PrimitiveConstant(5, in.readLong()));
                    this.pool.add(null);
                    ++i;
                    continue block11;
                }
                case 6: {
                    this.pool.add(new PrimitiveConstant(6, in.readDouble()));
                    this.pool.add(null);
                    ++i;
                    continue block11;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.pool.add(new PrimitiveConstant((int)tag, in.readUnsignedShort()));
                    nextPass[0].set(i);
                    continue block11;
                }
                case 12: {
                    this.pool.add(new LinkConstant(tag, in.readUnsignedShort(), in.readUnsignedShort()));
                    nextPass[0].set(i);
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: {
                    this.pool.add(new LinkConstant(tag, in.readUnsignedShort(), in.readUnsignedShort()));
                    nextPass[1].set(i);
                    continue block11;
                }
                case 15: {
                    this.pool.add(new LinkConstant(tag, in.readUnsignedByte(), in.readUnsignedShort()));
                    nextPass[2].set(i);
                    continue block11;
                }
                default: {
                    throw new RuntimeException("Invalid Constant Pool entry #" + i + " Type: " + tag);
                }
            }
        }
        for (BitSet pass : nextPass) {
            int idx = 0;
            while ((idx = pass.nextSetBit(idx + 1)) > 0) {
                this.pool.get(idx).resolveConstant(this);
            }
        }
        this.interceptor = DecompilerContext.getPoolInterceptor();
    }

    public String[] getClassElement(int elementType, String className, int nameIndex, int descriptorIndex) {
        String elementName = ((PrimitiveConstant)this.getConstant(nameIndex)).getString();
        String descriptor = ((PrimitiveConstant)this.getConstant(descriptorIndex)).getString();
        if (this.interceptor != null) {
            String newDescriptor;
            String newElement;
            String oldClassName = this.interceptor.getOldName(className);
            if (oldClassName != null) {
                className = oldClassName;
            }
            if ((newElement = this.interceptor.getName(className + ' ' + elementName + ' ' + descriptor)) != null) {
                elementName = newElement.split(" ")[1];
            }
            if ((newDescriptor = this.buildNewDescriptor(elementType == 1, descriptor)) != null) {
                descriptor = newDescriptor;
            }
        }
        return new String[]{elementName, descriptor};
    }

    public PooledConstant getConstant(int index) {
        return this.pool.get(index);
    }

    public PrimitiveConstant getPrimitiveConstant(int index) {
        String newName;
        PrimitiveConstant cn = (PrimitiveConstant)this.getConstant(index);
        if (cn != null && this.interceptor != null && cn.type == 7 && (newName = this.buildNewClassname(cn.getString())) != null) {
            cn = new PrimitiveConstant(7, newName);
        }
        return cn;
    }

    public LinkConstant getLinkConstant(int index) {
        LinkConstant ln = (LinkConstant)this.getConstant(index);
        if (ln != null && this.interceptor != null && (ln.type == 9 || ln.type == 10 || ln.type == 11)) {
            String newClassName = this.buildNewClassname(ln.classname);
            String newElement = this.interceptor.getName(ln.classname + ' ' + ln.elementname + ' ' + ln.descriptor);
            String newDescriptor = this.buildNewDescriptor(ln.type == 9, ln.descriptor);
            if (newClassName != null || newElement != null || newDescriptor != null) {
                String className = newClassName == null ? ln.classname : newClassName;
                String elementName = newElement == null ? ln.elementname : newElement.split(" ")[1];
                String descriptor = newDescriptor == null ? ln.descriptor : newDescriptor;
                ln = new LinkConstant(ln.type, className, elementName, descriptor);
            }
        }
        return ln;
    }

    @Override
    public String buildNewClassname(String className) {
        VarType vt = new VarType(className, true);
        String newName = this.interceptor.getName(vt.value);
        if (newName != null) {
            StringBuilder buffer = new StringBuilder();
            if (vt.arrayDim > 0) {
                for (int i = 0; i < vt.arrayDim; ++i) {
                    buffer.append('[');
                }
                buffer.append('L').append(newName).append(';');
            } else {
                buffer.append(newName);
            }
            return buffer.toString();
        }
        return null;
    }

    private String buildNewDescriptor(boolean isField, String descriptor) {
        if (isField) {
            return FieldDescriptor.parseDescriptor(descriptor).buildNewDescriptor(this);
        }
        return MethodDescriptor.parseDescriptor(descriptor).buildNewDescriptor(this);
    }
}

