/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructEnclosingMethodAttribute
extends StructGeneralAttribute {
    private String className;
    private String methodName;
    private String methodDescriptor;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool, BytecodeVersion version) throws IOException {
        int classIndex = data.readUnsignedShort();
        int methodIndex = data.readUnsignedShort();
        this.className = pool.getPrimitiveConstant(classIndex).getString();
        if (methodIndex != 0) {
            LinkConstant lk = pool.getLinkConstant(methodIndex);
            this.methodName = lk.elementname;
            this.methodDescriptor = lk.descriptor;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

