/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructField
extends StructMember {
    private final String name;
    private final String descriptor;
    private final GenericFieldDescriptor signature;
    private final BytecodeVersion version;

    public static StructField create(DataInputFullStream in, ConstantPool pool, String clQualifiedName, BytecodeVersion version) throws IOException {
        StructGenericSignatureAttribute signatureAttr;
        int accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        String[] values = pool.getClassElement(1, clQualifiedName, nameIndex, descriptorIndex);
        Map<String, StructGeneralAttribute> attributes = StructField.readAttributes(in, pool, version);
        GenericFieldDescriptor signature = null;
        if (DecompilerContext.getOption("dgs") && (signatureAttr = (StructGenericSignatureAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name)) != null) {
            signature = GenericMain.parseFieldSignature(signatureAttr.getSignature());
        }
        return new StructField(accessFlags, attributes, values[0], values[1], signature, version);
    }

    protected StructField(int accessFlags, Map<String, StructGeneralAttribute> attributes, String name, String descriptor, BytecodeVersion version) {
        this(accessFlags, attributes, name, descriptor, null, version);
    }

    protected StructField(int accessFlags, Map<String, StructGeneralAttribute> attributes, String name, String descriptor, GenericFieldDescriptor signature, BytecodeVersion version) {
        super(accessFlags, attributes);
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.version = version;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.name;
    }

    public GenericFieldDescriptor getSignature() {
        return this.signature;
    }

    @Override
    protected BytecodeVersion getVersion() {
        return this.version;
    }
}

