/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.renamer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.modules.renamer.ClassWrapperNode;
import org.jetbrains.java.decompiler.modules.renamer.ConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.NewClassNameBuilder;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class IdentifierConverter
implements NewClassNameBuilder {
    private final StructContext context;
    private final IIdentifierRenamer helper;
    private final PoolInterceptor interceptor;
    private List<ClassWrapperNode> rootClasses = new ArrayList<ClassWrapperNode>();
    private List<ClassWrapperNode> rootInterfaces = new ArrayList<ClassWrapperNode>();
    private Map<String, Map<String, String>> interfaceNameMaps = new HashMap<String, Map<String, String>>();

    public IdentifierConverter(StructContext context, IIdentifierRenamer helper, PoolInterceptor interceptor) {
        this.context = context;
        this.helper = helper;
        this.interceptor = interceptor;
    }

    public void rename() {
        try {
            this.buildInheritanceTree();
            this.renameAllClasses();
            this.renameInterfaces();
            this.renameClasses();
            this.context.reloadContext();
        }
        catch (IOException ex) {
            throw new RuntimeException("Renaming failed!");
        }
    }

    private void renameClasses() {
        List<ClassWrapperNode> lstClasses = IdentifierConverter.getReversePostOrderListIterative(this.rootClasses);
        HashMap<String, HashMap<String, String>> classNameMaps = new HashMap<String, HashMap<String, String>>();
        for (ClassWrapperNode node : lstClasses) {
            Map mapClass;
            StructClass cl = node.getClassStruct();
            HashMap<String, String> names = new HashMap<String, String>();
            if (cl.superClass != null && (mapClass = (Map)classNameMaps.get(cl.superClass.getString())) != null) {
                names.putAll(mapClass);
            }
            for (String ifName : cl.getInterfaceNames()) {
                Map<String, String> mapInt = this.interfaceNameMaps.get(ifName);
                if (mapInt != null) {
                    names.putAll(mapInt);
                    continue;
                }
                StructClass clintr = this.context.getClass(ifName);
                if (clintr == null) continue;
                names.putAll(this.processExternalInterface(clintr));
            }
            this.renameClassIdentifiers(cl, names);
            if (node.getSubclasses().isEmpty()) continue;
            classNameMaps.put(cl.qualifiedName, names);
        }
    }

    private Map<String, String> processExternalInterface(StructClass cl) {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String ifName : cl.getInterfaceNames()) {
            Map<String, String> mapInt = this.interfaceNameMaps.get(ifName);
            if (mapInt != null) {
                names.putAll(mapInt);
                continue;
            }
            StructClass clintr = this.context.getClass(ifName);
            if (clintr == null) continue;
            names.putAll(this.processExternalInterface(clintr));
        }
        this.renameClassIdentifiers(cl, names);
        return names;
    }

    private void renameInterfaces() {
        List<ClassWrapperNode> lstInterfaces = IdentifierConverter.getReversePostOrderListIterative(this.rootInterfaces);
        HashMap<String, Map<String, String>> interfaceNameMaps = new HashMap<String, Map<String, String>>();
        for (ClassWrapperNode node : lstInterfaces) {
            StructClass cl = node.getClassStruct();
            HashMap<String, String> names = new HashMap<String, String>();
            for (String ifName : cl.getInterfaceNames()) {
                Map mapInt = (Map)interfaceNameMaps.get(ifName);
                if (mapInt == null) continue;
                names.putAll(mapInt);
            }
            this.renameClassIdentifiers(cl, names);
            interfaceNameMaps.put(cl.qualifiedName, names);
        }
        this.interfaceNameMaps = interfaceNameMaps;
    }

    private void renameAllClasses() {
        ArrayList<ClassWrapperNode> lstAllClasses = new ArrayList<ClassWrapperNode>(IdentifierConverter.getReversePostOrderListIterative(this.rootInterfaces));
        lstAllClasses.addAll(IdentifierConverter.getReversePostOrderListIterative(this.rootClasses));
        for (ClassWrapperNode node : lstAllClasses) {
            this.renameClass(node.getClassStruct());
        }
    }

    private void renameClass(StructClass cl) {
        if (!cl.isOwn()) {
            return;
        }
        String classOldFullName = cl.qualifiedName;
        String clSimpleName = ConverterHelper.getSimpleClassName(classOldFullName);
        if (this.helper.toBeRenamed(IIdentifierRenamer.Type.ELEMENT_CLASS, clSimpleName, null, null)) {
            String classname;
            String classNewFullName;
            while (this.context.hasClass(classNewFullName = ConverterHelper.replaceSimpleClassName(classOldFullName, classname = this.helper.getNextClassName(classOldFullName, ConverterHelper.getSimpleClassName(classOldFullName))))) {
            }
            this.interceptor.addName(classOldFullName, classNewFullName);
        }
    }

    private void renameClassIdentifiers(StructClass cl, Map<String, String> names) {
        String classOldFullName = cl.qualifiedName;
        String classNewFullName = this.interceptor.getName(classOldFullName);
        if (classNewFullName == null) {
            classNewFullName = classOldFullName;
        }
        HashSet<String> setMethodNames = new HashSet<String>();
        for (StructMethod md : cl.getMethods()) {
            setMethodNames.add(md.getName());
        }
        VBStyleCollection<StructMethod, String> methods = cl.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            StructMethod mt = (StructMethod)methods.get(i);
            String key = methods.getKey(i);
            boolean isPrivate = mt.hasModifier(2);
            String name = mt.getName();
            if (!cl.isOwn() || mt.hasModifier(256)) {
                if (isPrivate) continue;
                names.put(key, name);
                continue;
            }
            if (!this.helper.toBeRenamed(IIdentifierRenamer.Type.ELEMENT_METHOD, classOldFullName, name, mt.getDescriptor())) continue;
            if (isPrivate || !names.containsKey(key)) {
                while (setMethodNames.contains(name = this.helper.getNextMethodName(classOldFullName, name, mt.getDescriptor()))) {
                }
                if (!isPrivate) {
                    names.put(key, name);
                }
            } else {
                name = names.get(key);
            }
            this.interceptor.addName(classOldFullName + " " + mt.getName() + " " + mt.getDescriptor(), classNewFullName + " " + name + " " + this.buildNewDescriptor(false, mt.getDescriptor()));
        }
        if (!cl.isOwn()) {
            return;
        }
        HashSet<String> setFieldNames = new HashSet<String>();
        for (StructField fd : cl.getFields()) {
            setFieldNames.add(fd.getName());
        }
        for (StructField fd : cl.getFields()) {
            String newName;
            if (!this.helper.toBeRenamed(IIdentifierRenamer.Type.ELEMENT_FIELD, classOldFullName, fd.getName(), fd.getDescriptor())) continue;
            while (setFieldNames.contains(newName = this.helper.getNextFieldName(classOldFullName, fd.getName(), fd.getDescriptor()))) {
            }
            this.interceptor.addName(classOldFullName + " " + fd.getName() + " " + fd.getDescriptor(), classNewFullName + " " + newName + " " + this.buildNewDescriptor(true, fd.getDescriptor()));
        }
    }

    @Override
    public String buildNewClassname(String className) {
        return this.interceptor.getName(className);
    }

    private String buildNewDescriptor(boolean isField, String descriptor) {
        String newDescriptor = isField ? FieldDescriptor.parseDescriptor(descriptor).buildNewDescriptor(this) : MethodDescriptor.parseDescriptor(descriptor).buildNewDescriptor(this);
        return newDescriptor != null ? newDescriptor : descriptor;
    }

    private static List<ClassWrapperNode> getReversePostOrderListIterative(List<ClassWrapperNode> roots) {
        ArrayList<ClassWrapperNode> res = new ArrayList<ClassWrapperNode>();
        LinkedList<ClassWrapperNode> stackNode = new LinkedList<ClassWrapperNode>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<ClassWrapperNode> setVisited = new HashSet<ClassWrapperNode>();
        for (ClassWrapperNode root : roots) {
            stackNode.add(root);
            stackIndex.add(0);
        }
        while (!stackNode.isEmpty()) {
            int index;
            ClassWrapperNode node = (ClassWrapperNode)stackNode.getLast();
            setVisited.add(node);
            List<ClassWrapperNode> lstSubs = node.getSubclasses();
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstSubs.size(); ++index) {
                ClassWrapperNode sub = lstSubs.get(index);
                if (setVisited.contains(sub)) continue;
                stackIndex.add(index + 1);
                stackNode.add(sub);
                stackIndex.add(0);
                break;
            }
            if (index != lstSubs.size()) continue;
            res.add(0, node);
            stackNode.removeLast();
        }
        return res;
    }

    private void buildInheritanceTree() {
        HashMap<String, ClassWrapperNode> nodes = new HashMap<String, ClassWrapperNode>();
        Map<String, StructClass> classes = this.context.getOwnClasses();
        ArrayList<ClassWrapperNode> rootClasses = new ArrayList<ClassWrapperNode>();
        ArrayList<ClassWrapperNode> rootInterfaces = new ArrayList<ClassWrapperNode>();
        block0: for (StructClass cl : classes.values()) {
            LinkedList<StructClass> stack = new LinkedList<StructClass>();
            LinkedList<ClassWrapperNode> stackSubNodes = new LinkedList<ClassWrapperNode>();
            stack.add(cl);
            stackSubNodes.add(null);
            while (!stack.isEmpty()) {
                StructClass clParent;
                boolean isNewNode;
                StructClass clStr = (StructClass)stack.removeFirst();
                ClassWrapperNode child = (ClassWrapperNode)stackSubNodes.removeFirst();
                ClassWrapperNode node = (ClassWrapperNode)nodes.get(clStr.qualifiedName);
                boolean bl = isNewNode = node == null;
                if (isNewNode) {
                    node = new ClassWrapperNode(clStr);
                    nodes.put(clStr.qualifiedName, node);
                }
                if (child != null) {
                    node.addSubclass(child);
                }
                if (!isNewNode) continue block0;
                boolean isInterface = clStr.hasModifier(512);
                boolean found_parent = false;
                if (isInterface) {
                    for (String ifName : clStr.getInterfaceNames()) {
                        StructClass clParent2 = classes.get(ifName);
                        if (clParent2 == null) continue;
                        stack.add(clParent2);
                        stackSubNodes.add(node);
                        found_parent = true;
                    }
                } else if (clStr.superClass != null && (clParent = classes.get(clStr.superClass.getString())) != null) {
                    stack.add(clParent);
                    stackSubNodes.add(node);
                    found_parent = true;
                }
                if (found_parent) continue;
                (isInterface ? rootInterfaces : rootClasses).add(node);
            }
        }
        this.rootClasses = rootClasses;
        this.rootInterfaces = rootInterfaces;
    }
}

