/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class SequenceStatement
extends Statement {
    private SequenceStatement() {
        this.type = 15;
    }

    public SequenceStatement(Statement ... stats) {
        this(Arrays.asList(stats));
    }

    public SequenceStatement(List<? extends Statement> lst) {
        this();
        this.lastBasicType = lst.get(lst.size() - 1).getLastBasicType();
        for (Statement statement : lst) {
            this.stats.addWithKey(statement, statement.id);
        }
        this.first = (Statement)this.stats.get(0);
    }

    private SequenceStatement(Statement head, Statement tail) {
        this(Arrays.asList(head, tail));
        StatEdge edge;
        List<StatEdge> lstSuccs = tail.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty() && (edge = lstSuccs.get(0)).getType() == 1 && edge.getDestination() != head) {
            this.post = edge.getDestination();
        }
    }

    public static Statement isHead2Block(Statement head) {
        Statement stat;
        if (head.getLastBasicType() != 2) {
            return null;
        }
        StatEdge edge = null;
        List<StatEdge> lstSuccs = head.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty()) {
            edge = lstSuccs.get(0);
        }
        if (edge != null && edge.getType() == 1 && (stat = edge.getDestination()) != head && stat.getPredecessorEdges(1).size() == 1 && !stat.isMonitorEnter() && stat.getLastBasicType() == 2 && DecHelper.checkStatementExceptions(Arrays.asList(head, stat))) {
            return new SequenceStatement(head, stat);
        }
        return null;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        boolean islabeled = this.isLabeled();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent));
        if (islabeled) {
            buf.appendIndent(indent++).append("label").append(this.id.toString()).append(": {").appendLineSeparator();
        }
        boolean notempty = false;
        for (int i = 0; i < this.stats.size(); ++i) {
            Statement st = (Statement)this.stats.get(i);
            if (i > 0 && notempty) {
                buf.appendLineSeparator();
            }
            TextBuffer str = ExprProcessor.jmpWrapper(st, indent, false);
            buf.append(str);
            notempty = !str.containsOnlyWhitespaces();
        }
        if (islabeled) {
            buf.appendIndent(indent - 1).append("}").appendLineSeparator();
        }
        return buf;
    }

    @Override
    public Statement getSimpleCopy() {
        return new SequenceStatement();
    }
}

