/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class RootStatement
extends Statement {
    private final DummyExitStatement dummyExit;
    public final StructMethod mt;
    public Set<String> commentLines = null;
    public boolean addErrorComment = false;

    public RootStatement(Statement head, DummyExitStatement dummyExit, StructMethod mt) {
        this.type = 13;
        this.first = head;
        this.dummyExit = dummyExit;
        this.mt = mt;
        if (this.first == null) {
            throw new IllegalStateException("Root statement has no content!");
        }
        this.stats.addWithKey(this.first, this.first.id);
        this.first.setParent(this);
    }

    @Override
    public TextBuffer toJava(int indent) {
        return ExprProcessor.listToJava(this.varDefinitions, indent).append(this.first.toJava(indent));
    }

    public DummyExitStatement getDummyExit() {
        return this.dummyExit;
    }

    public void addComment(String comment) {
        if (this.commentLines == null) {
            this.commentLines = new LinkedHashSet<String>();
        }
        this.commentLines.add(comment);
    }

    public void addComments(RootStatement root) {
        if (root.commentLines != null) {
            for (String s : root.commentLines) {
                this.addComment(s);
            }
        }
        this.addErrorComment |= root.addErrorComment;
    }

    public void addComments(ControlFlowGraph graph) {
        if (graph.commentLines != null) {
            for (String s : graph.commentLines) {
                this.addComment(s);
            }
        }
        this.addErrorComment |= graph.addErrorComment;
    }

    @Override
    public StartEndPair getStartEndRange() {
        return StartEndPair.join(this.first.getStartEndRange(), this.dummyExit != null ? this.dummyExit.getStartEndRange() : null);
    }
}

