/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class BasicBlockStatement
extends Statement {
    private final BasicBlock block;

    public BasicBlockStatement(BasicBlock block) {
        Instruction instr;
        this.type = 8;
        this.block = block;
        this.id = block.id;
        CounterContainer coun = DecompilerContext.getCounterContainer();
        if (this.id >= coun.getCounter(0)) {
            coun.setCounter(0, this.id + 1);
        }
        if ((instr = block.getLastInstruction()) != null) {
            if (instr.group == 2 && instr.opcode != 167) {
                this.lastBasicType = 0;
            } else if (instr.group == 3) {
                this.lastBasicType = 1;
            }
        }
        this.buildMonitorFlags();
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer tb = ExprProcessor.listToJava(this.varDefinitions, indent);
        tb.append(ExprProcessor.listToJava(this.exprents, indent));
        return tb;
    }

    @Override
    public Statement getSimpleCopy() {
        BasicBlock newblock = new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0));
        SimpleInstructionSequence seq = new SimpleInstructionSequence();
        for (int i = 0; i < this.block.getSeq().length(); ++i) {
            seq.addInstruction(this.block.getSeq().getInstr(i).clone(), -1);
        }
        newblock.setSeq(seq);
        return new BasicBlockStatement(newblock);
    }

    @Override
    public List<VarExprent> getImplicitlyDefinedVars() {
        if (this.getExprents() != null && this.getExprents().size() > 0) {
            ArrayList<VarExprent> vars = new ArrayList<VarExprent>();
            List<Exprent> exps = this.getExprents();
            for (Exprent exp : exps) {
                List<Exprent> inner = exp.getAllExprents(true);
                inner.add(exp);
                for (Exprent exprent : inner) {
                    if (exprent.type != 6 || ((FunctionExprent)exprent).getFuncType() != 30 || ((FunctionExprent)exprent).getLstOperands().size() <= 2) continue;
                    vars.add((VarExprent)((FunctionExprent)exprent).getLstOperands().get(2));
                }
            }
            return vars;
        }
        return null;
    }

    public static BasicBlockStatement create() {
        BasicBlockStatement stat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        stat.setExprents(new ArrayList<Exprent>());
        return stat;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        for (int i = 0; i < this.exprents.size(); ++i) {
            if (this.exprents.get(i) != oldexpr) continue;
            this.exprents.set(i, newexpr);
        }
    }

    @Override
    public StartEndPair getStartEndRange() {
        if (this.block.size() > 0) {
            return new StartEndPair(this.block.getStartInstruction(), this.block.getEndInstruction());
        }
        return new StartEndPair(0, 0);
    }
}

