/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class YieldExprent
extends Exprent {
    private Exprent content;
    private final VarType retType;

    public YieldExprent(Exprent content, VarType retType) {
        super(15);
        this.content = content;
        this.retType = retType;
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        list.add(this.content);
        return list;
    }

    @Override
    public Exprent copy() {
        return new YieldExprent(this.content.copy(), this.retType);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.retType.type != 10) {
            result.addMinTypeExprent(this.content, VarType.getMinTypeInFamily(this.retType.typeFamily));
            result.addMaxTypeExprent(this.content, this.retType);
        }
        return result;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.append("yield ");
        ExprProcessor.getCastedExprent(this.content, this.retType, buf, indent, ExprProcessor.NullCastType.DONT_CAST_AT_ALL, false, false, false);
        return buf;
    }

    public Exprent getContent() {
        return this.content;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.content) {
            this.content = newExpr;
        }
    }

    @Override
    public VarType getExprType() {
        return this.retType;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        YieldExprent.measureBytecode(values, this.content);
        this.measureBytecode(values);
    }
}

