/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.IntHelper;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class FunctionExprent
extends Exprent {
    public static final int FUNCTION_ADD = 0;
    public static final int FUNCTION_SUB = 1;
    public static final int FUNCTION_MUL = 2;
    public static final int FUNCTION_DIV = 3;
    public static final int FUNCTION_AND = 4;
    public static final int FUNCTION_OR = 5;
    public static final int FUNCTION_XOR = 6;
    public static final int FUNCTION_REM = 7;
    public static final int FUNCTION_SHL = 8;
    public static final int FUNCTION_SHR = 9;
    public static final int FUNCTION_USHR = 10;
    public static final int FUNCTION_BIT_NOT = 11;
    public static final int FUNCTION_BOOL_NOT = 12;
    public static final int FUNCTION_NEG = 13;
    public static final int FUNCTION_I2L = 14;
    public static final int FUNCTION_I2F = 15;
    public static final int FUNCTION_I2D = 16;
    public static final int FUNCTION_L2I = 17;
    public static final int FUNCTION_L2F = 18;
    public static final int FUNCTION_L2D = 19;
    public static final int FUNCTION_F2I = 20;
    public static final int FUNCTION_F2L = 21;
    public static final int FUNCTION_F2D = 22;
    public static final int FUNCTION_D2I = 23;
    public static final int FUNCTION_D2L = 24;
    public static final int FUNCTION_D2F = 25;
    public static final int FUNCTION_I2B = 26;
    public static final int FUNCTION_I2C = 27;
    public static final int FUNCTION_I2S = 28;
    public static final int FUNCTION_CAST = 29;
    public static final int FUNCTION_INSTANCEOF = 30;
    public static final int FUNCTION_ARRAY_LENGTH = 31;
    public static final int FUNCTION_IMM = 32;
    public static final int FUNCTION_MMI = 33;
    public static final int FUNCTION_IPP = 34;
    public static final int FUNCTION_PPI = 35;
    public static final int FUNCTION_IIF = 36;
    public static final int FUNCTION_LCMP = 37;
    public static final int FUNCTION_FCMPL = 38;
    public static final int FUNCTION_FCMPG = 39;
    public static final int FUNCTION_DCMPL = 40;
    public static final int FUNCTION_DCMPG = 41;
    public static final int FUNCTION_EQ = 42;
    public static final int FUNCTION_NE = 43;
    public static final int FUNCTION_LT = 44;
    public static final int FUNCTION_GE = 45;
    public static final int FUNCTION_GT = 46;
    public static final int FUNCTION_LE = 47;
    public static final int FUNCTION_CADD = 48;
    public static final int FUNCTION_COR = 49;
    public static final int FUNCTION_STR_CONCAT = 50;
    private static final VarType[] TYPES = new VarType[]{VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_INT, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_BYTE, VarType.VARTYPE_CHAR, VarType.VARTYPE_SHORT};
    private static final String[] OPERATORS = new String[]{"+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "==", "!=", "<", ">=", ">", "<=", "&&", "||", "+"};
    private static final int[] PRECEDENCE = new int[]{3, 3, 2, 2, 7, 9, 8, 2, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 0, 1, 1, 1, 1, 12, -1, -1, -1, -1, -1, 6, 6, 5, 5, 5, 5, 10, 11, 3};
    private static final Set<Integer> ASSOCIATIVITY = new HashSet<Integer>(Arrays.asList(0, 2, 4, 5, 6, 48, 49, 50));
    private int funcType;
    private VarType implicitType;
    private final List<Exprent> lstOperands;
    private boolean needsCast = true;
    private boolean disableNewlineGroupCreation = false;

    public FunctionExprent(int funcType, ListStack<Exprent> stack, BitSet bytecodeOffsets) {
        this(funcType, new ArrayList<Exprent>(), bytecodeOffsets);
        if (funcType >= 11 && funcType <= 35 && funcType != 29 && funcType != 30) {
            this.lstOperands.add(stack.pop());
        } else {
            if (funcType == 36) {
                throw new RuntimeException("no direct instantiation possible");
            }
            Exprent expr = stack.pop();
            this.lstOperands.add(stack.pop());
            this.lstOperands.add(expr);
        }
    }

    public FunctionExprent(int funcType, List<Exprent> operands, BitSet bytecodeOffsets) {
        super(6);
        this.funcType = funcType;
        this.lstOperands = operands;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    public FunctionExprent(int funcType, Exprent operand, BitSet bytecodeOffsets) {
        this(funcType, new ArrayList<Exprent>(1), bytecodeOffsets);
        this.lstOperands.add(operand);
    }

    @Override
    public VarType getExprType() {
        VarType exprType = null;
        if (this.funcType <= 13 || this.funcType == 34 || this.funcType == 35 || this.funcType == 32 || this.funcType == 33) {
            VarType type1 = this.lstOperands.get(0).getExprType();
            VarType type2 = null;
            if (this.lstOperands.size() > 1) {
                type2 = this.lstOperands.get(1).getExprType();
            }
            switch (this.funcType) {
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    exprType = this.implicitType;
                    break;
                }
                case 12: {
                    exprType = VarType.VARTYPE_BOOLEAN;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    exprType = FunctionExprent.getMaxVarType(new VarType[]{type1});
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    exprType = FunctionExprent.getMaxVarType(new VarType[]{type1, type2});
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    exprType = type1.type == 7 & type2.type == 7 ? VarType.VARTYPE_BOOLEAN : FunctionExprent.getMaxVarType(new VarType[]{type1, type2});
                }
            }
        } else if (this.funcType == 29) {
            exprType = this.lstOperands.get(1).getExprType();
        } else if (this.funcType == 36) {
            Exprent param1 = this.lstOperands.get(1);
            Exprent param2 = this.lstOperands.get(2);
            VarType supertype = VarType.getCommonSupertype(param1.getExprType(), param2.getExprType());
            exprType = param1.type == 3 && param2.type == 3 && supertype.type != 7 && VarType.VARTYPE_INT.isSuperset(supertype) ? VarType.VARTYPE_INT : supertype;
        } else {
            exprType = this.funcType == 50 ? VarType.VARTYPE_STRING : (this.funcType >= 42 || this.funcType == 30 ? VarType.VARTYPE_BOOLEAN : (this.funcType >= 31 ? VarType.VARTYPE_INT : TYPES[this.funcType - 14]));
        }
        return exprType;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.funcType == 29) {
            this.needsCast = true;
            VarType right = this.lstOperands.get(0).getInferredExprType(upperBound);
            VarType cast = this.lstOperands.get(1).getExprType();
            if (upperBound != null && (upperBound.isGeneric() || right.isGeneric())) {
                List<VarType> types;
                Map<VarType, List<VarType>> names = this.getNamedGenerics();
                int arrayDim = 0;
                if (upperBound.arrayDim == right.arrayDim && upperBound.arrayDim > 0) {
                    arrayDim = upperBound.arrayDim;
                    upperBound = upperBound.resizeArrayDim(0);
                    right = right.resizeArrayDim(0);
                }
                if ((types = names.get(right)) == null) {
                    types = names.get(upperBound);
                }
                if (types != null) {
                    boolean anyMatch = false;
                    for (VarType type : types) {
                        anyMatch |= DecompilerContext.getStructContext().instanceOf(type.value, cast.value);
                    }
                    if (anyMatch) {
                        this.needsCast = false;
                    }
                } else {
                    boolean bl = this.needsCast = right.type == 13 || !DecompilerContext.getStructContext().instanceOf(right.value, upperBound.value) || !FunctionExprent.areGenericTypesSame(right, upperBound);
                }
                if (!this.needsCast) {
                    if (arrayDim > 0) {
                        right = right.resizeArrayDim(arrayDim);
                    }
                    return right;
                }
            } else {
                this.needsCast = right.type == 13 || !DecompilerContext.getStructContext().instanceOf(right.value, cast.value);
            }
        } else if (this.funcType == 36) {
            VarType type1 = this.lstOperands.get(1).getInferredExprType(upperBound);
            VarType type2 = this.lstOperands.get(2).getInferredExprType(upperBound);
            if (type1.type == 13) {
                return type2;
            }
            if (type2.type == 13) {
                return type1;
            }
        }
        return this.getExprType();
    }

    private static boolean areGenericTypesSame(VarType right, VarType upperBound) {
        if (!(right instanceof GenericType) || !(upperBound instanceof GenericType)) {
            return true;
        }
        GenericType rightGeneric = (GenericType)right;
        GenericType upperBoundGeneric = (GenericType)upperBound;
        if (rightGeneric.getArguments().size() != upperBoundGeneric.getArguments().size()) {
            return false;
        }
        for (int i = 0; i < upperBoundGeneric.getArguments().size(); ++i) {
            VarType upperType = upperBoundGeneric.getArguments().get(i);
            VarType rightType = rightGeneric.getArguments().get(i);
            if (upperType == null || rightType != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getExprentUse() {
        if (this.funcType >= 32 && this.funcType <= 35) {
            return 0;
        }
        int ret = 3;
        for (Exprent expr : this.lstOperands) {
            ret &= expr.getExprentUse();
        }
        return ret;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        Exprent param1 = this.lstOperands.get(0);
        VarType type1 = param1.getExprType();
        Exprent param2 = null;
        VarType type2 = null;
        if (this.lstOperands.size() > 1) {
            param2 = this.lstOperands.get(1);
            type2 = param2.getExprType();
        }
        switch (this.funcType) {
            case 36: {
                VarType supertype = this.getExprType();
                result.addMinTypeExprent(param1, VarType.VARTYPE_BOOLEAN);
                result.addMinTypeExprent(param2, VarType.getMinTypeInFamily(supertype.typeFamily));
                result.addMinTypeExprent(this.lstOperands.get(2), VarType.getMinTypeInFamily(supertype.typeFamily));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 26: 
            case 27: 
            case 28: {
                result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(param1, VarType.VARTYPE_INT);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                result.addMinTypeExprent(param1, this.implicitType);
                result.addMaxTypeExprent(param1, this.implicitType);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
            }
            case 11: 
            case 13: {
                result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 42: 
            case 43: {
                if (type1.type == 7) {
                    boolean param2_false_boolean;
                    if (type2.isStrictSuperset(type1)) {
                        result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                        break;
                    }
                    boolean param1_false_boolean = type1.isFalseBoolean() || param1.type == 3 && !((ConstExprent)param1).hasBooleanValue();
                    boolean bl = param2_false_boolean = type1.isFalseBoolean() || param2.type == 3 && !((ConstExprent)param2).hasBooleanValue();
                    if (!param1_false_boolean && !param2_false_boolean) break;
                    result.addMinTypeExprent(param1, VarType.VARTYPE_BYTECHAR);
                    result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
                    break;
                }
                if (type2.type != 7 || !type1.isStrictSuperset(type2)) break;
                result.addMinTypeExprent(param2, VarType.VARTYPE_BYTECHAR);
            }
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.addAll(this.lstOperands);
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstOperands) {
            lst.add(expr.copy());
        }
        FunctionExprent func = new FunctionExprent(this.funcType, lst, this.bytecode);
        func.setImplicitType(this.implicitType);
        return func;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionExprent)) {
            return false;
        }
        FunctionExprent fe = (FunctionExprent)o;
        return this.funcType == fe.getFuncType() && InterpreterUtil.equalLists(this.lstOperands, fe.getLstOperands());
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        for (int i = 0; i < this.lstOperands.size(); ++i) {
            if (oldExpr != this.lstOperands.get(i)) continue;
            this.lstOperands.set(i, newExpr);
        }
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.addBytecodeMapping(this.bytecode);
        if (this.funcType <= 10) {
            Exprent left = this.lstOperands.get(0);
            Exprent right = this.lstOperands.get(1);
            if (this.funcType <= 6) {
                if (right.type == 3) {
                    ((ConstExprent)right).adjustConstType(left.getExprType());
                } else if (left.type == 3) {
                    ((ConstExprent)left).adjustConstType(right.getExprType());
                }
            }
            TextBuffer leftOperand = this.wrapOperandString(left, false, indent, true);
            TextBuffer rightOperand = this.wrapOperandString(right, true, indent, true);
            if (this.funcType == 4 || this.funcType == 5) {
                Integer value;
                if (right.type == 3 && right.getExprType() == VarType.VARTYPE_INT) {
                    value = (Integer)((ConstExprent)right).getValue();
                    rightOperand.setLength(0);
                    rightOperand.append(IntHelper.adjustedIntRepresentation(value));
                }
                if (left.type == 3 && left.getExprType() == VarType.VARTYPE_INT) {
                    value = (Integer)((ConstExprent)left).getValue();
                    leftOperand.setLength(0);
                    leftOperand.append(IntHelper.adjustedIntRepresentation(value));
                }
            }
            if (!this.disableNewlineGroupCreation) {
                buf.pushNewlineGroup(indent, 1);
            }
            buf.append(leftOperand).appendPossibleNewline(" ").append(OPERATORS[this.funcType]).append(" ").append(rightOperand);
            if (!this.disableNewlineGroupCreation) {
                buf.popNewlineGroup();
            }
            return buf;
        }
        if (this.funcType >= 42) {
            Exprent left = this.lstOperands.get(0);
            Exprent right = this.lstOperands.get(1);
            if (this.funcType <= 47) {
                if (right.type == 3) {
                    ((ConstExprent)right).adjustConstType(left.getExprType());
                } else if (left.type == 3) {
                    ((ConstExprent)left).adjustConstType(right.getExprType());
                }
            }
            if (!this.disableNewlineGroupCreation) {
                buf.pushNewlineGroup(indent, 1);
            }
            buf.append(this.wrapOperandString(left, false, indent, true)).appendPossibleNewline(" ").append(OPERATORS[this.funcType - 42 + 11]).append(" ").append(this.wrapOperandString(right, true, indent, true));
            if (!this.disableNewlineGroupCreation) {
                buf.popNewlineGroup();
            }
            return buf;
        }
        switch (this.funcType) {
            case 11: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("~"));
            }
            case 12: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("!"));
            }
            case 13: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("-"));
            }
            case 29: {
                if (!this.needsCast) {
                    return buf.append(this.lstOperands.get(0).toJava(indent));
                }
                return buf.append(this.lstOperands.get(1).toJava(indent)).enclose("(", ")").append(this.wrapOperandString(this.lstOperands.get(0), true, indent));
            }
            case 31: {
                Exprent arr = this.lstOperands.get(0);
                buf.append(this.wrapOperandString(arr, false, indent));
                if (arr.getExprType().arrayDim == 0) {
                    VarType objArr = VarType.VARTYPE_OBJECT.resizeArrayDim(1);
                    buf.enclose("((" + ExprProcessor.getCastTypeName(objArr) + ")", ")");
                }
                return buf.append(".length");
            }
            case 36: {
                buf.pushNewlineGroup(indent, 1);
                buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent)).appendPossibleNewline(" ").append("? ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).appendPossibleNewline(" ").append(": ").append(this.wrapOperandString(this.lstOperands.get(2), true, indent));
                buf.popNewlineGroup();
                return buf;
            }
            case 34: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).append("++"));
            }
            case 35: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("++"));
            }
            case 32: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).append("--"));
            }
            case 33: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("--"));
            }
            case 30: {
                buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent)).append(" instanceof ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent));
                if (this.lstOperands.size() > 2) {
                    buf.append(" ");
                    ((VarExprent)this.lstOperands.get(2)).setDefinition(false);
                    buf.append(this.wrapOperandString(this.lstOperands.get(2), true, indent));
                }
                return buf;
            }
            case 37: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("__lcmp__(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
            case 38: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("__fcmpl__(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
            case 39: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("__fcmpg__(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
            case 40: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("__dcmpl__(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
            case 41: {
                return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent).prepend("__dcmpg__(")).append(", ").append(this.wrapOperandString(this.lstOperands.get(1), true, indent)).append(")");
            }
        }
        if (this.funcType <= 28) {
            InvocationExprent inv;
            if (this.lstOperands.get((int)0).type == 8 && (inv = (InvocationExprent)this.lstOperands.get(0)).isUnboxingCall()) {
                inv.forceUnboxing(true);
            }
            return buf.append(this.wrapOperandString(this.lstOperands.get(0), true, indent)).prepend("(" + ExprProcessor.getTypeName(TYPES[this.funcType - 14]) + ")");
        }
        throw new RuntimeException("invalid function");
    }

    private Exprent unwrapBoxing(Exprent expr) {
        if (expr.type == 8 && ((InvocationExprent)expr).isUnboxingCall()) {
            Exprent inner = ((InvocationExprent)expr).getInstance();
            if (inner.type == 6 && ((FunctionExprent)inner).funcType == 29) {
                inner.addBytecodeOffsets(expr.bytecode);
                expr = inner;
            }
        }
        return expr;
    }

    public void unwrapBox() {
        for (int i = 0; i < this.lstOperands.size(); ++i) {
            this.lstOperands.set(i, this.unwrapBoxing(this.lstOperands.get(i)));
        }
    }

    @Override
    public int getPrecedence() {
        if (this.funcType == 29 && !this.doesCast()) {
            return this.lstOperands.get(0).getPrecedence();
        }
        return FunctionExprent.getPrecedence(this.funcType);
    }

    public static int getPrecedence(int func) {
        return PRECEDENCE[func];
    }

    public VarType getSimpleCastType() {
        return TYPES[this.funcType - 14];
    }

    private TextBuffer wrapOperandString(Exprent expr, boolean eq, int indent) {
        return this.wrapOperandString(expr, eq, indent, false);
    }

    private TextBuffer wrapOperandString(Exprent expr, boolean eq, int indent, boolean newlineGroup) {
        boolean parentheses;
        int myprec = this.getPrecedence();
        int exprprec = expr.getPrecedence();
        boolean bl = parentheses = exprprec > myprec;
        if (!parentheses && eq) {
            boolean bl2 = parentheses = exprprec == myprec;
            if (parentheses && expr.type == 6 && ((FunctionExprent)expr).getFuncType() == this.funcType) {
                boolean bl3 = parentheses = !ASSOCIATIVITY.contains(this.funcType);
            }
        }
        if (newlineGroup && !parentheses && myprec == exprprec && expr.type == 6) {
            FunctionExprent funcExpr = (FunctionExprent)expr;
            if (funcExpr.getFuncType() == 29 && !funcExpr.doesCast()) {
                Exprent subExpr = funcExpr.getLstOperands().get(0);
                if (subExpr.type == 6) {
                    funcExpr = (FunctionExprent)subExpr;
                }
            }
            funcExpr.disableNewlineGroupCreation = true;
        }
        TextBuffer res = expr.toJava(indent);
        if (parentheses) {
            TextBuffer oldRes = res;
            res = new TextBuffer().append("(");
            res.pushNewlineGroup(indent, 1);
            res.appendPossibleNewline();
            res.append(oldRes);
            res.appendPossibleNewline("", true);
            res.popNewlineGroup();
            res.append(")");
        }
        return res;
    }

    private static VarType getMaxVarType(VarType[] arr) {
        int[] types = new int[]{2, 3, 5};
        VarType[] vartypes = new VarType[]{VarType.VARTYPE_DOUBLE, VarType.VARTYPE_FLOAT, VarType.VARTYPE_LONG};
        for (int i = 0; i < types.length; ++i) {
            for (VarType anArr : arr) {
                if (anArr.type != types[i]) continue;
                return vartypes[i];
            }
        }
        return VarType.VARTYPE_INT;
    }

    public int getFuncType() {
        return this.funcType;
    }

    public void setFuncType(int funcType) {
        this.funcType = funcType;
    }

    public List<Exprent> getLstOperands() {
        return this.lstOperands;
    }

    public void setImplicitType(VarType implicitType) {
        this.implicitType = implicitType;
    }

    public boolean doesCast() {
        return this.needsCast;
    }

    public void setNeedsCast(boolean needsCast) {
        this.needsCast = needsCast;
    }

    @Override
    public void setInvocationInstance() {
        if (this.funcType == 29) {
            this.lstOperands.get(0).setInvocationInstance();
        }
    }

    @Override
    public void setIsQualifier() {
        if (this.funcType == 29 && !this.doesCast()) {
            this.lstOperands.get(0).setIsQualifier();
        }
    }

    @Override
    public boolean allowNewlineAfterQualifier() {
        if (this.funcType == 29 && !this.doesCast()) {
            return this.lstOperands.get(0).allowNewlineAfterQualifier();
        }
        return super.allowNewlineAfterQualifier();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        FunctionExprent.measureBytecode(values, this.lstOperands);
        this.measureBytecode(values);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        Integer type = (Integer)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_FUNCTYPE);
        return type == null || this.funcType == type;
    }
}

