/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;

public abstract class Exprent
implements IMatchable {
    public static final int MULTIPLE_USES = 1;
    public static final int SIDE_EFFECTS_FREE = 2;
    public static final int BOTH_FLAGS = 3;
    public static final int EXPRENT_ARRAY = 1;
    public static final int EXPRENT_ASSIGNMENT = 2;
    public static final int EXPRENT_CONST = 3;
    public static final int EXPRENT_EXIT = 4;
    public static final int EXPRENT_FIELD = 5;
    public static final int EXPRENT_FUNCTION = 6;
    public static final int EXPRENT_IF = 7;
    public static final int EXPRENT_INVOCATION = 8;
    public static final int EXPRENT_MONITOR = 9;
    public static final int EXPRENT_NEW = 10;
    public static final int EXPRENT_SWITCH_HEAD = 11;
    public static final int EXPRENT_VAR = 12;
    public static final int EXPRENT_ANNOTATION = 13;
    public static final int EXPRENT_ASSERT = 14;
    public static final int EXPRENT_SWITCH = 15;
    public static final int EXPRENT_YIELD = 15;
    protected static ThreadLocal<Map<String, VarType>> inferredLambdaTypes = ThreadLocal.withInitial(HashMap::new);
    public final int type;
    public final int id;
    public BitSet bytecode = null;

    public Exprent(int type) {
        this.type = type;
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(1);
    }

    public int getPrecedence() {
        return 0;
    }

    public VarType getExprType() {
        return VarType.VARTYPE_VOID;
    }

    public VarType getInferredExprType(VarType upperBound) {
        return this.getExprType();
    }

    public int getExprentUse() {
        return 0;
    }

    public CheckTypesResult checkExprTypeBounds() {
        return null;
    }

    public boolean containsExprent(Exprent exprent) {
        if (this.equals(exprent)) {
            return true;
        }
        List<Exprent> lst = this.getAllExprents();
        for (int i = lst.size() - 1; i >= 0; --i) {
            if (!lst.get(i).containsExprent(exprent)) continue;
            return true;
        }
        return false;
    }

    public final List<Exprent> getAllExprents(boolean recursive) {
        return this.getAllExprents(recursive, false);
    }

    public final List<Exprent> getAllExprents(boolean recursive, boolean self) {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        this.getAllExprents(recursive, lst);
        if (self) {
            lst.add(this);
        }
        return lst;
    }

    private List<Exprent> getAllExprents(boolean recursive, List<Exprent> list) {
        int start = list.size();
        this.getAllExprents(list);
        int end = list.size();
        if (recursive) {
            for (int i = end - 1; i >= start; --i) {
                list.get(i).getAllExprents(true, list);
            }
        }
        return list;
    }

    public Set<VarVersionPair> getAllVariables() {
        List<Exprent> lstAllExprents = this.getAllExprents(true);
        lstAllExprents.add(this);
        HashSet<VarVersionPair> set = new HashSet<VarVersionPair>();
        for (Exprent expr : lstAllExprents) {
            if (expr.type != 12) continue;
            set.add(new VarVersionPair((VarExprent)expr));
        }
        return set;
    }

    public final List<Exprent> getAllExprents() {
        ArrayList<Exprent> list = new ArrayList<Exprent>();
        this.getAllExprents(list);
        return list;
    }

    protected abstract List<Exprent> getAllExprents(List<Exprent> var1);

    public abstract Exprent copy();

    public TextBuffer toJava() {
        return this.toJava(0);
    }

    public abstract TextBuffer toJava(int var1);

    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
    }

    public void addBytecodeOffsets(BitSet bytecodeOffsets) {
        if (bytecodeOffsets != null) {
            if (this.bytecode == null) {
                this.bytecode = new BitSet();
            }
            this.bytecode.or(bytecodeOffsets);
        }
    }

    public abstract void getBytecodeRange(BitSet var1);

    protected void measureBytecode(BitSet values) {
        if (this.bytecode != null && values != null) {
            values.or(this.bytecode);
        }
    }

    protected static void measureBytecode(BitSet values, Exprent exprent) {
        if (exprent != null) {
            exprent.getBytecodeRange(values);
        }
    }

    protected static void measureBytecode(BitSet values, List<? extends Exprent> list) {
        if (list != null && !list.isEmpty()) {
            for (Exprent exprent : list) {
                exprent.getBytecodeRange(values);
            }
        }
    }

    public static List<? extends Exprent> sortIndexed(List<? extends Exprent> lst) {
        ArrayList ret = new ArrayList();
        ArrayList<VarExprent> defs = new ArrayList<VarExprent>();
        Comparator<VarExprent> comp = new Comparator<VarExprent>(){

            @Override
            public int compare(VarExprent o1, VarExprent o2) {
                return o1.getIndex() - o2.getIndex();
            }
        };
        for (Exprent exprent : lst) {
            boolean isDef;
            boolean bl = isDef = exprent instanceof VarExprent && ((VarExprent)exprent).isDefinition();
            if (!isDef) {
                if (defs.size() > 0) {
                    Collections.sort(defs, comp);
                    ret.addAll(defs);
                    defs.clear();
                }
                ret.add(exprent);
                continue;
            }
            defs.add((VarExprent)exprent);
        }
        if (defs.size() > 0) {
            Collections.sort(defs, comp);
            ret.addAll(defs);
        }
        return ret;
    }

    protected void gatherGenerics(VarType upperBound, VarType ret, Map<VarType, VarType> genericsMap) {
        int right;
        int left;
        if (upperBound != null && upperBound.isGeneric() && ret.isGeneric() && upperBound.arrayDim == ret.arrayDim && (left = ((GenericType)upperBound).getArguments().size()) == (right = ((GenericType)ret).getArguments().size())) {
            ((GenericType)ret).mapGenVarsTo((GenericType)upperBound, genericsMap);
        }
    }

    protected void getGenericArgs(List<String> fparams, Map<VarType, VarType> genericsMap, List<VarType> genericArgs) {
        for (String type : fparams) {
            VarType arg = genericsMap.get(GenericType.parse("T" + type + ";"));
            if (arg == null || arg.isGeneric() && ((GenericType)arg).getWildcard() != 4) {
                genericArgs.clear();
                break;
            }
            genericArgs.add(arg);
        }
    }

    protected void appendParameters(TextBuffer buf, List<VarType> genericArgs) {
        if (genericArgs.isEmpty()) {
            return;
        }
        buf.append("<");
        for (int i = 0; i < genericArgs.size(); ++i) {
            buf.append(ExprProcessor.getCastTypeName(genericArgs.get(i)));
            if (i + 1 >= genericArgs.size()) continue;
            buf.append(", ");
        }
        buf.append(">");
    }

    protected Map<VarType, List<VarType>> getNamedGenerics() {
        HashMap<VarType, List<VarType>> ret = new HashMap<VarType, List<VarType>>();
        ClassesProcessor.ClassNode class_ = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        while (true) {
            GenericMethodDescriptor mtd;
            GenericClassDescriptor cls;
            GenericClassDescriptor genericClassDescriptor = cls = class_ == null ? null : class_.classStruct.getSignature();
            if (cls != null) {
                for (int x = 0; x < cls.fparameters.size(); ++x) {
                    ret.put(GenericType.parse("T" + cls.fparameters.get(x) + ";"), cls.fbounds.get(x));
                }
            }
            GenericMethodDescriptor genericMethodDescriptor = mtd = method == null ? null : method.methodStruct.getSignature();
            if (mtd != null) {
                for (int x = 0; x < mtd.typeParameters.size(); ++x) {
                    ret.put(GenericType.parse("T" + mtd.typeParameters.get(x) + ";"), mtd.typeParameterBounds.get(x));
                }
            }
            if (class_ == null || class_.parent == null) break;
            method = class_.enclosingMethod == null ? null : class_.parent.getWrapper().getMethods().getWithKey(class_.enclosingMethod);
            class_ = class_.parent;
        }
        return ret;
    }

    public void setInvocationInstance() {
    }

    public void setIsQualifier() {
    }

    public boolean allowNewlineAfterQualifier() {
        return true;
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        if (matchNode.getType() != 1) {
            return null;
        }
        List<Exprent> lstAllExprents = this.getAllExprents();
        if (lstAllExprents == null || lstAllExprents.isEmpty()) {
            return null;
        }
        String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION);
        if (position != null) {
            if (position.matches("-?\\d+")) {
                return lstAllExprents.get((lstAllExprents.size() + Integer.parseInt(position)) % lstAllExprents.size());
            }
        } else if (index < lstAllExprents.size()) {
            return lstAllExprents.get(index);
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (matchNode.getType() != 1) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            IMatchable.MatchProperties key = rule.getKey();
            if (key == IMatchable.MatchProperties.EXPRENT_TYPE && this.type != (Integer)rule.getValue().value) {
                return false;
            }
            if (key != IMatchable.MatchProperties.EXPRENT_RET || engine.checkAndSetVariableValue((String)rule.getValue().value, this)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toJava(0).convertToStringAndAllowDataDiscard();
    }
}

