/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ArrayExprent
extends Exprent {
    private Exprent array;
    private Exprent index;
    private final VarType hardType;

    public ArrayExprent(Exprent array, Exprent index, VarType hardType, BitSet bytecodeOffsets) {
        super(1);
        this.array = array;
        this.index = index;
        this.hardType = hardType;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new ArrayExprent(this.array.copy(), this.index.copy(), this.hardType, this.bytecode);
    }

    @Override
    public VarType getExprType() {
        VarType exprType = this.array.getExprType();
        if (exprType.equals(VarType.VARTYPE_NULL)) {
            return this.hardType.copy();
        }
        return exprType.decreaseArrayDim();
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        VarType exprType = this.array.getInferredExprType(upperBound);
        if (exprType.equals(VarType.VARTYPE_NULL)) {
            return this.hardType.copy();
        }
        return exprType.decreaseArrayDim();
    }

    @Override
    public int getExprentUse() {
        return this.array.getExprentUse() & this.index.getExprentUse() & 1;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        result.addMinTypeExprent(this.index, VarType.VARTYPE_BYTECHAR);
        result.addMaxTypeExprent(this.index, VarType.VARTYPE_INT);
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.array);
        lst.add(this.index);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer res = this.array.toJava(indent);
        if (this.array.getPrecedence() > this.getPrecedence()) {
            res.enclose("(", ")");
        }
        VarType arrType = this.array.getExprType();
        if (arrType.arrayDim == 0) {
            VarType objArr = VarType.VARTYPE_OBJECT.resizeArrayDim(1);
            res.enclose("((" + ExprProcessor.getCastTypeName(objArr) + ")", ")");
        }
        res.addBytecodeMapping(this.bytecode);
        return res.append('[').append(this.index.toJava(indent)).append(']');
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.array) {
            this.array = newExpr;
        }
        if (oldExpr == this.index) {
            this.index = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayExprent)) {
            return false;
        }
        ArrayExprent arr = (ArrayExprent)o;
        return InterpreterUtil.equalObjects(this.array, arr.getArray()) && InterpreterUtil.equalObjects(this.index, arr.getIndex());
    }

    public Exprent getArray() {
        return this.array;
    }

    public Exprent getIndex() {
        return this.index;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        ArrayExprent.measureBytecode(values, this.array);
        ArrayExprent.measureBytecode(values, this.index);
        this.measureBytecode(values);
    }
}

