/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchHeadExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.Pair;

public final class SwitchHelper {
    public static final int STATIC_FINAL_SYNTHETIC = 4120;

    public static boolean simplifySwitches(Statement stat, StructMethod mt, RootStatement root) {
        boolean ret = false;
        if (stat.type == 6) {
            ret = SwitchHelper.simplify((SwitchStatement)stat, mt, root);
        }
        for (int i = 0; i < stat.getStats().size(); ++i) {
            ret |= SwitchHelper.simplifySwitches((Statement)stat.getStats().get(i), mt, root);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean simplify(SwitchStatement switchStatement, StructMethod mt, RootStatement root) {
        SwitchHeadExprent switchHeadExprent;
        Exprent value;
        ArrayExprent array;
        SwitchStatement following = null;
        List<StatEdge> edges = switchStatement.getSuccessorEdges(1);
        if (edges.size() == 1 && edges.get((int)0).getDestination().type == 6) {
            following = (SwitchStatement)edges.get(0).getDestination();
        }
        if ((array = SwitchHelper.getEnumArrayExprent(value = (switchHeadExprent = (SwitchHeadExprent)switchStatement.getHeadexprent()).getValue(), root)) != null) {
            MethodWrapper wrapper;
            Object classNode;
            List<List<Exprent>> caseValues = switchStatement.getCaseValues();
            HashMap mapping = new HashMap(caseValues.size());
            if (array.getArray().type == 5) {
                ClassWrapper classWrapper;
                FieldExprent arrayField = (FieldExprent)array.getArray();
                classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
                if (classNode != null && (classWrapper = ((ClassesProcessor.ClassNode)classNode).getWrapper()) != null && (wrapper = classWrapper.getMethodWrapper("<clinit>", "()V")) != null && wrapper.root != null) {
                    List<AssignmentExprent> fieldAssignments = SwitchHelper.getAssignmentsOfWithinOneStatement(wrapper.root, arrayField);
                    if (fieldAssignments.size() > 1) {
                        fieldAssignments.clear();
                    }
                    boolean[] fieldAssignmentEncountered = new boolean[]{false};
                    wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                        if (exprent instanceof AssignmentExprent) {
                            AssignmentExprent assignment = (AssignmentExprent)exprent;
                            Exprent left = assignment.getLeft();
                            if (left.type == 1) {
                                Exprent assignmentArray = ((ArrayExprent)left).getArray();
                                boolean targetsField = assignmentArray.equals(arrayField);
                                if (!targetsField && assignmentArray instanceof VarExprent && !fieldAssignmentEncountered[0]) {
                                    for (AssignmentExprent fieldAssignment : fieldAssignments) {
                                        if (!fieldAssignment.getRight().equals(assignmentArray)) continue;
                                        targetsField = true;
                                        break;
                                    }
                                }
                                if (targetsField) {
                                    mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                                }
                            } else if (fieldAssignments.contains(exprent)) {
                                fieldAssignmentEncountered[0] = true;
                            }
                        }
                        return 0;
                    });
                }
            } else {
                InvocationExprent invocation = (InvocationExprent)array.getArray();
                classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invocation.getClassname());
                if (classNode != null) {
                    ClassWrapper classWrapper = ((ClassesProcessor.ClassNode)classNode).getWrapper();
                    if (classWrapper != null) {
                        wrapper = classWrapper.getMethodWrapper(invocation.getName(), "()[I");
                        if (wrapper != null && wrapper.root != null) {
                            wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                                if (exprent instanceof AssignmentExprent) {
                                    AssignmentExprent assignment = (AssignmentExprent)exprent;
                                    Exprent left = assignment.getLeft();
                                    if (left.type == 1) {
                                        mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                                    }
                                }
                                return 0;
                            });
                        }
                    } else {
                        return false;
                    }
                }
            }
            ArrayList realCaseValues = new ArrayList(caseValues.size());
            for (List list : caseValues) {
                ArrayList<Exprent> values = new ArrayList<Exprent>(list.size());
                realCaseValues.add(values);
                for (Exprent exprent2 : list) {
                    if (exprent2 == null) {
                        values.add(null);
                        continue;
                    }
                    Exprent realConst = (Exprent)mapping.get(exprent2);
                    if (realConst == null) {
                        root.addComment("$FF: Unable to simplify switch on enum");
                        root.addErrorComment = true;
                        DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + exprent2 + " not found, available: " + mapping + " in method " + mt.getClassQualifiedName() + " " + mt.getName(), IFernflowerLogger.Severity.ERROR);
                        return false;
                    }
                    values.add(realConst.copy());
                }
            }
            caseValues.clear();
            caseValues.addAll(realCaseValues);
            switchHeadExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
            if (value instanceof VarExprent) {
                VarExprent var = (VarExprent)value;
                ArrayList arrayList = new ArrayList();
                SwitchHelper.findExprents(root, Exprent.class, x$0 -> var.isVarReferenced((Exprent)x$0, new VarExprent[0]), false, (stat, expr) -> references.add(Pair.of(stat, expr)));
                if (arrayList.size() == 1) {
                    Pair ref = (Pair)arrayList.get(0);
                    if (ref.b instanceof AssignmentExprent && ((AssignmentExprent)ref.b).getLeft().equals(value)) {
                        ((Statement)ref.a).getExprents().remove(ref.b);
                    }
                }
            }
            return true;
        }
        if (SwitchHelper.isSwitchOnString(switchStatement, following)) {
            HashMap<Integer, Exprent> caseMap = new HashMap<Integer, Exprent>();
            for (int i = 0; i < switchStatement.getCaseStatements().size(); ++i) {
                Statement curr = switchStatement.getCaseStatements().get(i);
                while (curr != null && curr.type == 2) {
                    void var12_22;
                    IfStatement ifStat = (IfStatement)curr;
                    Exprent exprent2 = ifStat.getHeadexprent().getCondition();
                    if (exprent2.type == 6 && ((FunctionExprent)exprent2).getFuncType() == 43) {
                        Exprent exprent3 = ((FunctionExprent)exprent2).getLstOperands().get(0);
                    }
                    if (var12_22.type == 8 && ((InvocationExprent)var12_22).getLstParameters().size() == 1) {
                        Exprent assign = ifStat.getIfstat().getExprents().get(0);
                        int caseVal = ((ConstExprent)((AssignmentExprent)assign).getRight()).getIntValue();
                        caseMap.put(caseVal, ((InvocationExprent)var12_22).getLstParameters().get(0));
                    }
                    curr = ifStat.getElsestat();
                }
            }
            List realCaseValues = following.getCaseValues().stream().map(l -> l.stream().map(e -> e instanceof ConstExprent ? Integer.valueOf(((ConstExprent)e).getIntValue()) : null).map(caseMap::get).collect(Collectors.toList())).collect(Collectors.toList());
            following.getCaseValues().clear();
            following.getCaseValues().addAll(realCaseValues);
            Exprent followingVal = ((SwitchHeadExprent)following.getHeadexprent()).getValue();
            following.getHeadexprent().replaceExprent(followingVal, ((InvocationExprent)value).getInstance());
            switchStatement.getFirst().getExprents().remove(switchStatement.getFirst().getExprents().size() - 1);
            switchStatement.getFirst().getAllPredecessorEdges().forEach(switchStatement.getFirst()::removePredecessor);
            switchStatement.getFirst().getAllSuccessorEdges().forEach(switchStatement.getFirst()::removeSuccessor);
            switchStatement.getParent().replaceStatement(switchStatement, switchStatement.getFirst());
            return true;
        }
        return false;
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (exprent instanceof ArrayExprent) {
            InvocationExprent inv;
            ArrayExprent arr = (ArrayExprent)exprent;
            Exprent tmp = arr.getArray();
            if (tmp instanceof FieldExprent) {
                boolean isSyncheticClass;
                FieldExprent field = (FieldExprent)tmp;
                Exprent index = arr.getIndex();
                ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(field.getClassname());
                if (classNode == null || !"[I".equals(field.getDescriptor().descriptorString)) {
                    return field.getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal");
                }
                StructField stField = classNode.getWrapper() == null ? classNode.classStruct.getField(field.getName(), field.getDescriptor().descriptorString) : classNode.getWrapper().getClassStruct().getField(field.getName(), field.getDescriptor().descriptorString);
                if ((stField.getAccessFlags() & 0x1018) != 4120) {
                    return false;
                }
                if (classNode.getWrapper() == null) {
                    isSyncheticClass = (classNode.classStruct.getAccessFlags() & 0x1000) == 4096;
                } else {
                    boolean bl = isSyncheticClass = (classNode.getWrapper().getClassStruct().getAccessFlags() & 0x1000) == 4096;
                }
                if (isSyncheticClass) {
                    return true;
                }
            } else if (tmp.type == 8 && (inv = (InvocationExprent)tmp).getName().startsWith("$SWITCH_TABLE$")) {
                return true;
            }
        }
        return false;
    }

    private static ArrayExprent getEnumArrayExprent(Exprent switchHead, RootStatement root) {
        Exprent candidate = switchHead;
        if (switchHead instanceof VarExprent) {
            VarExprent var = (VarExprent)switchHead;
            if (!"I".equals(var.getVarType().toString())) {
                return null;
            }
            List<AssignmentExprent> assignments = SwitchHelper.getAssignmentsOfWithinOneStatement(root, var);
            if (!assignments.isEmpty()) {
                if (assignments.size() == 1) {
                    AssignmentExprent assignment = assignments.get(0);
                    candidate = assignment.getRight();
                } else {
                    return null;
                }
            }
        }
        return SwitchHelper.isEnumArray(candidate) ? (ArrayExprent)candidate : null;
    }

    private static List<AssignmentExprent> getAssignmentsOfWithinOneStatement(Statement start, Exprent target) {
        ArrayList<AssignmentExprent> exprents = new ArrayList<AssignmentExprent>();
        SwitchHelper.findExprents(start, AssignmentExprent.class, assignment -> assignment.getLeft().equals(target), true, (stat, expr) -> exprents.add((AssignmentExprent)expr));
        return exprents;
    }

    private static <T extends Exprent> void findExprents(Statement start, Class<? extends T> exprClass, Predicate<T> predicate, boolean onlyOneStat, BiConsumer<Statement, T> consumer) {
        ArrayDeque<Statement> statQueue = new ArrayDeque<Statement>();
        statQueue.offer(start);
        while (!statQueue.isEmpty()) {
            Statement stat = (Statement)statQueue.remove();
            statQueue.addAll(stat.getStats());
            if (stat.getExprents() == null) continue;
            boolean foundAny = false;
            for (Exprent expr : stat.getExprents()) {
                if (!exprClass.isInstance(expr) || !predicate.test(expr)) continue;
                consumer.accept(stat, (Statement)((Object)expr));
                foundAny = true;
            }
            if (!onlyOneStat || !foundAny) continue;
            break;
        }
    }

    private static boolean isSwitchOnString(SwitchStatement first, SwitchStatement second) {
        if (second != null) {
            Exprent firstValue = ((SwitchHeadExprent)first.getHeadexprent()).getValue();
            Exprent secondValue = ((SwitchHeadExprent)second.getHeadexprent()).getValue();
            if (firstValue.type == 8 && secondValue.type == 12 && first.getCaseStatements().get((int)0).type == 2) {
                InvocationExprent invExpr = (InvocationExprent)firstValue;
                VarExprent varExpr = (VarExprent)secondValue;
                if (invExpr.getName().equals("hashCode") && invExpr.getClassname().equals("java/lang/String")) {
                    boolean matches = true;
                    for (int i = 0; matches && i < first.getCaseStatements().size(); ++i) {
                        if (first.getCaseEdges().get(i).contains(first.getDefaultEdge())) continue;
                        Statement curr = first.getCaseStatements().get(i);
                        while (matches && curr != null) {
                            if (curr.type == 2) {
                                List<Exprent> block;
                                InvocationExprent condInvocation;
                                IfStatement ifStat = (IfStatement)curr;
                                Exprent condition = ifStat.getHeadexprent().getCondition();
                                if (condition.type == 6 && ((FunctionExprent)condition).getFuncType() == 43) {
                                    condition = ((FunctionExprent)condition).getLstOperands().get(0);
                                }
                                if (condition.type == 8 && (condInvocation = (InvocationExprent)condition).getName().equals("equals") && condInvocation.getInstance().equals(invExpr.getInstance()) && (block = ifStat.getIfstat().getExprents()) != null && block.size() == 1 && block.get((int)0).type == 2) {
                                    AssignmentExprent assign = (AssignmentExprent)block.get(0);
                                    if (assign.getRight().type == 3 && varExpr.equals(assign.getLeft())) {
                                        curr = ifStat.getElsestat();
                                        continue;
                                    }
                                }
                            }
                            matches = false;
                        }
                    }
                    return matches;
                }
            }
        }
        return false;
    }
}

