/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchPatternMatchProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.TryWithResourcesProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchHeadExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.YieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;

public final class SwitchExpressionHelper {
    public static boolean processAllSwitchExpressions(Statement root) {
        return SwitchPatternMatchProcessor.processPatternMatching(root) || SwitchExpressionHelper.processSwitchExpressions(root);
    }

    public static boolean processSwitchExpressions(Statement root) {
        boolean ret = SwitchExpressionHelper.processSwitchExpressionsRec(root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
        }
        return ret;
    }

    private static boolean processSwitchExpressionsRec(Statement stat) {
        boolean ret = false;
        for (Statement st : new ArrayList(stat.getStats())) {
            ret |= SwitchExpressionHelper.processSwitchExpressionsRec(st);
        }
        if (stat.type == 6) {
            ret |= SwitchExpressionHelper.processStatement((SwitchStatement)stat);
        }
        return ret;
    }

    private static boolean processStatement(SwitchStatement stat) {
        InvocationExprent invoc;
        if (stat.isPhantom()) {
            return false;
        }
        Exprent condition = ((SwitchHeadExprent)stat.getHeadexprent()).getValue();
        if (condition.type == 8 && (invoc = (InvocationExprent)condition).getName().equals("hashCode") && invoc.getClassname().equals("java/lang/String")) {
            return false;
        }
        List<Statement> breakJumps = SwitchExpressionHelper.findBreakJumps(stat);
        if (breakJumps == null) {
            return false;
        }
        HashSet<Statement> check = new HashSet<Statement>();
        check.addAll(breakJumps);
        check.addAll(stat.getCaseStatements());
        for (Statement st : check) {
            if (!st.hasBasicSuccEdge()) continue;
            List<StatEdge> breaks = st.getSuccessorEdges(4);
            if (breaks.isEmpty()) {
                return false;
            }
            if (stat.containsStatement(breaks.get((int)0).closure) || breaks.get((int)0).getDestination().type == 14) continue;
            return false;
        }
        Map<Statement, List<VarVersionPair>> assignments = SwitchExpressionHelper.mapAssignments(breakJumps);
        if (assignments == null) {
            return false;
        }
        boolean foundDefault = stat.getCaseEdges().stream().flatMap(Collection::stream).anyMatch(e -> e == stat.getDefaultEdge());
        if (!foundDefault) {
            return false;
        }
        VarExprent relevantVar = SwitchExpressionHelper.findRelevantVar(assignments);
        if (relevantVar == null) {
            return false;
        }
        HashSet<StatEdge> edges = new HashSet<StatEdge>();
        for (Statement caseStat : stat.getCaseStatements()) {
            TryWithResourcesProcessor.findEdgesLeaving(caseStat, caseStat, edges);
            for (StatEdge edge : edges) {
                if (edge.getType() != 8) continue;
                return false;
            }
            edges.clear();
        }
        List<StatEdge> sucs = stat.getSuccessorEdges(1);
        if (!sucs.isEmpty()) {
            Statement suc = sucs.get(0).getDestination();
            if (suc.type != 8) {
                Statement oldSuc = suc;
                suc = BasicBlockStatement.create();
                SequenceStatement seq = new SequenceStatement(new Statement[]{stat, suc});
                seq.setParent(stat.getParent());
                stat.replaceWith(seq);
                seq.setAllParent();
                for (Statement st : stat.getCaseStatements()) {
                    for (StatEdge edge : st.getAllSuccessorEdges()) {
                        if (edge.getDestination() != oldSuc) continue;
                        st.removeSuccessor(edge);
                        st.addSuccessor(new StatEdge(edge.getType(), st, suc, seq));
                    }
                }
                suc.addSuccessor(new StatEdge(1, suc, oldSuc, seq));
            }
            stat.setPhantom(true);
            for (Statement st : stat.getCaseStatements()) {
                HashMap<Exprent, YieldExprent> replacements = new HashMap<Exprent, YieldExprent>();
                SwitchExpressionHelper.findReplacements(st, relevantVar.getVarVersionPair(), replacements);
                if (replacements.isEmpty()) continue;
                SwitchExpressionHelper.replace(st, replacements);
            }
            List<Exprent> exprents = suc.getExprents();
            VarExprent vExpr = new VarExprent(relevantVar.getIndex(), relevantVar.getVarType(), relevantVar.getProcessor());
            vExpr.setStack(true);
            AssignmentExprent toAdd = new AssignmentExprent(vExpr, new SwitchExprent(stat, relevantVar.getExprType(), false, false), null);
            exprents.add(0, toAdd);
            List<Exprent> firstExprents = stat.getFirst().getExprents();
            if (firstExprents != null && !firstExprents.isEmpty()) {
                int i = 0;
                Iterator<Exprent> iterator = firstExprents.iterator();
                while (iterator.hasNext()) {
                    Exprent ex = iterator.next();
                    if (ex.type != 2 || ((AssignmentExprent)ex).getLeft().type != 12 || !((VarExprent)((AssignmentExprent)ex).getLeft()).isStack()) continue;
                    exprents.add(i, ex);
                    ++i;
                    iterator.remove();
                }
            }
            return true;
        }
        return false;
    }

    private static void findReplacements(Statement stat, VarVersionPair var, Map<Exprent, YieldExprent> replacements) {
        if (stat.getExprents() != null) {
            for (Exprent e : stat.getExprents()) {
                if (e.type != 2) continue;
                AssignmentExprent assign = (AssignmentExprent)e;
                if (assign.getLeft().type != 12 || ((VarExprent)assign.getLeft()).getIndex() != var.var) continue;
                replacements.put(assign, new YieldExprent(assign.getRight(), assign.getExprType()));
            }
        }
        for (Statement st : stat.getStats()) {
            SwitchExpressionHelper.findReplacements(st, var, replacements);
        }
    }

    private static void replace(Statement stat, Map<Exprent, YieldExprent> replacements) {
        for (Map.Entry<Exprent, YieldExprent> entry : replacements.entrySet()) {
            stat.replaceExprent(entry.getKey(), entry.getValue());
        }
        for (Statement st : stat.getStats()) {
            SwitchExpressionHelper.replace(st, replacements);
        }
    }

    private static List<Statement> findBreakJumps(SwitchStatement stat) {
        List<StatEdge> edges = stat.getSuccessorEdges(1);
        Statement check = stat.getParent();
        while (edges.isEmpty()) {
            edges = check.getSuccessorEdges(1);
            if ((check = check.getParent()) != null) continue;
            return null;
        }
        StatEdge edge = edges.get(0);
        Statement next = edge.getDestination();
        List<StatEdge> breaks = next.getPredecessorEdges(4);
        breaks.addAll(((RootStatement)stat.getTopParent()).getDummyExit().getPredecessorEdges(4));
        breaks.removeIf(e -> !stat.containsStatement(e.getSource()));
        return breaks.stream().map(StatEdge::getSource).collect(Collectors.toList());
    }

    private static Map<Statement, List<VarVersionPair>> mapAssignments(List<Statement> breakJumps) {
        HashMap<Statement, List<VarVersionPair>> map = new HashMap<Statement, List<VarVersionPair>>();
        for (Statement breakJump : breakJumps) {
            List<Exprent> exprents = breakJump.getExprents();
            if (exprents == null || exprents.isEmpty()) continue;
            if (exprents.size() == 1 && exprents.get((int)0).type == 4) {
                ExitExprent exit = (ExitExprent)exprents.get(0);
                if (exit.getExitType() == 1) {
                    map.put(breakJump, null);
                    continue;
                }
                return null;
            }
            ArrayList<VarVersionPair> list = new ArrayList<VarVersionPair>();
            for (int i = exprents.size() - 1; i >= 0; --i) {
                Exprent exprent = exprents.get(i);
                if (exprent.type != 2) break;
                AssignmentExprent assign = (AssignmentExprent)exprent;
                if (assign.getLeft().type != 12) break;
                VarExprent var = (VarExprent)assign.getLeft();
                list.add(var.getVarVersionPair());
            }
            map.put(breakJump, list);
        }
        return map;
    }

    private static VarExprent findRelevantVar(Map<Statement, List<VarVersionPair>> assignments) {
        ArrayList<List<VarVersionPair>> values = new ArrayList<List<VarVersionPair>>(assignments.values());
        boolean consistentlyMoreThan1 = true;
        for (List list : values) {
            if (list == null) continue;
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() != 1) continue;
            consistentlyMoreThan1 = false;
        }
        if (consistentlyMoreThan1) {
            return null;
        }
        List firstNotNull = null;
        for (List list : values) {
            if (list == null) continue;
            firstNotNull = list;
            break;
        }
        if (firstNotNull == null) {
            return null;
        }
        VarVersionPair varVersionPair = (VarVersionPair)firstNotNull.get(0);
        for (List list : values) {
            if (list == null || ((VarVersionPair)list.get(0)).equals(varVersionPair)) continue;
            return null;
        }
        for (Map.Entry<Statement, List<VarVersionPair>> entry : assignments.entrySet()) {
            if (entry.getValue() != firstNotNull) continue;
            List<Exprent> exprents = entry.getKey().getExprents();
            Exprent exprent = exprents.get(exprents.size() - 1);
            return (VarExprent)((AssignmentExprent)exprent).getLeft();
        }
        return null;
    }

    public static boolean hasSwitchExpressions(RootStatement statement) {
        return statement.mt.getBytecodeVersion().hasSwitchExpressions() && DecompilerContext.getOption("swe");
    }
}

