/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;

public final class InlineSingleBlockHelper {
    public static boolean inlineSingleBlocks(RootStatement root) {
        boolean res = InlineSingleBlockHelper.inlineSingleBlocksRec(root);
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static boolean inlineSingleBlocksRec(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= InlineSingleBlockHelper.inlineSingleBlocksRec(st);
        }
        if (stat.type == 15) {
            SequenceStatement seq = (SequenceStatement)stat;
            for (int i = 1; i < seq.getStats().size(); ++i) {
                if (!InlineSingleBlockHelper.isInlineable(seq, i)) continue;
                InlineSingleBlockHelper.inlineBlock(seq, i);
                return true;
            }
        }
        return res;
    }

    private static void inlineBlock(SequenceStatement seq, int index) {
        Statement first = (Statement)seq.getStats().get(index);
        Statement pre = (Statement)seq.getStats().get(index - 1);
        pre.removeSuccessor(pre.getAllSuccessorEdges().get(0));
        StatEdge edge = first.getPredecessorEdges(4).get(0);
        Statement source = edge.getSource();
        Statement parent = source.getParent();
        source.removeSuccessor(edge);
        ArrayList<Statement> lst = new ArrayList<Statement>();
        for (int i = seq.getStats().size() - 1; i >= index; --i) {
            lst.add(0, seq.getStats().remove(i));
        }
        if (parent.type == 2 && ((IfStatement)parent).iftype == 0 && source == parent.getFirst()) {
            IfStatement ifparent = (IfStatement)parent;
            SequenceStatement block = new SequenceStatement(lst);
            block.setAllParent();
            StatEdge newedge = new StatEdge(1, source, block);
            source.addSuccessor(newedge);
            ifparent.setIfEdge(newedge);
            ifparent.setIfstat(block);
            ifparent.getStats().addWithKey(block, block.id);
            block.setParent(ifparent);
        } else {
            lst.add(0, source);
            SequenceStatement block = new SequenceStatement(lst);
            block.setAllParent();
            parent.replaceStatement(source, block);
            for (StatEdge prededge : block.getPredecessorEdges(8)) {
                block.removePredecessor(prededge);
                prededge.getSource().changeEdgeNode(1, prededge, source);
                source.addPredecessor(prededge);
                source.addLabeledEdge(prededge);
            }
            if (parent.type == 6) {
                ((SwitchStatement)parent).sortEdgesAndNodes();
            }
            source.addSuccessor(new StatEdge(1, source, first));
        }
    }

    private static boolean isInlineable(SequenceStatement seq, int index) {
        StatEdge edge;
        Statement first = (Statement)seq.getStats().get(index);
        Statement pre = (Statement)seq.getStats().get(index - 1);
        if (pre.hasBasicSuccEdge()) {
            return false;
        }
        List<StatEdge> lst = first.getPredecessorEdges(4);
        if (lst.size() == 1 && InlineSingleBlockHelper.sameCatchRanges(edge = lst.get(0))) {
            boolean noPreSuccessors;
            if (!edge.canInline) {
                return false;
            }
            if (!edge.explicit) {
                for (int i = index; i < seq.getStats().size(); ++i) {
                    if (InlineSingleBlockHelper.noExitLabels((Statement)seq.getStats().get(i), seq)) continue;
                    return false;
                }
            }
            return !(noPreSuccessors = pre.getAllSuccessorEdges().isEmpty());
        }
        return false;
    }

    private static boolean sameCatchRanges(StatEdge edge) {
        Statement parent;
        Statement from = edge.getSource();
        Statement to = edge.getDestination();
        while (!(parent = from.getParent()).containsStatementStrict(to)) {
            if (parent.type == 7 || parent.type == 12 ? parent.getFirst() == from : parent.type == 10 && parent.getStats().get(1) == from) {
                return false;
            }
            from = parent;
        }
        return true;
    }

    private static boolean noExitLabels(Statement block, Statement sequence) {
        for (StatEdge edge : block.getAllSuccessorEdges()) {
            if (edge.getType() == 1 || edge.getDestination().type == 14 || sequence.containsStatementStrict(edge.getDestination())) continue;
            return false;
        }
        for (Statement st : block.getStats()) {
            if (InlineSingleBlockHelper.noExitLabels(st, sequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBreakEdgeLabeled(Statement source, Statement closure) {
        if (closure.type == 5 || closure.type == 6) {
            Statement parent = source.getParent();
            return parent != closure && (parent.type == 5 || parent.type == 6 || InlineSingleBlockHelper.isBreakEdgeLabeled(parent, closure));
        }
        return true;
    }
}

