/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;

public final class IfPatternMatchProcessor {
    public static boolean matchInstanceof(RootStatement root) {
        boolean res = IfPatternMatchProcessor.matchInstanceofRec(root, root);
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static boolean matchInstanceofRec(Statement statement, RootStatement root) {
        boolean res = false;
        for (Statement stat : statement.getStats()) {
            if (!IfPatternMatchProcessor.matchInstanceofRec(stat, root)) continue;
            res = true;
        }
        if (statement instanceof IfStatement) {
            res |= IfPatternMatchProcessor.handleIf((IfStatement)statement, root);
        }
        return res;
    }

    private static boolean handleIf(IfStatement statement, RootStatement root) {
        Exprent condition = statement.getHeadexprent().getCondition();
        if (condition.type != 6) {
            return false;
        }
        FunctionExprent func = (FunctionExprent)condition;
        List<Exprent> exprents = func.getAllExprents(true);
        boolean updated = false;
        block0: for (Exprent exprent : exprents) {
            Exprent casted;
            boolean isHead;
            FunctionExprent iof;
            if (exprent.type != 6 || (iof = (FunctionExprent)exprent).getFuncType() != 30) continue;
            Exprent source = iof.getLstOperands().get(0);
            Exprent target = iof.getLstOperands().get(1);
            BasicBlockStatement head = statement.getIfstat() == null ? null : statement.getIfstat().getBasichead();
            boolean bl = isHead = head != null && head != statement.getIfstat();
            if (head == null || head.getExprents() == null || head.getExprents().size() <= (isHead ? 0 : 1)) continue;
            Exprent first = head.getExprents().get(0);
            if (first.type != 2) continue;
            Exprent left = first.getAllExprents().get(0);
            Exprent right = first.getAllExprents().get(1);
            if (right.type != 6 || ((FunctionExprent)right).getFuncType() != 29 || !source.equals(casted = right.getAllExprents().get(0)) || left.type != 12 || !target.getExprType().equals(left.getExprType())) continue;
            ArrayList<VarVersionPair> vvs = new ArrayList<VarVersionPair>();
            IfPatternMatchProcessor.findVarsInPredecessors(vvs, statement.getIfstat());
            VarVersionPair var = ((VarExprent)left).getVarVersionPair();
            for (VarVersionPair vv : vvs) {
                if (var.var != vv.var) continue;
                continue block0;
            }
            iof.getLstOperands().add(2, left);
            head.getExprents().remove(0);
            statement.setPatternMatched(true);
            updated = true;
        }
        return updated;
    }

    private static void findVarsInPredecessors(List<VarVersionPair> vvs, Statement root) {
        for (StatEdge pred : root.getAllPredecessorEdges()) {
            Statement stat = pred.getSource();
            if (stat.getExprents() == null) continue;
            for (Exprent exprent : stat.getExprents()) {
                if (exprent.type != 2) continue;
                AssignmentExprent assignment = (AssignmentExprent)exprent;
                if (assignment.getLeft().type != 12) continue;
                vvs.add(((VarExprent)assignment.getLeft()).getVarVersionPair());
            }
        }
    }
}

