/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class ConcatenationHelper {
    private static final String builderClass = "java/lang/StringBuilder";
    private static final String bufferClass = "java/lang/StringBuffer";
    private static final String stringClass = "java/lang/String";
    private static final VarType builderType = new VarType(8, 0, "java/lang/StringBuilder");
    private static final VarType bufferType = new VarType(8, 0, "java/lang/StringBuffer");
    private static final char TAG_ARG = '\u0001';
    private static final String TAG_ARG_S = "\u0001";
    private static final char TAG_CONST = '\u0002';

    public static void simplifyStringConcat(Statement stat) {
        for (Statement s : stat.getStats()) {
            ConcatenationHelper.simplifyStringConcat(s);
        }
        if (stat.getExprents() != null) {
            for (int i = 0; i < stat.getExprents().size(); ++i) {
                Exprent ret = ConcatenationHelper.simplifyStringConcat(stat.getExprents().get(i));
                if (ret == null) continue;
                stat.getExprents().set(i, ret);
            }
        }
    }

    private static Exprent simplifyStringConcat(Exprent exprent) {
        Exprent ret;
        for (Exprent cexp : exprent.getAllExprents()) {
            Exprent ret2 = ConcatenationHelper.simplifyStringConcat(cexp);
            if (ret2 == null) continue;
            exprent.replaceExprent(cexp, ret2);
        }
        if (exprent.type == 8 && !exprent.equals(ret = ConcatenationHelper.contractStringConcat(exprent))) {
            return ret;
        }
        return null;
    }

    public static Exprent contractStringConcat(Exprent expr) {
        int found;
        Exprent exprTmp = null;
        VarType cltype = null;
        if (expr.type == 8) {
            InvocationExprent iex = (InvocationExprent)expr;
            if ("toString".equals(iex.getName())) {
                if (builderClass.equals(iex.getClassname())) {
                    cltype = builderType;
                } else if (bufferClass.equals(iex.getClassname())) {
                    cltype = bufferType;
                }
                if (cltype != null) {
                    exprTmp = iex.getInstance();
                }
            } else if ("makeConcatWithConstants".equals(iex.getName()) || "makeConcat".equals(iex.getName())) {
                int index;
                List<Exprent> parameters = ConcatenationHelper.extractParameters(iex.getBootstrapArguments(), iex);
                boolean addEmptyString = true;
                for (index = 0; index < parameters.size() && index < 2; ++index) {
                    if (!parameters.get(index).getExprType().equals(VarType.VARTYPE_STRING)) continue;
                    addEmptyString = false;
                    break;
                }
                if (addEmptyString) {
                    index = parameters.size() == 1 ? 1 : 0;
                    parameters.add(index, new ConstExprent(VarType.VARTYPE_STRING, "", expr.bytecode));
                }
                if (parameters.size() >= 2) {
                    return ConcatenationHelper.createConcatExprent(parameters, expr.bytecode);
                }
            }
        }
        if (exprTmp == null) {
            return expr;
        }
        ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
        do {
            found = 0;
            switch (exprTmp.type) {
                case 8: {
                    InvocationExprent iex = (InvocationExprent)exprTmp;
                    if (!ConcatenationHelper.isAppendConcat(iex, cltype)) break;
                    lstOperands.add(0, iex.getLstParameters().get(0));
                    exprTmp = iex.getInstance();
                    found = 1;
                    break;
                }
                case 10: {
                    NewExprent nex = (NewExprent)exprTmp;
                    if (!ConcatenationHelper.isNewConcat(nex, cltype)) break;
                    VarType[] params = nex.getConstructor().getDescriptor().params;
                    if (params.length == 1) {
                        lstOperands.add(0, nex.getConstructor().getLstParameters().get(0));
                    }
                    found = 2;
                }
            }
            if (found != 0) continue;
            return expr;
        } while (found != 2);
        int first2str = 0;
        for (int index = 0; index < lstOperands.size() && index < 2; ++index) {
            if (!((Exprent)lstOperands.get(index)).getExprType().equals(VarType.VARTYPE_STRING)) continue;
            first2str |= index + 1;
        }
        if (first2str == 0) {
            lstOperands.add(0, new ConstExprent(VarType.VARTYPE_STRING, "", expr.bytecode));
        }
        for (int i = 0; i < lstOperands.size(); ++i) {
            boolean ok;
            Exprent rep = ConcatenationHelper.removeStringValueOf((Exprent)lstOperands.get(i));
            boolean bl = ok = i > 1;
            if (!ok) {
                boolean isstr = rep.getExprType().equals(VarType.VARTYPE_STRING);
                boolean bl2 = ok = isstr || first2str != i + 1;
                if (i == 0) {
                    first2str &= 2;
                }
            }
            if (!ok) continue;
            lstOperands.set(i, rep);
        }
        return ConcatenationHelper.createConcatExprent(lstOperands, expr.bytecode);
    }

    private static Exprent createConcatExprent(List<Exprent> lstOperands, BitSet bytecode) {
        Exprent func = lstOperands.get(0);
        for (int i = 1; i < lstOperands.size(); ++i) {
            func = new FunctionExprent(50, Arrays.asList(func, lstOperands.get(i)), bytecode);
        }
        return func;
    }

    private static List<Exprent> extractParameters(List<PooledConstant> bootstrapArguments, InvocationExprent expr) {
        List<Exprent> parameters = expr.getLstParameters();
        if (bootstrapArguments != null) {
            String recipe = null;
            if (!bootstrapArguments.isEmpty() && bootstrapArguments.get((int)0).type == 8) {
                PooledConstant constant = bootstrapArguments.get(0);
                if (constant.type == 8) {
                    recipe = ((PrimitiveConstant)constant).getString();
                }
            } else if (bootstrapArguments.isEmpty()) {
                recipe = new String(new char[parameters.size()]).replace("\u0000", TAG_ARG_S);
            }
            if (recipe != null) {
                ArrayList<Exprent> res = new ArrayList<Exprent>();
                StringBuilder acc = new StringBuilder();
                int parameterId = 0;
                for (int i = 0; i < recipe.length(); ++i) {
                    char c = recipe.charAt(i);
                    if (c == '\u0002' || c == '\u0001') {
                        if (acc.length() > 0) {
                            res.add(new ConstExprent(VarType.VARTYPE_STRING, acc.toString(), expr.bytecode));
                            acc.setLength(0);
                        }
                        if (c == '\u0002') {
                            // empty if block
                        }
                        if (c != '\u0001') continue;
                        res.add(parameters.get(parameterId++));
                        continue;
                    }
                    acc.append(c);
                }
                if (acc.length() > 0) {
                    res.add(new ConstExprent(VarType.VARTYPE_STRING, acc.toString(), expr.bytecode));
                }
                return res;
            }
        }
        return new ArrayList<Exprent>(parameters);
    }

    private static boolean isAppendConcat(InvocationExprent expr, VarType cltype) {
        if ("append".equals(expr.getName())) {
            MethodDescriptor md = expr.getDescriptor();
            if (md.ret.equals(cltype) && md.params.length == 1) {
                VarType param = md.params[0];
                switch (param.type) {
                    case 8: {
                        if (!param.equals(VarType.VARTYPE_STRING) && !param.equals(VarType.VARTYPE_OBJECT)) break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isNewConcat(NewExprent expr, VarType cltype) {
        if (expr.getNewType().equals(cltype)) {
            VarType[] params = expr.getConstructor().getDescriptor().params;
            return params.length == 0 || params.length == 1 && params[0].equals(VarType.VARTYPE_STRING);
        }
        return false;
    }

    private static Exprent removeStringValueOf(Exprent exprent) {
        InvocationExprent iex;
        if (exprent.type == 8 && "valueOf".equals((iex = (InvocationExprent)exprent).getName()) && stringClass.equals(iex.getClassname())) {
            MethodDescriptor md = iex.getDescriptor();
            if (md.params.length == 1) {
                VarType param = md.params[0];
                switch (param.type) {
                    case 8: {
                        if (!param.equals(VarType.VARTYPE_OBJECT)) break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return iex.getLstParameters().get(0);
                    }
                }
            }
        }
        return exprent;
    }
}

