/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.extern;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public interface IFernflowerPreferences {
    @Name(value="Remove Bridge Methods")
    @Description(value="Removes any methods that are marked as bridge from the decompiled output.")
    public static final String REMOVE_BRIDGE = "rbr";
    @Name(value="Remove Synthetic Methods And Fields")
    @Description(value="Removes any methods and fields that are marked as synthetic from the decompiled output.")
    public static final String REMOVE_SYNTHETIC = "rsy";
    @Name(value="Decompile Inner Classes")
    @Description(value="Process inner classes and add them to the decompiled output.")
    public static final String DECOMPILE_INNER = "din";
    @Name(value="Decompile Java 4 class references")
    @Description(value="Java 1 to Java 4 had a different class reference format. This resugars them properly.")
    public static final String DECOMPILE_CLASS_1_4 = "dc4";
    @Name(value="Decompile Assertions")
    @Description(value="Decompile assert statements.")
    public static final String DECOMPILE_ASSERTIONS = "das";
    @Name(value="Hide Empty super()")
    @Description(value="Hide super() calls with no parameters.")
    public static final String HIDE_EMPTY_SUPER = "hes";
    @Name(value="Hide Default Constructor")
    @Description(value="Hide constructors with no parameters and no code.")
    public static final String HIDE_DEFAULT_CONSTRUCTOR = "hdc";
    @Name(value="Decompile Generics")
    @Description(value="Decompile generics in variables, fields, and statements.")
    public static final String DECOMPILE_GENERIC_SIGNATURES = "dgs";
    @Name(value="No Exceptions In Return")
    @Description(value="Integrate returns better in try-catch blocks.")
    public static final String NO_EXCEPTIONS_RETURN = "ner";
    @Name(value="Ensure synchronized ranges are complete")
    @Description(value="If a synchronized block has a monitorenter without any corresponding monitorexit, try to deduce where one should be to ensure the synchronized is proper.")
    public static final String ENSURE_SYNCHRONIZED_MONITOR = "esm";
    @Name(value="Decompile Enums")
    @Description(value="Decompile enums.")
    public static final String DECOMPILE_ENUM = "den";
    @Name(value="Remove reference getClass()")
    @Description(value="obj.new Inner() or calling invoking a method on a method reference will create a synthetic getClass() call. This removes it.")
    public static final String REMOVE_GET_CLASS_NEW = "rgn";
    @Name(value="Keep Literals As Is")
    @Description(value="Keep NaN, infinties, and pi values as is without resugaring them.")
    public static final String LITERALS_AS_IS = "lit";
    @Name(value="Represent boolean as 0/1")
    @Description(value="The JVM represents booleans as integers 0 and 1. This decodes 0 and 1 as boolean when it makes sense.")
    public static final String BOOLEAN_TRUE_ONE = "bto";
    @Name(value="ASCII String Characters")
    @Description(value="Encode non-ASCII characters in string and character literals as Unicode escapes.")
    public static final String ASCII_STRING_CHARACTERS = "asc";
    @Name(value="Synthetic Not Set")
    @Description(value="Treat some known structures as synthetic even when not explicitly set.")
    public static final String SYNTHETIC_NOT_SET = "nns";
    @Name(value="Treat Undefined Param Type As Object")
    @Description(value="Treat nameless types as java.lang.Object.")
    public static final String UNDEFINED_PARAM_TYPE_OBJECT = "uto";
    @Name(value="Use LVT Names")
    @Description(value="Use LVT names for local variables and parameters instead of var<index>_<version>.")
    public static final String USE_DEBUG_VAR_NAMES = "udv";
    @Name(value="Use Method Parameters")
    @Description(value="Use method parameter names, as given in the MethodParameters attribute.")
    public static final String USE_METHOD_PARAMETERS = "ump";
    @Name(value="Remove Empty try-catch blocks")
    @Description(value="Remove try-catch blocks with no code.")
    public static final String REMOVE_EMPTY_RANGES = "rer";
    @Name(value="Decompile Finally")
    @Description(value="Decompile finally blocks.")
    public static final String FINALLY_DEINLINE = "fdi";
    @Name(value="Resugar Intellij IDEA @NotNull")
    @Description(value="Resugar Intellij IDEA's code generated by @NotNull annotations.")
    public static final String IDEA_NOT_NULL_ANNOTATION = "inn";
    @Name(value="Decompile Lambdas as Anonymous Classes")
    @Description(value="Decompile lambda expressions as anonymous classes.")
    public static final String LAMBDA_TO_ANONYMOUS_CLASS = "lac";
    @Name(value="Bytecode to Source Mapping")
    @Description(value="Map Bytecode to source lines.")
    public static final String BYTECODE_SOURCE_MAPPING = "bsm";
    @Name(value="Dump Code Lines")
    @Description(value="Dump line mappings to output archive zip entry extra data")
    public static final String DUMP_CODE_LINES = "dcl";
    @Name(value="Ignore Invalid Bytecode")
    @Description(value="Ignore bytecode that is malformed.")
    public static final String IGNORE_INVALID_BYTECODE = "iib";
    @Name(value="Verify Anonymous Classes")
    @Description(value="Verify that anonymous classes are local.")
    public static final String VERIFY_ANONYMOUS_CLASSES = "vac";
    @Name(value="Ternary Constant Simplification")
    @Description(value="Fold branches of ternary expressions that have boolean true and false constants.")
    public static final String TERNARY_CONSTANT_SIMPLIFICATION = "tcs";
    @Name(value="Pattern Matching")
    @Description(value="Decompile with if and switch pattern matching enabled.")
    public static final String PATTERN_MATCHING = "pam";
    @Name(value="[Experimental] Try-Loop fix")
    @Description(value="Code with a while loop inside of a try-catch block sometimes is malformed. This attempts to fix it, but may cause other issues.")
    public static final String EXPERIMENTAL_TRY_LOOP_FIX = "tlf";
    @Name(value="[Experimental] Ternary In If Conditions")
    @Description(value="Tries to collapse if statements that have a ternary in their condition.")
    public static final String TERNARY_CONDITIONS = "tco";
    @Name(value="Decompile Switch Expressions")
    @Description(value="Decompile switch expressions in modern Java class files.")
    public static final String SWITCH_EXPRESSIONS = "swe";
    @Name(value="[Debug] Show hidden statements")
    @Description(value="Display code blocks hidden, for debugging purposes")
    public static final String SHOW_HIDDEN_STATEMENTS = "shs";
    @Name(value="Override Annotation")
    @Description(value="Display override annotations for methods known to the decompiler.")
    public static final String OVERRIDE_ANNOTATION = "ovr";
    @Name(value="Second-Pass Stack Simplficiation")
    @Description(value="Simplify variables across stack bounds to resugar complex statements.")
    public static final String SIMPLIFY_STACK_SECOND_PASS = "ssp";
    @Name(value="Include Entire Classpath")
    @Description(value="Give the decompiler information about every jar on the classpath.")
    public static final String INCLUDE_ENTIRE_CLASSPATH = "iec";
    @Name(value="Include Java Runtime")
    @Description(value="Give the decompiler information about the Java runtime.")
    public static final String INCLUDE_JAVA_RUNTIME = "jrt";
    @Name(value="Explicit Generic Arguments")
    @Description(value="Put explicit diamond generic arguments on method calls.")
    public static final String EXPLICIT_GENERIC_ARGUMENTS = "ega";
    @Name(value="Inline Simple Lambdas")
    @Description(value="Remove braces on simple, one line, lambda expressions.")
    public static final String INLINE_SIMPLE_LAMBDAS = "isl";
    @Name(value="Logging Level")
    @Description(value="Logging level. Must be one of: 'info', 'debug', 'warn', 'error'.")
    public static final String LOG_LEVEL = "log";
    @Name(value="[DEPRECATED] Max time to process method")
    @Description(value="Maximum time in seconds to process a method. This is deprecated, do not use.")
    public static final String MAX_PROCESSING_METHOD = "mpm";
    @Name(value="Rename Members")
    @Description(value="Rename classes, fields, and methods with a number suffix to help in deobfuscation.")
    public static final String RENAME_ENTITIES = "ren";
    @Name(value="User Renamer Class")
    @Description(value="Path to a class that implements IIdentifierRenamer.")
    public static final String USER_RENAMER_CLASS = "urc";
    @Name(value="New Line Seperator")
    @Description(value="Character that seperates lines in the decompiled output.")
    public static final String NEW_LINE_SEPARATOR = "nls";
    @Name(value="Indent String")
    @Description(value="A string of spaces or tabs that is placed for each indent level.")
    public static final String INDENT_STRING = "ind";
    @Name(value="Preferred line length")
    @Description(value="Max line length before formatting is applied.")
    public static final String PREFERRED_LINE_LENGTH = "pll";
    @Name(value="User Renamer Class")
    @Description(value="Path to a class that implements IIdentifierRenamer.")
    public static final String BANNER = "ban";
    @Name(value="Error Message")
    @Description(value="Message to display when an error occurs in the decompiler.")
    public static final String ERROR_MESSAGE = "erm";
    @Name(value="Thread Count")
    @Description(value="How many threads to use to decompile.")
    public static final String THREADS = "thr";
    public static final String DUMP_ORIGINAL_LINES = "__dump_original_lines__";
    public static final String UNIT_TEST_MODE = "__unit_test_mode__";
    public static final String LINE_SEPARATOR_WIN = "\r\n";
    public static final String LINE_SEPARATOR_UNX = "\n";
    @Name(value="JAD-Style Variable Naming")
    @Description(value="Use JAD-style variable naming for local variables, instead of var<index>_<version>A.")
    public static final String USE_JAD_VARNAMING = "jvn";
    public static final String SKIP_EXTRA_FILES = "sef";
    public static final String WARN_INCONSISTENT_INNER_CLASSES = "win";
    @Name(value="Dump Bytecode On Error")
    @Description(value="Put the bytecode in the method body when an error occurs.")
    public static final String DUMP_BYTECODE_ON_ERROR = "dbe";
    @Name(value="Dump Exceptions On Error")
    @Description(value="Put the exception message in the method body when an error occurs.")
    public static final String DUMP_EXCEPTION_ON_ERROR = "dee";
    @Name(value="Decompiler Comments")
    @Description(value="Sometimes, odd behavior of the bytecode or unfixable problems occur. This enables or disables the adding of those to the decompiled output.")
    public static final String DECOMPILER_COMMENTS = "dec";
    public static final Map<String, Object> DEFAULTS = IFernflowerPreferences.getDefaults();

    public static Map<String, Object> getDefaults() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put(REMOVE_BRIDGE, "1");
        defaults.put(REMOVE_SYNTHETIC, "1");
        defaults.put(DECOMPILE_INNER, "1");
        defaults.put(DECOMPILE_CLASS_1_4, "1");
        defaults.put(DECOMPILE_ASSERTIONS, "1");
        defaults.put(HIDE_EMPTY_SUPER, "1");
        defaults.put(HIDE_DEFAULT_CONSTRUCTOR, "1");
        defaults.put(DECOMPILE_GENERIC_SIGNATURES, "1");
        defaults.put(NO_EXCEPTIONS_RETURN, "1");
        defaults.put(ENSURE_SYNCHRONIZED_MONITOR, "1");
        defaults.put(DECOMPILE_ENUM, "1");
        defaults.put(REMOVE_GET_CLASS_NEW, "1");
        defaults.put(LITERALS_AS_IS, "0");
        defaults.put(BOOLEAN_TRUE_ONE, "1");
        defaults.put(ASCII_STRING_CHARACTERS, "0");
        defaults.put(SYNTHETIC_NOT_SET, "0");
        defaults.put(UNDEFINED_PARAM_TYPE_OBJECT, "1");
        defaults.put(USE_DEBUG_VAR_NAMES, "1");
        defaults.put(USE_METHOD_PARAMETERS, "1");
        defaults.put(REMOVE_EMPTY_RANGES, "1");
        defaults.put(FINALLY_DEINLINE, "1");
        defaults.put(IDEA_NOT_NULL_ANNOTATION, "1");
        defaults.put(LAMBDA_TO_ANONYMOUS_CLASS, "0");
        defaults.put(BYTECODE_SOURCE_MAPPING, "0");
        defaults.put(DUMP_CODE_LINES, "0");
        defaults.put(IGNORE_INVALID_BYTECODE, "0");
        defaults.put(VERIFY_ANONYMOUS_CLASSES, "0");
        defaults.put(TERNARY_CONSTANT_SIMPLIFICATION, "0");
        defaults.put(OVERRIDE_ANNOTATION, "1");
        defaults.put(PATTERN_MATCHING, "1");
        defaults.put(EXPERIMENTAL_TRY_LOOP_FIX, "0");
        defaults.put(TERNARY_CONDITIONS, "0");
        defaults.put(SWITCH_EXPRESSIONS, "1");
        defaults.put(SHOW_HIDDEN_STATEMENTS, "0");
        defaults.put(SIMPLIFY_STACK_SECOND_PASS, "1");
        defaults.put(INCLUDE_ENTIRE_CLASSPATH, "0");
        defaults.put(INCLUDE_JAVA_RUNTIME, "0");
        defaults.put(EXPLICIT_GENERIC_ARGUMENTS, "0");
        defaults.put(INLINE_SIMPLE_LAMBDAS, "1");
        defaults.put(LOG_LEVEL, IFernflowerLogger.Severity.INFO.name());
        defaults.put(MAX_PROCESSING_METHOD, "0");
        defaults.put(RENAME_ENTITIES, "0");
        defaults.put(NEW_LINE_SEPARATOR, InterpreterUtil.IS_WINDOWS ? "0" : "1");
        defaults.put(INDENT_STRING, "   ");
        defaults.put(PREFERRED_LINE_LENGTH, "160");
        defaults.put(BANNER, "");
        defaults.put(ERROR_MESSAGE, "Please report this to the Quiltflower issue tracker, at https://github.com/QuiltMC/quiltflower/issues with a copy of the class file (if you have the rights to distribute it!)");
        defaults.put(UNIT_TEST_MODE, "0");
        defaults.put(DUMP_ORIGINAL_LINES, "0");
        defaults.put(THREADS, String.valueOf(Runtime.getRuntime().availableProcessors()));
        defaults.put(USE_JAD_VARNAMING, "0");
        defaults.put(SKIP_EXTRA_FILES, "0");
        defaults.put(WARN_INCONSISTENT_INNER_CLASSES, "1");
        defaults.put(DUMP_BYTECODE_ON_ERROR, "1");
        defaults.put(DUMP_EXCEPTION_ON_ERROR, "1");
        defaults.put(DECOMPILER_COMMENTS, "1");
        return Collections.unmodifiableMap(defaults);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Description {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }
}

