/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statements;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public final class InitializerProcessor {
    public static void extractInitializers(ClassWrapper wrapper) {
        MethodWrapper method = wrapper.getMethodWrapper("<clinit>", "()V");
        try {
            if (method != null && method.root != null) {
                InitializerProcessor.extractStaticInitializers(wrapper, method);
            }
        }
        catch (Throwable t) {
            StructMethod mt = method.methodStruct;
            String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + wrapper.getClassStruct().qualifiedName + " couldn't be written.";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
            method.decompileError = t;
        }
        InitializerProcessor.extractDynamicInitializers(wrapper);
        InitializerProcessor.liftConstructor(wrapper);
        if (DecompilerContext.getOption("hes")) {
            InitializerProcessor.hideEmptySuper(wrapper);
        }
    }

    private static void liftConstructor(ClassWrapper wrapper) {
        block0: for (MethodWrapper method : wrapper.getMethods()) {
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null) {
                return;
            }
            int index = 0;
            List<Exprent> lstExprents = firstData.getExprents();
            for (Exprent exprent : lstExprents) {
                int action = 0;
                if (exprent.type == 2) {
                    StructField structField;
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && assignExpr.getRight().type == 12 && (fExpr = (FieldExprent)assignExpr.getLeft()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && (structField = wrapper.getClassStruct().getField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) != null && structField.hasModifier(16)) {
                        action = 1;
                    }
                } else if (index > 0 && exprent.type == 8 && Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, true)) {
                    lstExprents.add(0, lstExprents.remove(index));
                    action = 2;
                }
                if (action != 1) continue block0;
                ++index;
            }
        }
    }

    private static void hideEmptySuper(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invExpr;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null || firstData.getExprents().isEmpty()) {
                return;
            }
            Exprent exprent = firstData.getExprents().get(0);
            if (exprent.type != 8 || !Statements.isInvocationInitConstructor(invExpr = (InvocationExprent)exprent, method, wrapper, false)) continue;
            List<VarVersionPair> mask = ExprUtil.getSyntheticParametersMask(invExpr.getClassname(), invExpr.getStringDescriptor(), invExpr.getLstParameters().size());
            boolean hideSuper = true;
            for (int i = 0; i < invExpr.getDescriptor().params.length; ++i) {
                ClassesProcessor.ClassNode node;
                if (mask != null && mask.get(i) != null) continue;
                VarType type = invExpr.getDescriptor().params[i];
                if (type.type == 8 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.value)) != null && (node.type == 2 || (node.access & 0x1000) != 0)) break;
                hideSuper = false;
                break;
            }
            if (!hideSuper) continue;
            firstData.getExprents().remove(0);
        }
    }

    public static void hideInitalizers(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            ClassesProcessor.ClassNode node;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String desc = mt.getDescriptor();
            if (!mt.isSynthetic() || !"<init>".equals(name)) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(desc);
            if (md.params.length <= 0) continue;
            VarType type = md.params[md.params.length - 1];
            if (type.type != 8 || (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.value)) == null || node.type != 2 && (node.access & 0x1000) == 0) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, desc));
        }
    }

    private static void extractStaticInitializers(ClassWrapper wrapper, MethodWrapper method) {
        RootStatement root = method.root;
        StructClass cl = wrapper.getClassStruct();
        HashSet<String> whitelist = new HashSet<String>();
        Statement firstData = Statements.findFirstData(root);
        if (firstData != null) {
            FieldExprent fExpr;
            AssignmentExprent assignExpr;
            boolean inlineInitializers = cl.hasModifier(512) || cl.hasModifier(16384);
            LinkedList<AssignmentExprent> exprentsToRemove = new LinkedList<AssignmentExprent>();
            HashMap<Integer, AssignmentExprent> nonFieldAssigns = new HashMap<Integer, AssignmentExprent>();
            ArrayList<String> seen = new ArrayList<String>();
            ArrayList<String> multiAssign = new ArrayList<String>();
            for (Exprent exprent : firstData.getExprents()) {
                if (exprent.type != 2) continue;
                assignExpr = (AssignmentExprent)exprent;
                if (assignExpr.getLeft().type != 5) continue;
                fExpr = (FieldExprent)assignExpr.getLeft();
                String name = fExpr.getName();
                if (seen.contains(name)) {
                    if (multiAssign.contains(name)) continue;
                    multiAssign.add(name);
                    continue;
                }
                seen.add(name);
            }
            Iterator<Exprent> itr = firstData.getExprents().iterator();
            while (itr.hasNext()) {
                Exprent exprent;
                exprent = itr.next();
                if (exprent.type == 2) {
                    assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5) {
                        Exprent instance;
                        NewExprent newExprent;
                        fExpr = (FieldExprent)assignExpr.getLeft();
                        if (!fExpr.isStatic() || !fExpr.getClassname().equals(cl.qualifiedName) || !cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) continue;
                        String keyField = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        boolean exprentIndependent = InitializerProcessor.isExprentIndependent(fExpr, assignExpr.getRight(), method, cl, whitelist, multiAssign, cl.getFields().getIndexByKey(keyField), true);
                        if (!inlineInitializers && !exprentIndependent || wrapper.getStaticFieldInitializers().containsKey(keyField)) continue;
                        if (exprentIndependent) {
                            wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                            whitelist.add(keyField);
                            itr.remove();
                            continue;
                        }
                        if (!(assignExpr.getRight() instanceof NewExprent) || (newExprent = (NewExprent)assignExpr.getRight()).getConstructor() == null || !((instance = newExprent.getConstructor().getInstance()) instanceof VarExprent) || !nonFieldAssigns.containsKey(((VarExprent)instance).getIndex())) continue;
                        AssignmentExprent nonFieldAssignment = (AssignmentExprent)nonFieldAssigns.remove(((VarExprent)instance).getIndex());
                        newExprent.getConstructor().setInstance(nonFieldAssignment.getRight());
                        exprentsToRemove.add(nonFieldAssignment);
                        wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                        whitelist.add(keyField);
                        itr.remove();
                        continue;
                    }
                    if (!inlineInitializers || !(assignExpr.getLeft() instanceof VarExprent)) continue;
                    nonFieldAssigns.put(((VarExprent)assignExpr.getLeft()).getIndex(), assignExpr);
                    continue;
                }
                if (inlineInitializers && !cl.hasModifier(512)) continue;
            }
            if (exprentsToRemove.size() > 0) {
                firstData.getExprents().removeAll(exprentsToRemove);
            }
        }
        if (cl.hasModifier(16384)) {
            for (StructField fd : cl.getFields()) {
                if (!fd.hasModifier(16384) || wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) != null) continue;
                method.addComment("$FF: Failed to inline enum fields");
                method.addErrorComment = true;
                break;
            }
        }
    }

    private static void extractDynamicInitializers(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        boolean isAnonymous = DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)cl.qualifiedName).type == 2;
        ArrayList<List<Exprent>> lstFirst = new ArrayList<List<Exprent>>();
        ArrayList<MethodWrapper> lstMethodWrappers = new ArrayList<MethodWrapper>();
        for (MethodWrapper method : wrapper.getMethods()) {
            Statement firstData;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null || (firstData = Statements.findFirstData(method.root)) == null || firstData.getExprents().isEmpty()) continue;
            Exprent exprent = firstData.getExprents().get(0);
            if (!isAnonymous && (exprent.type != 8 || !Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, false))) continue;
            lstFirst.add(firstData.getExprents());
            lstMethodWrappers.add(method);
        }
        if (lstFirst.isEmpty()) {
            return;
        }
        HashSet<String> whitelist = new HashSet<String>(wrapper.getStaticFieldInitializers().getLstKeys());
        int prev_fidx = 0;
        block1: while (true) {
            List lst;
            String fieldWithDescr = null;
            Exprent value = null;
            for (int i = 0; i < lstFirst.size(); ++i) {
                lst = (List)lstFirst.get(i);
                if (lst.size() < (isAnonymous ? 1 : 2)) {
                    return;
                }
                Exprent exprent = (Exprent)lst.get(isAnonymous ? 0 : 1);
                boolean found = false;
                if (exprent.type == 2) {
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && !(fExpr = (FieldExprent)assignExpr.getLeft()).isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) {
                        String fieldKey = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        int fidx = cl.getFields().getIndexByKey(fieldKey);
                        if (prev_fidx <= fidx && InitializerProcessor.isExprentIndependent(fExpr, assignExpr.getRight(), (MethodWrapper)lstMethodWrappers.get(i), cl, whitelist, new ArrayList<String>(), fidx, false)) {
                            prev_fidx = fidx;
                            if (fieldWithDescr == null) {
                                fieldWithDescr = fieldKey;
                                value = assignExpr.getRight();
                            } else if (!fieldWithDescr.equals(fieldKey) || !value.equals(assignExpr.getRight())) {
                                return;
                            }
                            found = true;
                        }
                    }
                }
                if (found) continue;
                return;
            }
            if (wrapper.getDynamicFieldInitializers().containsKey(fieldWithDescr)) break;
            value = InitializerProcessor.processDynamicInitializer(value);
            wrapper.getDynamicFieldInitializers().addWithKey(value, fieldWithDescr);
            whitelist.add(fieldWithDescr);
            Iterator iterator = lstFirst.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                lst = (List)iterator.next();
                lst.remove(isAnonymous ? 0 : 1);
            }
            break;
        }
    }

    private static Exprent processDynamicInitializer(Exprent expr) {
        if (expr.type == 6) {
            Exprent temp = expr;
            while (temp.type == 6 && ((FunctionExprent)temp).getFuncType() >= 14 && ((FunctionExprent)temp).getFuncType() <= 29) {
                temp = ((FunctionExprent)temp).getLstOperands().get(0);
            }
            if (temp.type == 6) {
                FunctionExprent func = (FunctionExprent)temp;
                func.unwrapBox();
                expr = func;
            }
        } else {
            expr = InitializerProcessor.processBoxingCast(expr);
        }
        return expr;
    }

    private static Exprent processBoxingCast(Exprent expr) {
        if (expr.type == 8 && ((InvocationExprent)expr).isUnboxingCall()) {
            Exprent inner = ((InvocationExprent)expr).getInstance();
            if (inner.type == 6 && ((FunctionExprent)inner).getFuncType() == 29) {
                inner.addBytecodeOffsets(expr.bytecode);
                expr = inner;
            }
        }
        return expr;
    }

    private static boolean isExprentIndependent(FieldExprent field, Exprent exprent, MethodWrapper method, StructClass cl, Set<String> whitelist, List<String> multiAssign, int fidx, boolean isStatic) {
        String keyField = InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor().descriptorString);
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        block5: for (Exprent expr : lst) {
            switch (expr.type) {
                case 12: {
                    VarVersionPair varPair = new VarVersionPair((VarExprent)expr);
                    if (method.varproc.getExternalVars().contains(varPair)) break;
                    String varName = method.varproc.getVarName(varPair);
                    if (varName.equals("this") || varName.endsWith(".this")) continue block5;
                    return false;
                }
                case 5: {
                    FieldExprent fexpr = (FieldExprent)expr;
                    if (cl.hasField(fexpr.getName(), fexpr.getDescriptor().descriptorString)) {
                        String key = InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString);
                        if (isStatic) {
                            if (multiAssign.contains(fexpr.getName())) {
                                return false;
                            }
                            if (!fexpr.isStatic()) {
                                return false;
                            }
                            if (cl.getFields().getIndexByKey(key) < fidx) continue block5;
                            fexpr.forceQualified(true);
                            break;
                        }
                        if (!whitelist.contains(key)) {
                            return false;
                        }
                        if (cl.getFields().getIndexByKey(key) <= fidx) continue block5;
                        return false;
                    }
                    if (fexpr.isStatic() || fexpr.getInstance() != null) break;
                    return false;
                }
                case 10: {
                    InitializerProcessor.qualifyFieldReferences((NewExprent)expr, cl, fidx);
                }
            }
        }
        return true;
    }

    private static void qualifyFieldReferences(NewExprent nexpr, StructClass cl, int fidx) {
        boolean isStatic = ((StructField)cl.getFields().get(fidx)).hasModifier(8);
        if (isStatic && nexpr.isLambda() && !nexpr.isMethodReference()) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(nexpr.getNewType().value);
            MethodWrapper wrapper = child.parent.getWrapper().getMethods().getWithKey(child.lambdaInformation.content_method_key);
            HashSet s = new HashSet();
            wrapper.getOrBuildGraph().iterateExprentsDeep(e -> {
                if (e.type == 5 || e.type == 10) {
                    s.add(e);
                }
                return 0;
            });
            block4: for (Exprent e2 : s) {
                switch (e2.type) {
                    case 5: {
                        FieldExprent fe = (FieldExprent)e2;
                        if (!cl.qualifiedName.equals(fe.getClassname()) || !fe.isStatic() || !cl.hasField(fe.getName(), fe.getDescriptor().descriptorString)) break;
                        String key = InterpreterUtil.makeUniqueKey(fe.getName(), fe.getDescriptor().descriptorString);
                        if (fe.getInstance() != null || cl.getFields().getIndexByKey(key) <= fidx) continue block4;
                        fe.forceQualified(true);
                        break;
                    }
                    case 10: {
                        InitializerProcessor.qualifyFieldReferences((NewExprent)e2, cl, fidx);
                    }
                }
            }
        }
    }
}

