/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

public final class BytecodeVersion
implements Comparable<BytecodeVersion> {
    public final int major;
    public final int minor;
    public static final int PREVIEW = 65535;
    public static final int MAJOR_1_0_2 = 45;
    public static final int MAJOR_1_2 = 46;
    public static final int MAJOR_1_3 = 47;
    public static final int MAJOR_1_4 = 48;
    public static final int MAJOR_5 = 49;
    public static final int MAJOR_6 = 50;
    public static final int MAJOR_7 = 51;
    public static final int MAJOR_8 = 52;
    public static final int MAJOR_9 = 53;
    public static final int MAJOR_10 = 54;
    public static final int MAJOR_11 = 55;
    public static final int MAJOR_12 = 56;
    public static final int MAJOR_13 = 57;
    public static final int MAJOR_14 = 58;
    public static final int MAJOR_15 = 59;
    public static final int MAJOR_16 = 60;
    public static final int MAJOR_17 = 61;

    public BytecodeVersion(int major, int minor) {
        this.major = major & 0xFFFF;
        this.minor = minor & 0xFFFF;
    }

    public boolean hasEnums() {
        return this.major >= 49;
    }

    public boolean hasInvokeDynamic() {
        return this.major >= 51;
    }

    public boolean hasLambdas() {
        return this.major >= 52;
    }

    public boolean hasIndyStringConcat() {
        return this.major >= 53;
    }

    public boolean hasOverride() {
        return this.major >= 49;
    }

    public boolean hasIfPatternMatching() {
        return this.major >= 60;
    }

    public boolean hasSwitchExpressions() {
        return this.major >= 60;
    }

    public boolean hasSealedClasses() {
        return this.previewReleased(59, 61);
    }

    public boolean hasLocalEnumsAndInterfaces() {
        return this.major >= 60;
    }

    public boolean has14ClassReferences() {
        return this.major <= 48;
    }

    public boolean hasNewTryWithResources() {
        return this.major >= 55;
    }

    public boolean predatesJava() {
        return this.major <= 45 && this.minor <= 2;
    }

    private boolean previewFrom(int previewStart) {
        return this.major >= previewStart && this.minor == 65535;
    }

    private boolean previewReleased(int previewStart, int releaseMajor) {
        return this.major >= releaseMajor || this.previewFrom(previewStart);
    }

    @Override
    public int compareTo(BytecodeVersion o) {
        int cmp = Integer.compare(this.major, o.major);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.minor, o.minor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytecodeVersion that = (BytecodeVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public int hashCode() {
        return this.major << 16 | this.minor;
    }
}

