/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Configuration
implements Map<String, String> {
    Configuration parent;
    Class clazz;
    Map<String, String> props;
    public static final String[] EMPTY_LIST = new String[0];
    public static final Pattern COMMA_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private static Pattern PARENT_KEY = Pattern.compile("\\$\\{(\\w+)\\}");
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());

    public Configuration(Class theClass, Configuration parent) {
        this(theClass);
        this.parent = parent;
    }

    public Configuration(Class theClass) {
        this.clazz = theClass;
    }

    public String getString(String key) {
        String value = null;
        if (this.props != null) {
            value = this.props.get(key);
        }
        Configuration p = this.parent;
        while (value == null && p != null) {
            value = p.get(key);
            p = p.parent;
        }
        if (value != null) {
            Matcher m = PARENT_KEY.matcher(value);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String p_key = m.group(1);
                String p_value = this.getString(p_key);
                if (p_key.equals("class_path")) {
                    p_value = this.clazz.getName().replace(".", "/").toLowerCase();
                } else if (p_key.equals("class_simpleName")) {
                    p_value = this.clazz.getSimpleName();
                } else {
                    p_value = this.getString(p_key);
                    if (p_value == null) {
                        Logger.getLogger(this.getClass().getName()).warning("no value for ${" + p_key + "} is defined");
                    }
                }
                m.appendReplacement(sb, p_value);
            }
            m.appendTail(sb);
            value = sb.toString();
        }
        return value;
    }

    public String getString(String key, String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue cannot be null");
        }
        String value = this.getString(key);
        return value == null ? defaultValue : value;
    }

    public int getInteger(String key, int Default) {
        String v = this.getString(key);
        if (v == null) {
            return Default;
        }
        try {
            int i = Integer.decode(v);
            return i;
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, null, e);
            return Default;
        }
    }

    public String[] getPropertyList(String key) {
        String v = this.getString(key);
        if (v == null) {
            return EMPTY_LIST;
        }
        return COMMA_SEPARATOR.split(v);
    }

    public boolean getBoolean(String key, boolean Default) {
        String b = this.getString(key);
        if (b == null) {
            return Default;
        }
        return Boolean.parseBoolean(b.trim());
    }

    public Color getColor(String key, Color Default) {
        String c = this.getString(key);
        if (c == null) {
            return Default;
        }
        try {
            return Color.decode(c);
        }
        catch (NumberFormatException e) {
            return Default;
        }
    }

    @Override
    public void putAll(Map config) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.putAll(config);
    }

    public Set<String> stringPropertyNames() {
        HashSet<String> propNames = new HashSet<String>();
        if (this.parent != null) {
            propNames.addAll(this.parent.stringPropertyNames());
        }
        if (this.props != null) {
            for (String k : this.props.keySet()) {
                propNames.add(k.toString());
            }
        }
        return propNames;
    }

    @Override
    public String put(String key, String value) {
        String old;
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return (old = this.props.put(key, value)) == null ? null : old.toString();
    }

    @Override
    public int size() {
        return this.props == null ? 0 : this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props == null ? true : this.props.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.props == null ? false : this.props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props == null ? false : this.props.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.props == null ? null : this.props.get(key);
    }

    @Override
    public String remove(Object key) {
        if (this.props == null) {
            return null;
        }
        String old = this.props.remove(key);
        return old == null ? null : old.toString();
    }

    @Override
    public void clear() {
        if (this.props != null) {
            this.props.clear();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.props == null) {
            return Collections.emptySet();
        }
        return this.props.keySet();
    }

    @Override
    public Collection<String> values() {
        if (this.props == null) {
            return Collections.emptySet();
        }
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.props == null) {
            return Collections.emptySet();
        }
        return this.props.entrySet();
    }

    public String toString() {
        return "Configuration " + this.clazz + " for " + this.parent;
    }

    public Set<StringKeyMatcher> getKeys(Pattern pattern) {
        HashSet<StringKeyMatcher> matched = new HashSet<StringKeyMatcher>();
        Set<String> all = this.stringPropertyNames();
        for (String k : all) {
            Matcher m = pattern.matcher(k);
            if (!m.matches()) continue;
            StringKeyMatcher skm = new StringKeyMatcher(k, m, m.groupCount() >= 1 ? m.group(1) : null, this.getString(k));
            matched.add(skm);
        }
        return matched;
    }

    public static class StringKeyMatcher {
        public final String key;
        public final Matcher matcher;
        public final String group1;
        public final String value;

        private StringKeyMatcher(String key, Matcher matcher, String group1, String value) {
            this.key = key;
            this.matcher = matcher;
            this.group1 = group1;
            this.value = value;
        }
    }
}

