/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.Configuration;

public class SyntaxView
extends PlainView {
    public static final String PROPERTY_RIGHT_MARGIN_COLOR = "RightMarginColor";
    public static final String PROPERTY_RIGHT_MARGIN_COLUMN = "RightMarginColumn";
    public static final String PROPERTY_SINGLE_COLOR_SELECT = "SingleColorSelect";
    private static final Logger log = Logger.getLogger(SyntaxView.class.getName());
    private SyntaxStyle DEFAULT_STYLE = SyntaxStyles.getInstance().getStyle(TokenType.DEFAULT);
    private final boolean singleColorSelect;
    private final int rightMarginColumn;
    private final SyntaxStyles styles;
    private static RenderingHints sysHints = null;

    public SyntaxView(Element element, Configuration config) {
        super(element);
        this.singleColorSelect = config.getBoolean(PROPERTY_SINGLE_COLOR_SELECT, false);
        this.rightMarginColumn = config.getInteger(PROPERTY_RIGHT_MARGIN_COLUMN, 0);
        this.styles = SyntaxStyles.read(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
        SyntaxView.setRenderingHits((Graphics2D)graphics);
        Font saveFont = graphics.getFont();
        Color saveColor = graphics.getColor();
        SyntaxDocument doc = (SyntaxDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        if (this.rightMarginColumn > 0) {
            int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
            int h = graphics.getFontMetrics().getHeight();
            graphics.drawLine(m_x, y, m_x, y - h);
        }
        try {
            Iterator<Token> i = doc.getTokens(p0, p1);
            int start = p0;
            while (i.hasNext()) {
                Token t = i.next();
                if (start < t.start) {
                    doc.getText(start, t.start - start, segment);
                    x = this.DEFAULT_STYLE.drawText(segment, x, y, graphics, this, start);
                }
                int l = t.length;
                int s = t.start;
                if (s < p0) {
                    l -= p0 - s;
                    s = p0;
                }
                if (s + l > p1) {
                    l = p1 - s;
                }
                doc.getText(s, l, segment);
                x = this.styles.drawText(segment, x, y, graphics, this, t);
                start = t.end();
            }
            if (start < p1) {
                doc.getText(start, p1 - start, segment);
                x = this.DEFAULT_STYLE.drawText(segment, x, y, graphics, this, start);
            }
        }
        catch (BadLocationException ex) {
            log.log(Level.SEVERE, "Requested: " + ex.offsetRequested(), ex);
        }
        finally {
            graphics.setFont(saveFont);
            graphics.setColor(saveColor);
        }
        return x;
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        if (this.singleColorSelect) {
            if (this.rightMarginColumn > 0) {
                int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
                int h = graphics.getFontMetrics().getHeight();
                graphics.drawLine(m_x, y, m_x, y - h);
            }
            return super.drawSelectedText(graphics, x, y, p0, p1);
        }
        return this.drawUnselectedText(graphics, x, y, p0, p1);
    }

    public static void setRenderingHits(Graphics2D g2d) {
        g2d.addRenderingHints(sysHints);
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        super.updateDamage(changes, a, f);
        Container host = this.getContainer();
        host.repaint();
    }

    static {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            sysHints = new RenderingHints(map);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

