/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class SyntaxStyles {
    public static final Pattern STYLE_PATTERN = Pattern.compile("Style\\.(\\w+)");
    Map<TokenType, SyntaxStyle> styles;
    private static SyntaxStyles instance = SyntaxStyles.createInstance();
    private static final Logger LOG = Logger.getLogger(SyntaxStyles.class.getName());
    private static SyntaxStyle DEFAULT_STYLE = new SyntaxStyle(Color.WHITE, 0);

    public void mergeStyles(Properties styles) {
        for (Map.Entry<Object, Object> e : styles.entrySet()) {
            String tokenType = e.getKey().toString();
            String style = e.getValue().toString();
            try {
                TokenType tt = TokenType.valueOf(tokenType);
                SyntaxStyle tokenStyle = new SyntaxStyle(style);
                this.put(tt, tokenStyle);
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("illegal token type or style for: " + tokenType);
            }
        }
    }

    private SyntaxStyles() {
    }

    private static SyntaxStyles createInstance() {
        SyntaxStyles syntaxstyles = new SyntaxStyles();
        Properties styles = JarServiceProvider.readProperties(SyntaxStyles.class);
        syntaxstyles.mergeStyles(styles);
        return syntaxstyles;
    }

    public static SyntaxStyles getInstance() {
        return instance;
    }

    public static SyntaxStyles read(Configuration config) {
        SyntaxStyles ss = SyntaxStyles.createInstance();
        for (Configuration.StringKeyMatcher m : config.getKeys(STYLE_PATTERN)) {
            String type = m.group1;
            try {
                ss.put(TokenType.valueOf(type), new SyntaxStyle(m.value));
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(SyntaxStyles.class.getName()).warning(String.format("Invalid Token Type [%s] for Style of ", type));
            }
        }
        return ss;
    }

    public void put(TokenType type, SyntaxStyle style) {
        if (this.styles == null) {
            this.styles = new HashMap<TokenType, SyntaxStyle>();
        }
        this.styles.put(type, style);
    }

    public SyntaxStyle getStyle(TokenType type) {
        if (this.styles != null && this.styles.containsKey((Object)type)) {
            this.styles.put(TokenType.IDENTIFIER, new SyntaxStyle(Color.WHITE, 1));
            this.styles.put(TokenType.TYPE, new SyntaxStyle(Color.WHITE, 1));
            this.styles.put(TokenType.TYPE2, new SyntaxStyle(Color.WHITE, 1));
            this.styles.put(TokenType.TYPE3, new SyntaxStyle(Color.WHITE, 1));
            this.styles.put(TokenType.STRING, new SyntaxStyle(Color.GREEN, 1));
            this.styles.put(TokenType.STRING2, new SyntaxStyle(Color.GREEN, 1));
            this.styles.put(TokenType.KEYWORD, new SyntaxStyle(new Color(16746561), 1));
            this.styles.put(TokenType.KEYWORD2, new SyntaxStyle(new Color(16746561), 1));
            this.styles.put(TokenType.OPERATOR, new SyntaxStyle(Color.WHITE, 1));
            this.styles.put(TokenType.COMMENT, new SyntaxStyle(new Color(6881024), 1));
            this.styles.put(TokenType.COMMENT2, new SyntaxStyle(new Color(6881024), 1));
            return this.styles.get((Object)type);
        }
        return DEFAULT_STYLE;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, Token token) {
        SyntaxStyle s = this.getStyle(token.type);
        return s.drawText(segment, x, y, graphics, e, token.start);
    }
}

